/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.tools.generate;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollectionWrapper;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.StandardCategoryNames;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.AttributeTypeFilter;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.openjump.core.ui.plugin.AbstractThreadedUiPlugIn;

public class PointLayerFromAttributeTablePlugIn
extends AbstractThreadedUiPlugIn {
    private final String sSidebar = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.generate.PointLayerFromAttributeTablePlugIn.descriptiontext");
    private final String sLAYER = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.generate.PointLayerFromAttributeTablePlugIn.Layer-with-attribute-table");
    private final String sXCoordAttrib = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.generate.PointLayerFromAttributeTablePlugIn.select-attribute-with-East-coordinate");
    private final String sYCoordAttrib = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.generate.PointLayerFromAttributeTablePlugIn.select-attribute-with-North-coordinate");
    private final String sZCoordAttrib = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.generate.PointLayerFromAttributeTablePlugIn.select-attribute-with-Height");
    private final String sHasZCoord = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.generate.PointLayerFromAttributeTablePlugIn.data-have-a-z-coordinate-/-height-value");
    private final String sPointsFrom = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.generate.PointLayerFromAttributeTablePlugIn.Points-from");
    private Layer inputLayer = null;
    private String selXAttribute = "";
    private String selYAttribute = "";
    private String selZAttribute = "";
    private boolean hasHeight = false;

    @Override
    public String getName() {
        return I18N.getInstance().get("org.openjump.core.ui.plugin.tools.generate.PointLayerFromAttributeTablePlugIn") + "...";
    }

    @Override
    public void initialize(PlugInContext context) throws Exception {
        context.getFeatureInstaller().addMainMenuPlugin(this, new String[]{MenuNames.TOOLS, MenuNames.TOOLS_GENERATE}, this.getName() + "...", false, null, PointLayerFromAttributeTablePlugIn.createEnableCheck(context.getWorkbenchContext()), -1);
    }

    public static MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithAssociatedTaskFrameMustBeActiveCheck()).add(checkFactory.createAtLeastNLayersMustExistCheck(1));
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        MultiInputDialog dialog = this.initDialog(context);
        dialog.setVisible(true);
        if (!dialog.wasOKPressed()) {
            return false;
        }
        this.getDialogValues(dialog);
        return true;
    }

    @Override
    public void run(TaskMonitor monitor, PlugInContext context) throws Exception {
        monitor.allowCancellationRequests();
        FeatureCollectionWrapper inputFC = this.inputLayer.getFeatureCollectionWrapper();
        int dXCoord = inputFC.getFeatureSchema().getAttributeIndex(this.selXAttribute);
        int dYCoord = inputFC.getFeatureSchema().getAttributeIndex(this.selYAttribute);
        int dZCoord = 0;
        if (this.hasHeight) {
            dZCoord = inputFC.getFeatureSchema().getAttributeIndex(this.selZAttribute);
        }
        FeatureDataset resultFC = new FeatureDataset(inputFC.getFeatureSchema().clone());
        GeometryFactory gf = new GeometryFactory();
        int i = 0;
        int numTransfers = inputFC.size();
        for (Feature origFeature : inputFC.getFeatures()) {
            monitor.report(i, numTransfers, I18N.getInstance().get("org.openjump.core.ui.plugin.tools.generate.PointLayerFromAttributeTablePlugIn.items-processed"));
            if (origFeature.getAttribute(dXCoord) == null || origFeature.getAttribute(dYCoord) == null) continue;
            double xc = ((Number)origFeature.getAttribute(dXCoord)).doubleValue();
            double yc = ((Number)origFeature.getAttribute(dYCoord)).doubleValue();
            Coordinate coord = new Coordinate(xc, yc);
            if (this.hasHeight && origFeature.getAttribute(dZCoord) != null) {
                coord.z = ((Number)origFeature.getAttribute(dZCoord)).doubleValue();
            }
            Point pt = gf.createPoint(coord);
            Feature newFeature = origFeature.clone(true);
            newFeature.setGeometry((Geometry)pt);
            resultFC.add(newFeature);
            ++i;
        }
        if (resultFC.size() > 0) {
            context.addLayer(StandardCategoryNames.RESULT, this.sPointsFrom + " " + this.inputLayer.getName(), resultFC);
        }
    }

    private MultiInputDialog initDialog(final PlugInContext context) {
        MultiInputDialog dialog = new MultiInputDialog(context.getWorkbenchFrame(), I18N.getInstance().get("org.openjump.core.ui.plugin.tools.generate.PointLayerFromAttributeTablePlugIn.Create-Point-Layer"), true);
        dialog.setSideBarDescription(this.sSidebar);
        dialog.addLayerComboBox(this.sLAYER, context.getCandidateLayer(0), null, context.getLayerManager());
        List<String> attributes = AttributeTypeFilter.NUMERIC_FILTER.filter(context.getCandidateLayer(0));
        String valAttribute = attributes.size() > 0 ? attributes.get(0) : null;
        final JComboBox<String> X_attributeBox = dialog.addComboBox(this.sXCoordAttrib, valAttribute, attributes, this.sXCoordAttrib);
        if (attributes.size() == 0) {
            X_attributeBox.setEnabled(false);
        }
        final JComboBox<String> Y_attributeBox = dialog.addComboBox(this.sYCoordAttrib, valAttribute, attributes, this.sYCoordAttrib);
        if (attributes.size() == 0) {
            Y_attributeBox.setEnabled(false);
        }
        dialog.addSeparator();
        final JCheckBox zCheckBox = dialog.addCheckBox(this.sHasZCoord, this.hasHeight);
        final JComboBox<String> Z_attributeBox = dialog.addComboBox(this.sZCoordAttrib, valAttribute, attributes, this.sZCoordAttrib);
        if (attributes.size() == 0) {
            Z_attributeBox.setEnabled(false);
        }
        if (!zCheckBox.isSelected()) {
            Z_attributeBox.setEnabled(false);
        }
        zCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Z_attributeBox.setEnabled(zCheckBox.isSelected());
                PointLayerFromAttributeTablePlugIn.this.hasHeight = zCheckBox.isSelected();
            }
        });
        dialog.getComboBox(this.sLAYER).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List<String> list = AttributeTypeFilter.NUMERIC_FILTER.filter(context.getCandidateLayer(0));
                if (list.size() == 0) {
                    X_attributeBox.setModel(new DefaultComboBoxModel<String>(new String[0]));
                    X_attributeBox.setEnabled(false);
                    Y_attributeBox.setModel(new DefaultComboBoxModel<String>(new String[0]));
                    Y_attributeBox.setEnabled(false);
                    Z_attributeBox.setModel(new DefaultComboBoxModel<String>(new String[0]));
                    Z_attributeBox.setEnabled(false);
                } else {
                    X_attributeBox.setModel(new DefaultComboBoxModel<String>(list.toArray(new String[0])));
                    X_attributeBox.setEnabled(true);
                    Y_attributeBox.setModel(new DefaultComboBoxModel<String>(list.toArray(new String[0])));
                    Y_attributeBox.setEnabled(true);
                    Z_attributeBox.setModel(new DefaultComboBoxModel<String>(list.toArray(new String[0])));
                    Z_attributeBox.setEnabled(true);
                    if (!PointLayerFromAttributeTablePlugIn.this.hasHeight) {
                        Z_attributeBox.setEnabled(false);
                    }
                }
            }
        });
        GUIUtil.centreOnWindow(dialog);
        return dialog;
    }

    private void getDialogValues(MultiInputDialog dialog) {
        this.inputLayer = dialog.getLayer(this.sLAYER);
        this.selXAttribute = dialog.getText(this.sXCoordAttrib);
        this.selYAttribute = dialog.getText(this.sYCoordAttrib);
        this.hasHeight = dialog.getBoolean(this.sHasZCoord);
        if (this.hasHeight) {
            this.selZAttribute = dialog.getText(this.sZCoordAttrib);
        }
    }
}

