/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.tools.aggregate;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.BasicFeature;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.feature.FeatureSchema;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openjump.core.ui.plugin.tools.aggregate.AttributeAggregator;

public class FeatureCollectionAggregator {
    private static final String KEY = FeatureCollectionAggregator.class.getName();
    private final FeatureCollection fc;
    private final List<String> keyAttributes;
    private final List<AttributeAggregator> aggregators;

    public FeatureCollectionAggregator(FeatureCollection fc, List<String> keyAttributes, List<AttributeAggregator> aggregators) throws AggregatorException {
        this.fc = fc;
        this.keyAttributes = keyAttributes;
        this.aggregators = aggregators;
        for (String attributeName : keyAttributes) {
            if (fc.getFeatureSchema().hasAttribute(attributeName)) continue;
            throw new AggregatorException(I18N.getInstance().get(KEY + ".attribute-does-not-exists", attributeName));
        }
        for (AttributeAggregator aggregator : aggregators) {
            if (fc.getFeatureSchema().hasAttribute(aggregator.getInputName())) continue;
            throw new AggregatorException(I18N.getInstance().get(KEY + ".attribute-does-not-exists", aggregator.getInputName()));
        }
    }

    public FeatureCollection getAggregatedFeatureCollection() {
        HashMap map = new HashMap();
        for (Feature feature : this.fc.getFeatures()) {
            Key key = new Key(feature, this.keyAttributes);
            ArrayList<AttributeAggregator> featureAggregators = (ArrayList<AttributeAggregator>)map.get(key);
            if (featureAggregators == null) {
                featureAggregators = new ArrayList<AttributeAggregator>();
                for (AttributeAggregator agg : this.aggregators) {
                    featureAggregators.add(new AttributeAggregator(agg.getInputName(), agg.getAggregator().clone(), agg.getOutputName()));
                }
                map.put(key, featureAggregators);
            }
            for (AttributeAggregator aagg : featureAggregators) {
                Object agg = aagg.getAggregator();
                agg.addValue(feature.getAttribute(aagg.getInputName()));
            }
        }
        FeatureSchema newSchema = this.getFeatureSchema();
        FeatureDataset result = new FeatureDataset(newSchema);
        for (Map.Entry entry : map.entrySet()) {
            BasicFeature feature = new BasicFeature(newSchema);
            for (String keyAtt : this.keyAttributes) {
                feature.setAttribute(keyAtt, ((Key)entry.getKey()).map.get(keyAtt));
            }
            for (Object agg : (List)entry.getValue()) {
                feature.setAttribute(((AttributeAggregator)agg).getOutputName(), ((AttributeAggregator)agg).getAggregator().getResult());
            }
            result.add(feature);
        }
        return result;
    }

    private FeatureSchema getFeatureSchema() {
        FeatureSchema oldSchema = this.fc.getFeatureSchema();
        FeatureSchema newSchema = new FeatureSchema();
        for (String attributeName : this.keyAttributes) {
            newSchema.addAttribute(attributeName, oldSchema.getAttributeType(oldSchema.getAttributeIndex(attributeName)));
        }
        for (AttributeAggregator agg : this.aggregators) {
            newSchema.addAttribute(agg.getOutputName(), agg.getAggregator().getOutputAttributeType());
        }
        return newSchema;
    }

    private static class AggregatorException
    extends Exception {
        AggregatorException(String message) {
            super(message);
        }
    }

    public static class Key {
        private final Map<String, Object> map = new HashMap<String, Object>();

        Key(Feature feature, List<String> attributes) {
            for (String name : attributes) {
                this.map.put(name, feature.getAttribute(name));
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            return this.map.equals(key.map);
        }

        public int hashCode() {
            return this.map.hashCode();
        }
    }
}

