/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.tools.aggregate;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.AttributeType;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openjump.core.ui.plugin.tools.aggregate.Aggregator;

abstract class AbstractAggregator<T>
implements Aggregator<T> {
    private final AttributeType outputType;
    private final List<T> values;
    private boolean ignoreNull;
    private Map<String, Object> parameters;

    AbstractAggregator(AttributeType outputType, boolean ignoreNull, Object ... kv) {
        this.outputType = outputType;
        this.ignoreNull = ignoreNull;
        if (kv != null) {
            if (kv.length % 2 == 1) {
                throw new IllegalArgumentException("Aggregator constructor should have an even number of arguments representing successively keys and values");
            }
            this.parameters = new LinkedHashMap<String, Object>();
            for (int i = 0; i < kv.length / 2; i += 2) {
                this.parameters.put(kv[i].toString(), kv[i + 1]);
            }
        }
        this.values = new ArrayList<T>();
    }

    @Override
    public Set<String> getParameters() {
        return this.parameters == null ? new HashSet() : this.parameters.keySet();
    }

    @Override
    public void setParameter(String name, Object value) {
        if (this.parameters == null) {
            this.parameters = new LinkedHashMap<String, Object>();
        }
        this.parameters.put(name, value);
    }

    @Override
    public Object getParameter(String name) {
        return this.parameters == null ? null : this.parameters.get(name);
    }

    @Override
    public String getName() {
        String simpleName = this.getClass().getSimpleName();
        return I18N.getInstance().get(Aggregator.class.getName() + "." + simpleName.substring(simpleName.indexOf(36) + 1));
    }

    @Override
    public boolean ignoreNull() {
        return this.ignoreNull;
    }

    @Override
    public void setIgnoreNull(boolean ignoreNull) {
        this.ignoreNull = ignoreNull;
    }

    @Override
    public void addValue(T object) {
        if (object != null || !this.ignoreNull) {
            this.values.add(object);
        }
    }

    @Override
    public List<T> getValues() {
        return this.values;
    }

    @Override
    public AttributeType getOutputAttributeType() {
        return this.outputType;
    }

    @Override
    public abstract Object getResult();

    @Override
    public void reset() {
        if (this.values != null) {
            this.values.clear();
        }
    }

    @Override
    public abstract Aggregator<?> clone();

    public String toString() {
        return this.getName();
    }
}

