/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.tools;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Category;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.model.StandardCategoryNames;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import com.vividsolutions.jump.workbench.ui.SelectionManagerProxy;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import java.util.Collection;
import javax.swing.JComponent;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.openjump.core.geomutils.GeoUtils;

public class PlumePlugIn
extends AbstractPlugIn {
    private WorkbenchContext workbenchContext;
    private static final String sNew = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.JoinWithArcPlugIn.New");
    private static final String sTheradius = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.JoinWithArcPlugIn.The-arc-radius");
    private static final String selectLineStrings = I18N.getInstance().get("ui.cursortool.SelectLineStringsTool.select-linestrings");
    private static final String RADIUS = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.JoinWithArcPlugIn.Radius");
    private static final String RADIUS1 = RADIUS + " 1";
    private static final String RADIUS2 = RADIUS + " 2";
    private double radius1 = 5.0;
    private double radius2 = 50.0;

    @Override
    public void initialize(PlugInContext context) throws Exception {
        super.initialize(context);
        this.workbenchContext = context.getWorkbenchContext();
        context.getFeatureInstaller().addMainMenuPlugin(this, new String[]{MenuNames.TOOLS, MenuNames.TOOLS_ANALYSIS}, this.getName() + "...", false, IconLoader.icon("buffer_plume.gif"), this.createEnableCheck(this.workbenchContext));
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        this.reportNothingToUndoYet(context);
        Collection<Feature> selectedFeatures = context.getLayerViewPanel().getSelectionManager().getFeaturesWithSelectedItems();
        MultiInputDialog dialog = new MultiInputDialog(context.getWorkbenchFrame(), this.getName(), true);
        this.setDialogValues(dialog, context);
        dialog.setVisible(true);
        if (!dialog.wasOKPressed()) {
            return false;
        }
        this.getDialogValues(dialog);
        Geometry plume = null;
        if (selectedFeatures.size() != 1) {
            return false;
        }
        Geometry geo = selectedFeatures.iterator().next().getGeometry();
        if (geo instanceof LineString) {
            plume = GeoUtils.createPlume(geo.getCoordinates(), this.radius1, this.radius2);
        }
        if (plume != null) {
            Feature currFeature = selectedFeatures.iterator().next();
            Feature newFeature = currFeature.clone();
            newFeature.setGeometry(plume);
            Collection<Category> selectedCategories = context.getLayerNamePanel().getSelectedCategories();
            LayerManager layerManager = context.getLayerManager();
            FeatureDataset newFeatures = new FeatureDataset(currFeature.getSchema());
            newFeatures.add(newFeature);
            layerManager.addLayer(selectedCategories.isEmpty() ? StandardCategoryNames.WORKING : selectedCategories.iterator().next().toString(), layerManager.uniqueLayerName(sNew), newFeatures);
            layerManager.getLayer(0).setFeatureCollectionModified(true);
            layerManager.getLayer(0).setEditable(true);
        }
        return true;
    }

    private void setDialogValues(MultiInputDialog dialog, PlugInContext context) {
        dialog.setSideBarImage(IconLoader.icon("buffer_plume_image.png"));
        dialog.addDoubleField(RADIUS1, this.radius1, 6, sTheradius);
        dialog.addDoubleField(RADIUS2, this.radius2, 6, sTheradius);
    }

    private void getDialogValues(MultiInputDialog dialog) {
        this.radius1 = dialog.getDouble(RADIUS1);
        this.radius2 = dialog.getDouble(RADIUS2);
    }

    public MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerViewPanelMustBeActiveCheck()).add(checkFactory.createOnlyOneLayerMayHaveSelectedFeaturesCheck()).add(checkFactory.createExactlyNFeaturesMustHaveSelectedItemsCheck(1)).add(this.onlyOneLinestringMayBeSelected(workbenchContext));
    }

    public EnableCheck onlyOneLinestringMayBeSelected(final WorkbenchContext workbenchContext) {
        return new EnableCheck(){

            @Override
            public String check(JComponent component) {
                Collection<Geometry> selectedItems = ((SelectionManagerProxy)((Object)workbenchContext.getWorkbench().getFrame().getActiveInternalFrame())).getSelectionManager().getSelectedItems();
                if (!selectedItems.isEmpty() && selectedItems.iterator().next() instanceof LineString) {
                    return null;
                }
                return selectLineStrings;
            }
        };
    }
}

