/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.tools;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.BasicFeature;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.tools.AttributeMapping;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.StandardCategoryNames;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.plugin.ThreadedBasePlugIn;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.GenericNames;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.locationtech.jts.algorithm.locate.SimplePointInAreaLocator;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.util.LinearComponentExtracter;
import org.locationtech.jts.index.strtree.STRtree;
import org.locationtech.jts.operation.linemerge.LineMerger;
import org.locationtech.jts.operation.polygonize.Polygonizer;
import org.openjump.core.geomutils.algorithm.IntersectGeometries;

public class IntersectPolygonLayersPlugIn
extends ThreadedBasePlugIn {
    private static final String LAYER1 = GenericNames.LAYER_A;
    private static final String LAYER2 = GenericNames.LAYER_B;
    private static final String sTRANSFER = I18N.getInstance().get("org.openjump.plugin.tools.IntersectPolygonLayersPlugIn.Transfer-attributes");
    private String sDescription = "Intersects all geometries of two layers that contain both polygons. Note: The Planar Graph function provides similar functionality.";
    private Layer layer1 = null;
    private Layer layer2 = null;
    private boolean exceptionThrown = false;
    private boolean transferAtt = true;

    @Override
    public void initialize(PlugInContext context) throws Exception {
        context.getFeatureInstaller().addMainMenuPlugin(this, new String[]{MenuNames.TOOLS, MenuNames.TOOLS_ANALYSIS}, this.getName(), false, null, new MultiEnableCheck().add(EnableCheckFactory.getInstance(context.getWorkbenchContext()).createTaskWindowMustBeActiveCheck()).add(EnableCheckFactory.getInstance(context.getWorkbenchContext()).createAtLeastNLayersMustExistCheck(1)));
        this.sDescription = I18N.getInstance().get("org.openjump.plugin.tools.IntersectPolygonLayersPlugIn.sDescrition");
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        MultiInputDialog dialog = new MultiInputDialog(context.getWorkbenchFrame(), this.getName(), true);
        if (this.layer1 == null) {
            this.layer1 = context.getCandidateLayer(0);
            this.layer2 = context.getCandidateLayer(0);
        }
        this.setDialogValues(dialog, context);
        GUIUtil.centreOnWindow(dialog);
        dialog.setVisible(true);
        if (!dialog.wasOKPressed()) {
            return false;
        }
        this.getDialogValues(dialog);
        return true;
    }

    @Override
    public String getName() {
        return I18N.getInstance().get("org.openjump.plugin.tools.IntersectPolygonLayersPlugIn.Intersect-Polygon-Layers") + "...";
    }

    @Override
    public void run(TaskMonitor monitor, PlugInContext context) throws Exception {
        monitor.allowCancellationRequests();
        FeatureCollection resultColl = this.runIntersectionNew(this.layer1.getFeatureCollectionWrapper(), this.layer2.getFeatureCollectionWrapper(), this.transferAtt, monitor, context);
        if (resultColl != null && resultColl.size() > 0) {
            context.addLayer(StandardCategoryNames.RESULT, I18N.getInstance().get("ui.plugin.analysis.GeometryFunctionPlugIn.intersection") + "-" + this.layer1.getName() + "-" + this.layer2.getName(), resultColl);
        }
        if (this.exceptionThrown) {
            context.getWorkbenchFrame().warnUser(I18N.getInstance().get("org.openjump.sigle.plugin.SpatialJoinPlugIn.Error-while-executing-spatial-function"));
        }
    }

    private FeatureCollection runIntersectionNew(FeatureCollection fcA, FeatureCollection fcB, boolean transferAttributes, TaskMonitor monitor, PlugInContext context) {
        monitor.report("Extract linearComponents and create indexes");
        Collection linearComponents = new ArrayList();
        for (Feature f : fcA.getFeatures()) {
            LinearComponentExtracter.getLines((Geometry)f.getGeometry(), linearComponents);
        }
        for (Feature f : fcB.getFeatures()) {
            LinearComponentExtracter.getLines((Geometry)f.getGeometry(), linearComponents);
        }
        monitor.report("De-duplicate segments");
        HashSet<LineString> lines = new HashSet<LineString>();
        GeometryFactory gf = new GeometryFactory();
        for (LineString linearComponent : linearComponents) {
            Coordinate[] coordinates = linearComponent.getCoordinates();
            for (int i = 1; i < coordinates.length; ++i) {
                LineString line = coordinates[i - 1].x < coordinates[i].x ? gf.createLineString(new Coordinate[]{coordinates[i - 1], coordinates[i]}) : (coordinates[i - 1].x > coordinates[i].x ? gf.createLineString(new Coordinate[]{coordinates[i], coordinates[i - 1]}) : (coordinates[i - 1].y < coordinates[i].y ? gf.createLineString(new Coordinate[]{coordinates[i - 1], coordinates[i]}) : gf.createLineString(new Coordinate[]{coordinates[i], coordinates[i - 1]})));
                lines.add(line);
            }
        }
        linearComponents.clear();
        monitor.report("Merge segments into LineStrings");
        LineMerger merger = new LineMerger();
        merger.add(lines);
        lines.clear();
        linearComponents = merger.getMergedLineStrings();
        monitor.report("Node the linework");
        Collection nodedLines = IntersectGeometries.nodeLines(linearComponents);
        linearComponents.clear();
        Polygonizer polygonizer = new Polygonizer();
        polygonizer.add(nodedLines);
        nodedLines.clear();
        monitor.report("Polygonize");
        Collection withoutIntersection = polygonizer.getPolygons();
        polygonizer = null;
        monitor.report("Attribute mapping");
        AttributeMapping mapping = new AttributeMapping(fcA.getFeatureSchema(), fcB.getFeatureSchema());
        STRtree treeA = new STRtree();
        STRtree treeB = new STRtree();
        for (Feature f : fcA.getFeatures()) {
            treeA.insert(f.getGeometry().getEnvelopeInternal(), (Object)f);
        }
        for (Feature f : fcB.getFeatures()) {
            treeB.insert(f.getGeometry().getEnvelopeInternal(), (Object)f);
        }
        FeatureDataset fd = new FeatureDataset(mapping.createSchema("Geometry"));
        int count = 0;
        ArrayList<Integer> errorsInA = new ArrayList<Integer>();
        ArrayList<Integer> errorsInB = new ArrayList<Integer>();
        for (Geometry geom : withoutIntersection) {
            monitor.report(count++, withoutIntersection.size(), "polygon");
            boolean errorInA = false;
            boolean errorInB = false;
            Coordinate coord = geom.getInteriorPoint().getCoordinate();
            Envelope envelope = new Envelope(coord, coord);
            BasicFeature f = new BasicFeature(fd.getFeatureSchema());
            Feature featureA = null;
            Feature featureB = null;
            List candidatesA = treeA.query(envelope);
            int foundCountA = 0;
            for (Feature ftemp : candidatesA) {
                if (SimplePointInAreaLocator.locate((Coordinate)coord, (Geometry)ftemp.getGeometry()) != 0) continue;
                ++foundCountA;
                featureA = ftemp;
            }
            if (foundCountA > 1) {
                errorInA = true;
                errorsInA.add(f.getID());
            }
            List candidatesB = treeB.query(envelope);
            int foundCountB = 0;
            for (Feature ftemp : candidatesB) {
                if (SimplePointInAreaLocator.locate((Coordinate)coord, (Geometry)ftemp.getGeometry()) != 0) continue;
                ++foundCountB;
                featureB = ftemp;
            }
            if (foundCountB > 1) {
                errorInB = true;
                errorsInB.add(f.getID());
            }
            if (foundCountA <= 0 && foundCountB <= 0) continue;
            if (errorInA) {
                featureA = IntersectPolygonLayersPlugIn.resetFeatureValuesToNull(featureA);
            }
            if (errorInB) {
                featureB = IntersectPolygonLayersPlugIn.resetFeatureValuesToNull(featureB);
            }
            mapping.transferAttributes(featureA, featureB, f);
            f.setGeometry((Geometry)geom.clone());
            fd.add(f);
        }
        if (context != null && (errorsInA.size() > 0 || errorsInB.size() > 0)) {
            String errorStrg = I18N.getInstance().get("org.openjump.plugin.tools.IntersectPolygonLayersPlugIn.Found-more-than-one-source-feature-in-Layer");
            String layers = "";
            if (errorsInA.size() > 0) {
                layers = layers + " " + GenericNames.LAYER_A;
                context.getWorkbenchFrame().getOutputFrame().createNewDocument();
                context.getWorkbenchFrame().getOutputFrame().addText("IntersectPolygonLayersPlugIn: " + errorStrg + ": " + GenericNames.LAYER_A + ".\nReason: The Layer contains probably objects that overlay each other. Will set polygon values of items with FID: " + errorsInA + " to NaN. Use " + I18N.getInstance().get("org.openjump.sigle.plugin.SpatialJoinPlugIn.Transfer-Attributes") + " or " + I18N.getInstance().get("org.openjump.core.ui.plugin.tools.JoinAttributesSpatiallyPlugIn.Join-Attributes-Spatially") + " functions to obtain atributes from " + GenericNames.LAYER_A);
            }
            if (errorsInB.size() > 0) {
                layers = layers + " " + GenericNames.LAYER_B;
                context.getWorkbenchFrame().getOutputFrame().createNewDocument();
                context.getWorkbenchFrame().getOutputFrame().addText("IntersectPolygonLayersPlugIn: " + errorStrg + ": " + GenericNames.LAYER_B + ".\nReason: The Layer contains probably objects that overlay each other. Will set polygon values of items with FID: " + errorsInB + " to NaN. Use " + I18N.getInstance().get("org.openjump.sigle.plugin.SpatialJoinPlugIn.Transfer-Attributes") + " or " + I18N.getInstance().get("org.openjump.core.ui.plugin.tools.JoinAttributesSpatiallyPlugIn.Join-Attributes-Spatially") + " functions to obtain atributes from " + GenericNames.LAYER_B);
            }
            context.getWorkbenchFrame().warnUser(errorStrg + layers);
        }
        return fd;
    }

    static Feature resetFeatureValuesToNull(Feature f) {
        Feature ftemp = f.clone(true);
        FeatureSchema fs = ftemp.getSchema();
        for (int i = 0; i < fs.getAttributeCount(); ++i) {
            AttributeType type = fs.getAttributeType(i);
            if (type.equals(AttributeType.GEOMETRY)) continue;
            if (type.equals(AttributeType.DOUBLE)) {
                ftemp.setAttribute(i, null);
            }
            if (type.equals(AttributeType.INTEGER)) {
                ftemp.setAttribute(i, null);
            }
            if (type.equals(AttributeType.LONG)) {
                ftemp.setAttribute(i, null);
            }
            if (type.equals(AttributeType.STRING)) {
                ftemp.setAttribute(i, null);
            }
            if (type.equals(AttributeType.OBJECT)) {
                ftemp.setAttribute(i, null);
            }
            if (type.equals(AttributeType.DATE)) {
                ftemp.setAttribute(i, null);
            }
            if (!type.equals(AttributeType.BOOLEAN)) continue;
            ftemp.setAttribute(i, null);
        }
        return ftemp;
    }

    private void setDialogValues(MultiInputDialog dialog, PlugInContext context) {
        dialog.setSideBarDescription(this.sDescription);
        dialog.addLayerComboBox(LAYER1, this.layer1, context.getLayerManager());
        dialog.addLayerComboBox(LAYER2, this.layer2, context.getLayerManager());
    }

    private void getDialogValues(MultiInputDialog dialog) {
        this.layer1 = dialog.getLayer(LAYER1);
        this.layer2 = dialog.getLayer(LAYER2);
    }
}

