/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.tools;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureCollectionWrapper;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.feature.IndexedFeatureCollection;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.StandardCategoryNames;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.plugin.ThreadedPlugIn;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.GenericNames;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import com.vividsolutions.jump.workbench.ui.plugin.FeatureInstaller;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.JMenuItem;
import org.locationtech.jts.geom.Envelope;

public final class DeleteDuplicateGeometriesPlugIn
extends AbstractPlugIn
implements ThreadedPlugIn {
    private Layer confSourceLayer = null;
    private boolean confDeleteOnlySameAttributes = false;
    private boolean confKeepDeletedFeatures = false;
    private String langName = "Delete Duplicate Geometries";
    private String langDescription = "deletes features with similar geometry";
    private String langSourceLayer = "select layer";
    private String langDeleteOnlySameAttributes = "delete only if attributes are the same";
    private String langMonitorCheckedFeatures = "checked";
    private String langResultNameCleaned = "cleaned";
    private String langResultNameDeleted = "deleted";
    private String langKeepDeletedFeatures = "keep duplicate features";

    @Override
    public String getName() {
        return this.langName;
    }

    @Override
    public void initialize(PlugInContext context) throws Exception {
        super.initialize(context);
        this.initializeLanguageStrings();
        this.initializeMenuItem(context);
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        this.reportNothingToUndoYet(context);
        MultiInputDialog dialog = new MultiInputDialog(context.getWorkbenchFrame(), this.getName(), true);
        this.setDialogValues(dialog, context);
        GUIUtil.centreOnWindow(dialog);
        dialog.setVisible(true);
        if (!dialog.wasOKPressed()) {
            return false;
        }
        this.getDialogValues(dialog);
        return true;
    }

    @Override
    public void run(TaskMonitor monitor, PlugInContext context) throws Exception {
        String resultLayerName = this.confSourceLayer.getName() + "-" + this.langResultNameCleaned;
        String deletedLayerName = this.confSourceLayer.getName() + "-" + this.langResultNameDeleted;
        FeatureCollection[] results = this.deleteDuplicateGeometries(monitor);
        context.addLayer(StandardCategoryNames.RESULT, resultLayerName, results[0]);
        if (this.confKeepDeletedFeatures) {
            context.addLayer(StandardCategoryNames.RESULT, deletedLayerName, results[1]);
        }
        System.gc();
    }

    private void initializeLanguageStrings() {
        String langPrefix = this.getClass().getCanonicalName();
        this.langSourceLayer = GenericNames.SELECT_LAYER;
        this.langName = I18N.getInstance().get(langPrefix + ".Delete-Duplicate-Geometries");
        this.langDescription = I18N.getInstance().get(langPrefix + ".deletes-features-with-similar-geometry");
        this.langDeleteOnlySameAttributes = I18N.getInstance().get(langPrefix + ".delete-only-if-attributes-are-the-same");
        this.langMonitorCheckedFeatures = I18N.getInstance().get(langPrefix + ".checked");
        this.langResultNameCleaned = I18N.getInstance().get(langPrefix + ".cleaned");
        this.langResultNameDeleted = I18N.getInstance().get(langPrefix + ".deleted");
        this.langKeepDeletedFeatures = I18N.getInstance().get(langPrefix + ".keep-deleted-features");
    }

    private void initializeMenuItem(PlugInContext context) {
        FeatureInstaller installer = context.getFeatureInstaller();
        String[] menuPath = new String[]{MenuNames.TOOLS, MenuNames.TOOLS_QA};
        installer.addMainMenuItem(this, menuPath, new JMenuItem(this.getName() + "..."), this.createEnableCheck(context.getWorkbenchContext()));
    }

    public MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createAtLeastNLayersMustExistCheck(1));
    }

    private void setDialogValues(MultiInputDialog dialog, PlugInContext context) {
        dialog.setSideBarDescription(this.langDescription);
        dialog.addLayerComboBox(this.langSourceLayer, context.getCandidateLayer(0), null, context.getLayerManager());
        dialog.addCheckBox(this.langDeleteOnlySameAttributes, this.confDeleteOnlySameAttributes);
        dialog.addCheckBox(this.langKeepDeletedFeatures, this.confKeepDeletedFeatures);
    }

    private void getDialogValues(MultiInputDialog dialog) {
        this.confSourceLayer = dialog.getLayer(this.langSourceLayer);
        this.confDeleteOnlySameAttributes = dialog.getBoolean(this.langDeleteOnlySameAttributes);
        this.confKeepDeletedFeatures = dialog.getBoolean(this.langKeepDeletedFeatures);
    }

    private FeatureCollection[] deleteDuplicateGeometries(TaskMonitor monitor) {
        FeatureCollectionWrapper sourceDataset = this.confSourceLayer.getFeatureCollectionWrapper();
        FeatureSchema sourceSchema = sourceDataset.getFeatureSchema();
        IndexedFeatureCollection indexedDataset = new IndexedFeatureCollection(sourceDataset);
        HashSet<Integer> duplicateIDs = new HashSet<Integer>();
        List<Feature> sourceFeatures = sourceDataset.getFeatures();
        List<Feature> emptyFeatures = this.getEmptyFeatures(sourceFeatures);
        int checkCount = 0;
        int checkSize = sourceDataset.size();
        for (Feature feature : sourceFeatures) {
            monitor.report(checkCount, checkSize, this.langMonitorCheckedFeatures);
            List<Feature> candidates = null;
            if (feature.getGeometry().isEmpty()) {
                candidates = emptyFeatures;
            } else {
                Envelope envelope = feature.getGeometry().getEnvelopeInternal();
                candidates = indexedDataset.query(envelope);
            }
            for (Feature candidate : candidates) {
                if (candidate.getID() <= feature.getID() || !feature.getGeometry().equalsNorm(candidate.getGeometry())) continue;
                if (this.confDeleteOnlySameAttributes) {
                    if (!this.areAttributesEqual(feature, candidate, sourceSchema)) continue;
                    duplicateIDs.add(candidate.getID());
                    continue;
                }
                duplicateIDs.add(candidate.getID());
            }
            ++checkCount;
        }
        FeatureDataset resultDataset = new FeatureDataset(sourceSchema);
        FeatureDataset duplicateDataset = new FeatureDataset(sourceSchema);
        for (Feature feature : sourceFeatures) {
            if (!duplicateIDs.contains(feature.getID())) {
                resultDataset.add(feature.clone(true));
                continue;
            }
            duplicateDataset.add(feature.clone(true));
        }
        return new FeatureCollection[]{resultDataset, duplicateDataset};
    }

    private boolean areAttributesEqual(Feature feature, Feature candidate, FeatureSchema schema) {
        boolean attributesEqual = true;
        int geometryIndex = schema.getGeometryIndex();
        for (int index = 0; index < schema.getAttributeCount(); ++index) {
            if (index == geometryIndex) continue;
            Object attr1 = feature.getAttribute(index);
            Object attr2 = candidate.getAttribute(index);
            if (attr1 == null && attr2 == null || attr1 != null && attr2 != null && attr1.equals(attr2)) continue;
            attributesEqual = false;
            break;
        }
        return attributesEqual;
    }

    List<Feature> getEmptyFeatures(List<Feature> features) {
        ArrayList<Feature> list = new ArrayList<Feature>();
        for (Feature f : features) {
            if (!f.getGeometry().isEmpty()) continue;
            list.add(f);
        }
        return list;
    }
}

