/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.tools;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.BasicFeature;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollectionWrapper;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.model.StandardCategoryNames;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import com.vividsolutions.jump.workbench.ui.plugin.FeatureInstaller;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Polygon;
import org.openjump.core.ui.plugin.AbstractThreadedUiPlugIn;

public class Add3DGeometryAttributesPlugIn
extends AbstractThreadedUiPlugIn {
    private static String LAYER = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.Add3DGeometryAttributesPlugIn.layer");
    private static String GEOM_ATTRIBUTES = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.Add3DGeometryAttributesPlugIn.3d-geometry-attributes");
    private static String COMPUTE_ATTRIBUTES = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.Add3DGeometryAttributesPlugIn.compute-attributes");
    private static String START_Z = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.Add3DGeometryAttributesPlugIn.start-z");
    private static String ADD_START_Z = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.Add3DGeometryAttributesPlugIn.add-start-z");
    private static String END_Z = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.Add3DGeometryAttributesPlugIn.end-z");
    private static String ADD_END_Z = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.Add3DGeometryAttributesPlugIn.add-end-z");
    private static String MIN_Z = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.Add3DGeometryAttributesPlugIn.min-z");
    private static String ADD_MIN_Z = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.Add3DGeometryAttributesPlugIn.add-min-z");
    private static String MAX_Z = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.Add3DGeometryAttributesPlugIn.max-z");
    private static String ADD_MAX_Z = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.Add3DGeometryAttributesPlugIn.add-max-z");
    private static String WEIGHTED_MEAN_Z = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.Add3DGeometryAttributesPlugIn.weighted-mean-z");
    private static String ADD_WEIGHTED_MEAN_Z = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.Add3DGeometryAttributesPlugIn.add-weighted-mean-z");
    private static String LENGTH_3D = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.Add3DGeometryAttributesPlugIn.length-3d");
    private static String ADD_LENGTH_3D = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.Add3DGeometryAttributesPlugIn.add-length-3d");
    private static String MAX_DOWN_SLOPE = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.Add3DGeometryAttributesPlugIn.max-downslope");
    private static String ADD_MAX_DOWNSLOPE = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.Add3DGeometryAttributesPlugIn.add-max-downslope");
    private static String MAX_UPSLOPE = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.Add3DGeometryAttributesPlugIn.max-upslope");
    private static String ADD_MAX_UPSLOPE = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.Add3DGeometryAttributesPlugIn.add-max-upslope");
    private static String MAX_SLOPE = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.Add3DGeometryAttributesPlugIn.max-slope");
    private static String ADD_MAX_SLOPE = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.Add3DGeometryAttributesPlugIn.add-max-slope");
    private static String NB_NAN_Z = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.Add3DGeometryAttributesPlugIn.nb-nan-z");
    private static String ADD_NB_NAN_Z = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.Add3DGeometryAttributesPlugIn.add-nb-nan-z");
    private static String NB_NEGATIVE_Z = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.Add3DGeometryAttributesPlugIn.nb-negative-z");
    private static String ADD_NB_NEGATIVE_Z = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.Add3DGeometryAttributesPlugIn.add-nb-negative-z");
    private static String NB_0_Z = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.Add3DGeometryAttributesPlugIn.nb-0-z");
    private static String ADD_NB_0_Z = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.Add3DGeometryAttributesPlugIn.add-nb-0-z");
    private static String NB_POSITIVE_Z = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.Add3DGeometryAttributesPlugIn.nb-positive-z");
    private static String ADD_NB_POSITIVE_Z = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.Add3DGeometryAttributesPlugIn.add-nb-positive-z");
    String layer;
    private boolean addStartZ = false;
    private boolean addEndZ = false;
    private boolean addMinZ = true;
    private boolean addMaxZ = true;
    private boolean addWeightedMeanZ = false;
    private boolean addLength3d = true;
    private boolean addMaxDownslope = false;
    private boolean addMaxUpslope = false;
    private boolean addMaxSlope = false;
    private boolean addNbNaNZ = true;
    private boolean addNbNegativeZ = false;
    private boolean addNb0Z = false;
    private boolean addNbPositiveZ = false;

    @Override
    public void initialize(PlugInContext context) throws Exception {
        FeatureInstaller featureInstaller = context.getFeatureInstaller();
        featureInstaller.addMainMenuPlugin(this, new String[]{MenuNames.TOOLS, MenuNames.TOOLS_EDIT_ATTRIBUTES}, this.getName() + "...", false, null, Add3DGeometryAttributesPlugIn.createEnableCheck(context.getWorkbenchContext()));
    }

    public static MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createAtLeastNLayersMustExistCheck(1));
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        this.reportNothingToUndoYet(context);
        MultiInputDialog dialog = new MultiInputDialog(context.getWorkbenchFrame(), this.getName(), true);
        this.setDialogValues(dialog, context);
        GUIUtil.centreOnWindow(dialog);
        dialog.setVisible(true);
        if (!dialog.wasOKPressed()) {
            return false;
        }
        this.getDialogValues(dialog);
        return true;
    }

    public void setLayer(String sitesLayer) {
        this.layer = sitesLayer;
    }

    public void setAddStartZ(boolean addStartZ) {
        this.addStartZ = addStartZ;
    }

    public void setAddEndZ(boolean addEndZ) {
        this.addEndZ = addEndZ;
    }

    public void setAddMinZ(boolean addMinZ) {
        this.addMinZ = addMinZ;
    }

    public void setAddMaxZ(boolean addMaxZ) {
        this.addMaxZ = addMaxZ;
    }

    public void setAddWeightedMeanZ(boolean addWeightedMeanZ) {
        this.addWeightedMeanZ = addWeightedMeanZ;
    }

    public void setAddLength3d(boolean addLength3d) {
        this.addLength3d = addLength3d;
    }

    public void setAddMaxDownSlope(boolean addMaxDownslope) {
        this.addMaxDownslope = addMaxDownslope;
    }

    public void setAddMaxUpslope(boolean addMaxUpslope) {
        this.addMaxUpslope = addMaxUpslope;
    }

    public void setAddMaxSlope(boolean addMaxSlope) {
        this.addMaxSlope = addMaxSlope;
    }

    public void setAddNbNaNZ(boolean addNbNaNZ) {
        this.addNbNaNZ = addNbNaNZ;
    }

    public void setAddNbNegativeZ(boolean addNbNegativeZ) {
        this.addNbNegativeZ = addNbNegativeZ;
    }

    public void setAddNb0Z(boolean addNb0Z) {
        this.addNb0Z = addNb0Z;
    }

    public void setAddNbPositiveZ(boolean addNbPositiveZ) {
        this.addNbPositiveZ = addNbPositiveZ;
    }

    private void setDialogValues(MultiInputDialog dialog, PlugInContext context) {
        this.layer = context.getCandidateLayer(0).getName();
        dialog.addLayerComboBox(LAYER, context.getLayerManager().getLayer(this.layer), null, context.getLayerManager());
        dialog.addSeparator();
        dialog.addCheckBox(ADD_START_Z, this.addStartZ);
        dialog.addCheckBox(ADD_END_Z, this.addEndZ);
        dialog.addCheckBox(ADD_MIN_Z, this.addMinZ);
        dialog.addCheckBox(ADD_MAX_Z, this.addMaxZ);
        dialog.addCheckBox(ADD_WEIGHTED_MEAN_Z, this.addWeightedMeanZ);
        dialog.addSeparator();
        dialog.addCheckBox(ADD_LENGTH_3D, this.addLength3d);
        dialog.addCheckBox(ADD_MAX_DOWNSLOPE, this.addMaxDownslope);
        dialog.addCheckBox(ADD_MAX_UPSLOPE, this.addMaxUpslope);
        dialog.addCheckBox(ADD_MAX_SLOPE, this.addMaxSlope);
        dialog.addSeparator();
        dialog.addCheckBox(ADD_NB_NAN_Z, this.addNbNaNZ);
        dialog.addCheckBox(ADD_NB_NEGATIVE_Z, this.addNbNegativeZ);
        dialog.addCheckBox(ADD_NB_0_Z, this.addNb0Z);
        dialog.addCheckBox(ADD_NB_POSITIVE_Z, this.addNbPositiveZ);
    }

    private void getDialogValues(MultiInputDialog dialog) {
        this.layer = dialog.getLayer(LAYER).getName();
        this.addStartZ = dialog.getBoolean(ADD_START_Z);
        this.addEndZ = dialog.getBoolean(ADD_END_Z);
        this.addMinZ = dialog.getBoolean(ADD_MIN_Z);
        this.addMaxZ = dialog.getBoolean(ADD_MAX_Z);
        this.addWeightedMeanZ = dialog.getBoolean(ADD_WEIGHTED_MEAN_Z);
        this.addLength3d = dialog.getBoolean(ADD_LENGTH_3D);
        this.addMaxDownslope = dialog.getBoolean(ADD_MAX_DOWNSLOPE);
        this.addMaxUpslope = dialog.getBoolean(ADD_MAX_UPSLOPE);
        this.addMaxSlope = dialog.getBoolean(ADD_MAX_SLOPE);
        this.addNbNaNZ = dialog.getBoolean(ADD_NB_NAN_Z);
        this.addNbNegativeZ = dialog.getBoolean(ADD_NB_NEGATIVE_Z);
        this.addNb0Z = dialog.getBoolean(ADD_NB_0_Z);
        this.addNbPositiveZ = dialog.getBoolean(ADD_NB_POSITIVE_Z);
    }

    @Override
    public void run(TaskMonitor monitor, PlugInContext context) throws Exception {
        monitor.report(COMPUTE_ATTRIBUTES + "...");
        LayerManager layerManager = context.getLayerManager();
        FeatureCollectionWrapper inputFC = layerManager.getLayer(this.layer).getFeatureCollectionWrapper();
        FeatureDataset result = new FeatureDataset(this.getNewSchema(layerManager.getLayer(this.layer)));
        Iterator<Feature> iterator = inputFC.getFeatures().iterator();
        while (iterator.hasNext()) {
            Feature o;
            Feature f = o = iterator.next();
            BasicFeature bf = new BasicFeature(result.getFeatureSchema());
            Object[] attributes = new Object[result.getFeatureSchema().getAttributeCount()];
            System.arraycopy(f.getAttributes(), 0, attributes, 0, f.getSchema().getAttributeCount());
            bf.setAttributes(attributes);
            this.setGeometryAttributes(bf);
            result.add(bf);
        }
        context.getLayerManager().addLayer(StandardCategoryNames.RESULT, this.layer + "-" + GEOM_ATTRIBUTES, result);
    }

    private FeatureSchema getNewSchema(Layer layer) {
        FeatureSchema schema = layer.getFeatureCollectionWrapper().getFeatureSchema().clone();
        if (this.addStartZ) {
            schema.addAttribute(START_Z, AttributeType.DOUBLE);
        }
        if (this.addEndZ) {
            schema.addAttribute(END_Z, AttributeType.DOUBLE);
        }
        if (this.addMinZ) {
            schema.addAttribute(MIN_Z, AttributeType.DOUBLE);
        }
        if (this.addMaxZ) {
            schema.addAttribute(MAX_Z, AttributeType.DOUBLE);
        }
        if (this.addWeightedMeanZ) {
            schema.addAttribute(WEIGHTED_MEAN_Z, AttributeType.DOUBLE);
        }
        if (this.addLength3d) {
            schema.addAttribute(LENGTH_3D, AttributeType.DOUBLE);
        }
        if (this.addMaxDownslope) {
            schema.addAttribute(MAX_DOWN_SLOPE, AttributeType.DOUBLE);
        }
        if (this.addMaxUpslope) {
            schema.addAttribute(MAX_UPSLOPE, AttributeType.DOUBLE);
        }
        if (this.addMaxSlope) {
            schema.addAttribute(MAX_SLOPE, AttributeType.DOUBLE);
        }
        if (this.addNbNaNZ) {
            schema.addAttribute(NB_NAN_Z, AttributeType.INTEGER);
        }
        if (this.addNbNegativeZ) {
            schema.addAttribute(NB_NEGATIVE_Z, AttributeType.INTEGER);
        }
        if (this.addNb0Z) {
            schema.addAttribute(NB_0_Z, AttributeType.INTEGER);
        }
        if (this.addNbPositiveZ) {
            schema.addAttribute(NB_POSITIVE_Z, AttributeType.INTEGER);
        }
        return schema;
    }

    private void setGeometryAttributes(Feature f) {
        Geometry g = f.getGeometry();
        Coordinate[] cc = g.getCoordinates();
        if (this.addStartZ) {
            f.setAttribute(START_Z, (Object)cc[0].z);
        }
        if (this.addEndZ) {
            f.setAttribute(END_Z, (Object)cc[cc.length - 1].z);
        }
        double minZ = Double.NaN;
        double maxZ = Double.NaN;
        int nbNaNZ = 0;
        int nbNegativeZ = 0;
        int nb0Z = 0;
        int nbPositiveZ = 0;
        for (Coordinate c : cc) {
            if (Double.isNaN(c.z)) {
                ++nbNaNZ;
                continue;
            }
            if (Double.isNaN(minZ) || c.z < minZ) {
                minZ = c.z;
            }
            if (Double.isNaN(maxZ) || c.z > maxZ) {
                maxZ = c.z;
            }
            if (c.z < 0.0) {
                ++nbNegativeZ;
            }
            if (c.z == 0.0) {
                ++nb0Z;
            }
            if (!(c.z > 0.0)) continue;
            ++nbPositiveZ;
        }
        if (this.addMinZ) {
            f.setAttribute(MIN_Z, (Object)minZ);
        }
        if (this.addMaxZ) {
            f.setAttribute(MAX_Z, (Object)maxZ);
        }
        if (this.addNbNaNZ) {
            f.setAttribute(NB_NAN_Z, (Object)nbNaNZ);
        }
        if (this.addNbNegativeZ) {
            f.setAttribute(NB_NEGATIVE_Z, (Object)nbNegativeZ);
        }
        if (this.addNb0Z) {
            f.setAttribute(NB_0_Z, (Object)nb0Z);
        }
        if (this.addNbPositiveZ) {
            f.setAttribute(NB_POSITIVE_Z, (Object)nbPositiveZ);
        }
        double weightedMeanZ = Double.NaN;
        double length3d = 0.0;
        double maxDownslope = Double.NaN;
        double maxUpslope = Double.NaN;
        double maxSlope = Double.NaN;
        int dim = g.getDimension();
        if (dim == 0) {
            int nbNonNullZ = 0;
            for (int i = 0; i < g.getNumGeometries(); ++i) {
                Geometry component = g.getGeometryN(i);
                Coordinate c = component.getCoordinate();
                if (Double.isNaN(c.z)) continue;
                weightedMeanZ = Double.isNaN(weightedMeanZ) ? c.z : (weightedMeanZ += c.z);
                ++nbNonNullZ;
            }
            weightedMeanZ /= (double)nbNonNullZ;
        } else if (dim > 0) {
            double weightedLength2d = 0.0;
            for (int i = 0; i < g.getNumGeometries(); ++i) {
                Geometry component = g.getGeometryN(i);
                if (component.getDimension() == 0) continue;
                ArrayList<ZBoundedSubLineString> list = new ArrayList<ZBoundedSubLineString>();
                if (component instanceof LineString) {
                    this.getZBoundedSubLineStrings((LineString)component, list);
                } else if (component instanceof Polygon) {
                    Polygon polygon = (Polygon)component;
                    this.getZBoundedSubLineStrings((LineString)polygon.getExteriorRing(), list);
                    for (int j = 0; j < polygon.getNumInteriorRing(); ++j) {
                        this.getZBoundedSubLineStrings((LineString)polygon.getInteriorRingN(j), list);
                    }
                }
                for (ZBoundedSubLineString line : list) {
                    length3d += line.getLength3d();
                    double wZ = line.getWeightedZ();
                    double slope = line.getSlope();
                    if (!Double.isNaN(wZ)) {
                        weightedMeanZ = Double.isNaN(weightedMeanZ) ? wZ : (weightedMeanZ += wZ);
                        weightedLength2d += line.getLength2d();
                    }
                    if (Double.isNaN(maxDownslope)) {
                        maxDownslope = slope;
                    } else if (!Double.isNaN(slope) && slope < maxDownslope) {
                        maxDownslope = slope;
                    }
                    if (Double.isNaN(maxUpslope)) {
                        maxUpslope = slope;
                    } else if (!Double.isNaN(slope) && slope > maxUpslope) {
                        maxUpslope = slope;
                    }
                    if (Double.isNaN(maxSlope)) {
                        maxSlope = Math.abs(slope);
                        continue;
                    }
                    if (Double.isNaN(slope) || !(Math.abs(slope) > maxSlope)) continue;
                    maxSlope = Math.abs(slope);
                }
            }
            weightedMeanZ /= weightedLength2d;
        }
        if (maxDownslope > 0.0) {
            maxDownslope = Double.NaN;
        }
        if (maxUpslope < 0.0) {
            maxUpslope = Double.NaN;
        }
        if (this.addLength3d) {
            f.setAttribute(LENGTH_3D, (Object)length3d);
        }
        if (this.addWeightedMeanZ) {
            f.setAttribute(WEIGHTED_MEAN_Z, (Object)weightedMeanZ);
        }
        if (this.addMaxDownslope) {
            f.setAttribute(MAX_DOWN_SLOPE, (Object)(100.0 * maxDownslope));
        }
        if (this.addMaxUpslope) {
            f.setAttribute(MAX_UPSLOPE, (Object)(100.0 * maxUpslope));
        }
        if (this.addMaxSlope) {
            f.setAttribute(MAX_SLOPE, (Object)(100.0 * maxSlope));
        }
    }

    private void getZBoundedSubLineStrings(LineString line, List<ZBoundedSubLineString> list) {
        Coordinate[] cc = line.getCoordinates();
        double subLineLength = 0.0;
        double prevZ = cc[0].z;
        for (int i = 1; i < cc.length; ++i) {
            subLineLength += cc[i - 1].distance(cc[i]);
            Coordinate c = cc[i];
            if (Double.isNaN(c.z) && i != cc.length - 1) continue;
            list.add(new ZBoundedSubLineString(prevZ, c.z, subLineLength));
            subLineLength = 0.0;
            prevZ = c.z;
        }
    }

    private static class ZBoundedSubLineString {
        double startZ;
        double endZ;
        double length2d;
        double dz = Double.NaN;

        private ZBoundedSubLineString(double startZ, double endZ, double length2d) {
            this.startZ = startZ;
            this.endZ = endZ;
            this.length2d = length2d;
            if (!Double.isNaN(startZ) && !Double.isNaN(endZ)) {
                this.dz = endZ - startZ;
            }
        }

        private double getLength2d() {
            return this.length2d;
        }

        private double getLength3d() {
            return Double.isNaN(this.dz) ? this.length2d : Math.sqrt(this.length2d * this.length2d + this.dz * this.dz);
        }

        private double getWeightedZ() {
            if (Double.isNaN(this.dz)) {
                if (!Double.isNaN(this.startZ)) {
                    return this.startZ * this.length2d;
                }
                if (!Double.isNaN(this.endZ)) {
                    return this.endZ * this.length2d;
                }
                return Double.NaN;
            }
            return (this.startZ + this.dz / 2.0) * this.length2d;
        }

        private double getSlope() {
            if (!Double.isNaN(this.dz)) {
                if (this.length2d > 0.0) {
                    return this.dz / this.length2d;
                }
                if (this.dz > 0.0) {
                    return Double.POSITIVE_INFINITY;
                }
                if (this.dz < 0.0) {
                    return Double.NEGATIVE_INFINITY;
                }
                return 0.0;
            }
            return Double.NaN;
        }
    }
}

