/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.style;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.datasource.SaveFileDataSourceQueryChooser;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.plugin.ThreadedBasePlugIn;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import org.openjump.core.apitools.IOTools;
import org.openjump.core.ui.io.file.FileNameExtensionFilter;
import org.openjump.core.ui.plugin.file.open.JFCWithEnterAction;

public class LoadStylePlugIn
extends ThreadedBasePlugIn {
    public static final ImageIcon ICON = IconLoader.icon("style_in.png");
    private final String name = I18N.getInstance().get("org.openjump.core.ui.plugin.style.StylePlugIns.import-style");
    File file;
    Layer layer;
    private JFileChooser fc;
    private final FileNameExtensionFilter filter = new FileNameExtensionFilter("JUMP layer symbology", "style.xml");
    private final FileNameExtensionFilter filter2 = new FileNameExtensionFilter("Spatial layer descriptor", "sld");
    private static final String FILE_CHOOSER_DIRECTORY_KEY = SaveFileDataSourceQueryChooser.class.getName() + " - FILE CHOOSER DIRECTORY";

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void initialize(PlugInContext context) throws Exception {
        super.initialize(context);
    }

    public EnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory ecf = EnableCheckFactory.getInstance(workbenchContext);
        MultiEnableCheck mec = new MultiEnableCheck().add(ecf.createWindowWithLayerNamePanelMustBeActiveCheck()).add(ecf.createExactlyNLayerablesMustBeSelectedCheck(1, Layer.class));
        return mec;
    }

    @Override
    public ImageIcon getIcon() {
        return ICON;
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        this.layer = context.getSelectedLayer(0);
        this.fc = new JFCWithEnterAction();
        if (PersistentBlackboardPlugIn.get(context.getWorkbenchContext()).get(FILE_CHOOSER_DIRECTORY_KEY) != null) {
            this.fc.setCurrentDirectory(new File((String)PersistentBlackboardPlugIn.get(context.getWorkbenchContext()).get(FILE_CHOOSER_DIRECTORY_KEY)));
        }
        this.fc.setDialogTitle(this.name);
        this.fc.setDialogType(0);
        this.fc.setFileSelectionMode(0);
        this.fc.setMultiSelectionEnabled(false);
        this.fc.setFileFilter(this.filter2);
        this.fc.setFileFilter(this.filter);
        this.fc.addChoosableFileFilter(this.filter);
        return true;
    }

    private void monitor(TaskMonitor monitor, File file) {
        monitor.allowCancellationRequests();
        monitor.report(I18N.getInstance().get("com.vividsolutions.jump.workbench.plugin.PlugInManager.loading") + ": " + file.getAbsolutePath());
    }

    @Override
    public void run(TaskMonitor monitor, PlugInContext context) throws Exception {
        if (0 != this.fc.showOpenDialog(context.getWorkbenchFrame())) {
            return;
        }
        if (this.fc.getFileFilter().equals(this.filter)) {
            this.file = this.fc.getSelectedFile();
            this.monitor(monitor, this.file);
            IOTools.loadSimbology_Jump(this.file, this.layer);
        } else if (this.fc.getFileFilter().equals(this.filter2)) {
            this.file = this.fc.getSelectedFile();
            this.monitor(monitor, this.file);
            IOTools.loadSimbology_SLD(this.file, context);
        }
    }
}

