/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.raster;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.StandardCategoryNames;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.plugin.ThreadedBasePlugIn;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import org.openjump.core.apitools.LayerTools;
import org.openjump.core.rasterimage.RasterImageLayer;
import org.openjump.core.rasterimage.algorithms.VectorizeAlgorithm;
import org.openjump.core.rasterimage.sextante.OpenJUMPSextanteRasterLayer;
import org.openjump.core.rasterimage.sextante.rasterWrappers.GridWrapperNotInterpolated;
import org.openjump.core.ui.plugin.raster.Utils;
import org.openjump.core.ui.util.LayerableUtil;

public class VectorizeToPolygonsPlugIn
extends ThreadedBasePlugIn {
    private final String PROCESSING = I18N.getInstance().get("jump.plugin.edit.NoderPlugIn.processing");
    private final String sLayer = I18N.getInstance().get("ui.GenericNames.Source-Layer");
    private final String sExplode = I18N.getInstance().get("ui.plugin.raster.VectorizeToPolygonsPlugIn.explode-multipolygons");
    private final String NAME = I18N.getInstance().get("ui.plugin.raster.VectorizeToPolygonsPlugIn.Name");
    private final String sStyle = I18N.getInstance().get("ui.plugin.raster.VectorizeToContoursPlugIn.apply-random-style");
    private final String sValue = I18N.getInstance().get("org.openjump.core.ui.plugin.raster.RasterQueryPlugIn.value");
    private final String algorithms = I18N.getInstance().get("ui.plugin.raster.VectorizeToPolygonsPlugIn.algorithms");
    private final String sSimplify = I18N.getInstance().get("org.openjump.core.ui.plugin.raster.RasterQueryPlugIn.simplify");
    String alg1 = "AdbToolbox";
    String alg2 = "Sextante";
    String alg3 = "Mike";
    String choose;
    boolean explodeb = true;
    boolean applystyleb = false;
    boolean simplifyb = false;
    private JCheckBox explode = new JCheckBox();
    private JCheckBox simplify = new JCheckBox();
    private JComboBox<String> comboBox = new JComboBox();
    private List<RasterImageLayer> fLayers = new ArrayList<RasterImageLayer>();
    private JComboBox<RasterImageLayer> layerableComboBox = new JComboBox();
    RasterImageLayer layer;

    @Override
    public String getName() {
        return this.NAME;
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        this.reportNothingToUndoYet(context);
        MultiInputDialog dialog = new MultiInputDialog(context.getWorkbenchFrame(), this.NAME, true);
        this.setDialogValues(dialog, context);
        if (this.fLayers.isEmpty()) {
            return false;
        }
        GUIUtil.centreOnWindow(dialog);
        dialog.setVisible(true);
        if (!dialog.wasOKPressed()) {
            return false;
        }
        if (dialog.wasOKPressed()) {
            this.getDialogValues(dialog);
            return true;
        }
        return false;
    }

    private void setDialogValues(MultiInputDialog dialog, PlugInContext context) {
        dialog.setSideBarDescription(this.NAME);
        this.layer = !context.getLayerNamePanel().selectedNodes(RasterImageLayer.class).isEmpty() ? (RasterImageLayer)LayerTools.getSelectedLayerable(context, RasterImageLayer.class) : context.getTask().getLayerManager().getLayerables(RasterImageLayer.class).get(0);
        this.fLayers = context.getTask().getLayerManager().getLayerables(RasterImageLayer.class);
        this.layerableComboBox = dialog.addLayerableComboBox(this.sLayer, this.layer, "", this.fLayers);
        this.layerableComboBox.setSize(200, this.layerableComboBox.getPreferredSize().height);
        ArrayList<String> srsArray = new ArrayList<String>();
        srsArray.add(this.alg1);
        srsArray.add(this.alg2);
        srsArray.add(this.alg3);
        this.comboBox = dialog.addComboBox(this.algorithms, "", srsArray, null);
        this.comboBox.setSize(200, this.comboBox.getPreferredSize().height);
        this.comboBox.addActionListener(e -> {
            dialog.pack();
            dialog.repaint();
            this.explode.setEnabled(this.comboBox.getSelectedIndex() == 0);
            this.simplify.setEnabled(this.comboBox.getSelectedIndex() == 2);
        });
        this.explode = dialog.addCheckBox(this.sExplode, true);
        dialog.addCheckBox(this.sStyle, true);
        this.simplify = dialog.addCheckBox(this.sSimplify, this.simplifyb);
        this.simplify.setEnabled(this.comboBox.getSelectedIndex() == 2);
    }

    private void getDialogValues(MultiInputDialog dialog) {
        this.layer = (RasterImageLayer)dialog.getLayerable(this.sLayer);
        this.explodeb = dialog.getBoolean(this.sExplode);
        this.applystyleb = dialog.getBoolean(this.sStyle);
        this.choose = dialog.getText(this.algorithms);
        this.simplifyb = dialog.getBoolean(this.sSimplify);
    }

    @Override
    public void run(TaskMonitor monitor, PlugInContext context) throws Exception {
        monitor.report(this.PROCESSING);
        this.reportNothingToUndoYet(context);
        Utils.zoom(this.layer);
        OpenJUMPSextanteRasterLayer rstLayer = new OpenJUMPSextanteRasterLayer();
        rstLayer.create(this.layer, true);
        GridWrapperNotInterpolated gwrapper = new GridWrapperNotInterpolated(rstLayer, rstLayer.getLayerGridExtent());
        FeatureSchema fs = new FeatureSchema();
        fs.addAttribute("geometry", AttributeType.GEOMETRY);
        fs.addAttribute(this.sValue, AttributeType.INTEGER);
        FeatureCollection featDataset = new FeatureDataset(fs);
        switch (this.comboBox.getSelectedIndex()) {
            case 0: {
                if (this.explodeb) {
                    featDataset = VectorizeAlgorithm.toPolygonsAdbToolBox(gwrapper, true, this.sValue, 0);
                    break;
                }
                featDataset = VectorizeAlgorithm.toPolygonsAdbToolBox(gwrapper, false, this.sValue, 0);
                break;
            }
            case 1: {
                featDataset = VectorizeAlgorithm.toPolygonsSextante(gwrapper, this.sValue, 0);
                break;
            }
            case 2: {
                featDataset = this.simplifyb ? VectorizeAlgorithm.toPolygonsMikeToolBox(gwrapper, true, this.sValue, 0) : VectorizeAlgorithm.toPolygonsMikeToolBox(gwrapper, false, this.sValue, 0);
            }
        }
        Layer vlayer = context.addLayer(StandardCategoryNames.WORKING, rstLayer.getName() + "_vectorized", featDataset);
        if (this.applystyleb) {
            Utils.applyRandomGradualStyle(vlayer, this.sValue);
        }
    }

    public static MultiEnableCheck createEnableCheck(final WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithAssociatedTaskFrameMustBeActiveCheck()).add(checkFactory.createAtLeastNLayerablesOfTypeMustExistCheck(1, RasterImageLayer.class)).add(new EnableCheck(){

            @Override
            public String check(JComponent component) {
                ArrayList<RasterImageLayer> mLayer = new ArrayList<RasterImageLayer>();
                List<RasterImageLayer> rlayers = workbenchContext.getLayerManager().getLayerables(RasterImageLayer.class);
                for (RasterImageLayer currentLayer : rlayers) {
                    if (!LayerableUtil.isMonoband(currentLayer)) continue;
                    mLayer.add(currentLayer);
                }
                if (!mLayer.isEmpty()) {
                    return null;
                }
                return I18N.getInstance().get("plugin.EnableCheckFactory.at-least-one-single-banded-layer-should-exist");
            }
        });
    }
}

