/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.raster;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.BasicFeature;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.workbench.Logger;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.model.StandardCategoryNames;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.LayerNamePanel;
import com.vividsolutions.jump.workbench.ui.cursortool.NClickTool;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import com.vividsolutions.jump.workbench.ui.renderer.style.LabelStyle;
import de.latlon.deejump.plugin.style.CrossVertexStyle;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.swing.Icon;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.openjump.core.CheckOS;
import org.openjump.core.rasterimage.RasterImageLayer;

public class RasterQueryCursorTool
extends NClickTool {
    protected Coordinate tentativeCoordinate;
    public static final String LAYER_NAME = I18N.getInstance().get("org.openjump.core.ui.plugin.raster.RasterImageLayerPropertiesPlugIn.cell.values");
    public static final String LAYER = I18N.getInstance().get("org.openjump.core.ui.plugin.raster.RasterImageLayerPropertiesPlugIn.layer");
    private static final String RASTER_NODATA = I18N.getInstance().get("org.openjump.core.ui.plugin.raster.RasterImageLayerPropertiesPlugIn.cell.nodata");
    private String lastClick = "-";
    private String VALUE = I18N.getInstance().get("org.openjump.core.ui.plugin.raster.RasterQueryPlugIn.value");
    private String name;
    PlugInContext context;
    LayerNamePanel namePanel;
    PlugInContext gContext;

    public RasterQueryCursorTool(WorkbenchContext context) {
        super(context, 1);
    }

    @Override
    public Icon getIcon() {
        return IconLoader.icon("information_16x16.png");
    }

    @Override
    public Cursor getCursor() {
        BufferedImage i = !CheckOS.isLinux() ? IconLoader.image("information_cursor.png") : IconLoader.image("information_cursor_2color.gif");
        return RasterQueryCursorTool.createCursor(i);
    }

    @Override
    protected void gestureFinished() throws NoninvertibleTransformException, IOException, RasterImageLayer.RasterDataNotFoundException {
        this.reportNothingToUndoYet();
        RasterImageLayer rLayer = null;
        WorkbenchContext wbcontext = this.getWorkbench().getContext();
        RasterImageLayer[] ls = wbcontext.getLayerableNamePanel().selectedNodes(RasterImageLayer.class).toArray(new RasterImageLayer[0]);
        if (ls != null && ls.length > 0) {
            rLayer = ls[0];
            this.name = rLayer.getName();
            Coordinate coord = this.getCoordinates().get(0);
            if (this.getPoint().within(rLayer.getWholeImageEnvelopeAsGeometry())) {
                try {
                    String cellValues = "";
                    for (int b = 0; b < rLayer.getNumBands(); ++b) {
                        Double cellValue = rLayer.getCellValue(coord.x, coord.y, b);
                        cellValues = cellValue != null ? (rLayer.isNoData(cellValue) ? cellValues.concat(Double.toString(cellValue)) : cellValues.concat(Double.toString(cellValue))) : cellValues.concat("???");
                        cellValues = cellValues.concat("  ");
                        this.lastClick = Double.isNaN(cellValue) ? "    " : cellValues;
                    }
                }
                catch (IOException ex) {
                    String cellValues = " - ";
                    Logger.error(ex);
                }
                Geometry measureGeometry = null;
                if (this.wasShiftPressed()) {
                    this.pixelLayer().getFeatureCollectionWrapper().clear();
                    this.pixelLayer().getFeatureCollectionWrapper().add(this.toFeature(measureGeometry, this.pixelLayer().getFeatureCollectionWrapper().getFeatureSchema()));
                } else {
                    this.pixelLayer().getFeatureCollectionWrapper().add(this.toFeature(measureGeometry, this.pixelLayer().getFeatureCollectionWrapper().getFeatureSchema()));
                }
                this.getPanel().getContext().setStatusMessage("[" + LAYER + ": " + this.name + "] " + this.VALUE + ": " + this.lastClick);
                this.getPanel().setViewportInitialized(true);
            } else {
                this.getPanel().getContext().warnUser(I18N.getInstance().get("org.openjump.core.ui.plugin.raster.RasterQueryPlugIn.message"));
            }
        } else {
            this.getPanel().getContext().warnUser(I18N.getInstance().get("org.openjump.core.rasterimage.SelectRasterImageFilesPanel.Select-Raster-Image"));
        }
    }

    private Feature toFeature(Geometry measureGeometry, FeatureSchema schema) throws NoninvertibleTransformException {
        BasicFeature feature = new BasicFeature(this.pixelLayer().getFeatureCollectionWrapper().getFeatureSchema());
        feature.setGeometry(measureGeometry);
        feature.setAttribute("Pixel", (Object)this.lastClick);
        feature.setAttribute(LAYER, (Object)this.name);
        feature.setAttribute("X", (Object)new Double(this.getPoint().getCoordinate().x));
        feature.setAttribute("Y", (Object)new Double(this.getPoint().getCoordinate().y));
        feature.setAttribute("GEOM", (Object)this.getPoint());
        return feature;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Layer pixelLayer() {
        Layer layer;
        Layer pixelLayer = this.getPanel().getLayerManager().getLayer(LAYER_NAME);
        if (pixelLayer != null) {
            return pixelLayer;
        }
        FeatureSchema schema = new FeatureSchema();
        schema.addAttribute("Pixel", AttributeType.STRING);
        schema.addAttribute("X", AttributeType.DOUBLE);
        schema.addAttribute("Y", AttributeType.DOUBLE);
        schema.addAttribute(LAYER, AttributeType.STRING);
        schema.addAttribute("GEOM", AttributeType.GEOMETRY);
        new FeatureSchema();
        new FeatureDataset(schema);
        FeatureDataset featureCollection = new FeatureDataset(schema);
        boolean firingEvents = this.getPanel().getLayerManager().isFiringEvents();
        this.getPanel().getLayerManager().setFiringEvents(false);
        try {
            layer = new Layer(LAYER_NAME, Color.red, featureCollection, this.getPanel().getLayerManager());
            layer.removeStyle(layer.getVertexStyle());
            layer.addStyle(new CrossVertexStyle());
            layer.getBasicStyle().setLineColor(Color.black);
            layer.getBasicStyle().setFillColor(Color.black);
            layer.getBasicStyle().setLineWidth(1);
            layer.getBasicStyle().setAlpha(255);
            layer.getBasicStyle().setRenderingLine(true);
            layer.getBasicStyle().setRenderingFill(false);
            layer.getVertexStyle().setEnabled(false);
            layer.getVertexStyle().setSize(1);
            layer.setDrawingLast(true);
            LabelStyle labelStyle = layer.getLabelStyle();
            labelStyle.setAttribute("Pixel");
            labelStyle.setVerticalAlignment("ABOVE_LINE");
            labelStyle.setHorizontalPosition("RIGHT_SIDE");
            labelStyle.setHorizontalAlignment(2);
            labelStyle.setEnabled(true);
            labelStyle.setColor(Color.black);
            labelStyle.setHeight(14.0);
            labelStyle.setOutlineShowing(true);
            labelStyle.setOutlineColor(Color.white);
            labelStyle.setHidingOverlappingLabels(false);
            labelStyle.setFont(layer.getLabelStyle().getFont().deriveFont(1, 16.0f));
            layer.setDrawingLast(true);
        }
        finally {
            this.getPanel().getLayerManager().setFiringEvents(firingEvents);
        }
        this.getPanel().getLayerManager().addLayer(StandardCategoryNames.SYSTEM, layer);
        return layer;
    }

    protected Point getPoint() throws NoninvertibleTransformException {
        return new GeometryFactory().createPoint(this.getCoordinates().get(0));
    }

    public MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerNamePanelMustBeActiveCheck()).add(checkFactory.createWindowWithLayerViewPanelMustBeActiveCheck()).add(checkFactory.createExactlyNLayerablesMustBeSelectedCheck(1, RasterImageLayer.class));
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent me) {
        WorkbenchContext wbcontext = this.getWorkbench().getContext();
        for (Layerable layerable : wbcontext.getLayerableNamePanel().selectedNodes(Layerable.class)) {
            String cellValues;
            Layerable layer = layerable;
            if (!(layer instanceof RasterImageLayer)) continue;
            try {
                cellValues = "";
                Coordinate tentativeCoordinate = this.getPanel().getViewport().toModelCoordinate(me.getPoint());
                for (int b = 0; b < ((RasterImageLayer)layer).getNumBands(); ++b) {
                    Double cellValue = ((RasterImageLayer)layer).getCellValue(tentativeCoordinate.x, tentativeCoordinate.y, b);
                    cellValues = cellValue != null ? (((RasterImageLayer)layer).isNoData(cellValue) ? cellValues.concat(Double.toString(cellValue)) + "(" + RASTER_NODATA + ") " : cellValues.concat(Double.toString(cellValue))) : cellValues.concat("???");
                    cellValues = cellValues.concat("  ");
                }
            }
            catch (IOException e) {
                cellValues = " - ";
                Logger.error(e);
            }
            catch (NoninvertibleTransformException e) {
                cellValues = " - ";
            }
            this.name = ((RasterImageLayer)layer).getName();
            this.getPanel().getContext().setStatusMessage("[" + LAYER + ": " + this.name + "] " + this.VALUE + ": " + cellValues.toString());
        }
    }

    @Override
    public String getName() {
        return I18N.getInstance().get("org.openjump.core.ui.plugin.raster.RasterQueryPlugIn");
    }
}

