/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.layer;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.model.WMSLayer;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import de.latlon.deejump.plugin.style.DeeChangeStylesPlugIn;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import org.openjump.core.apitools.LayerTools;
import org.openjump.core.rasterimage.RasterImageLayer;
import org.openjump.core.ui.plugin.layer.pirolraster.ChangeRasterImagePropertiesPlugIn;
import org.openjump.core.ui.plugin.wms.WMSStylePlugIn;

public class LayerableStylePlugIn
extends AbstractPlugIn {
    @Override
    public void initialize(PlugInContext context) throws Exception {
        super.initialize(context);
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        Layerable layer = LayerTools.getSelectedLayerable(context, Layerable.class);
        if (layer instanceof Layer) {
            DeeChangeStylesPlugIn vectorLayerChangeStylePlugIn = new DeeChangeStylesPlugIn();
            vectorLayerChangeStylePlugIn.execute(context);
        } else if (layer instanceof RasterImageLayer) {
            ChangeRasterImagePropertiesPlugIn rasterLayerChangeStylePlugIn = new ChangeRasterImagePropertiesPlugIn();
            rasterLayerChangeStylePlugIn.execute(context);
        } else if (layer instanceof WMSLayer) {
            WMSStylePlugIn wmsLayerChangeStylePlugIn = new WMSStylePlugIn();
            wmsLayerChangeStylePlugIn.execute(context);
        } else {
            JOptionPane.showMessageDialog(null, "Styling not supported for this type of datasource", this.getName(), -1);
        }
        return false;
    }

    @Override
    public ImageIcon getIcon() {
        return IconLoader.icon("Palette.png");
    }

    @Override
    public String getName() {
        return I18N.getInstance().get("ui.style.ChangeStylesPlugIn.change-styles");
    }

    public MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerNamePanelMustBeActiveCheck()).add(checkFactory.createExactlyNLayerablesMustBeSelectedCheck(1, Layerable.class));
    }
}

