/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.layer;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureCollectionWrapper;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.AttributeTypeFilter;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.ImageIcon;
import javax.swing.JComponent;

public class ExtractLayersByAttribute
extends AbstractPlugIn {
    private static final String EXTRACT_LAYERS_BY_ATTRIBUTE = I18N.getInstance().get("org.openjump.core.ui.plugin.layer.ExtractLayersByAttribute.Extract-Layer-by-Attribute");
    private static final String LAYER_ATTRIBUTE = I18N.getInstance().get("org.openjump.core.ui.plugin.layer.ExtractLayersByAttribute.Attribute");
    private static final String DIALOGMSG = I18N.getInstance().get("org.openjump.core.ui.plugin.layer.ExtractLayersByAttribute.Extracts-layers-using-a-common-attribute");
    private static final String LAYER = I18N.getInstance().get("org.openjump.core.ui.plugin.layer.ExtractLayersByAttribute.LAYER");
    private static final String EXTRACT = I18N.getInstance().get("org.openjump.core.ui.plugin.layer.ExtractLayersByAttribute.Extract");
    private static final String NULL = I18N.getInstance().get("org.openjump.core.ui.plugin.layer.ExtractLayersByAttribute._NULL_");
    private static final String EMPTY = I18N.getInstance().get("org.openjump.core.ui.plugin.layer.ExtractLayersByAttribute._EMPTY_");
    private Layer sourceLayer = null;
    public static final ImageIcon ICON = IconLoader.icon("extract.gif");

    @Override
    public void initialize(PlugInContext context) throws Exception {
        super.initialize(context);
        context.getFeatureInstaller().addMainMenuPlugin(this, new String[]{MenuNames.EDIT, MenuNames.EXTRACT}, this.getName(), false, ICON, ExtractLayersByAttribute.createEnableCheck(context.getWorkbenchContext()));
    }

    public static MultiEnableCheck createEnableCheck(final WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithSelectionManagerMustBeActiveCheck()).add(checkFactory.createExactlyNLayersMustBeSelectedCheck(1)).add(new EnableCheck(){

            @Override
            public String check(JComponent component) {
                Layer[] lyrs = workbenchContext.getLayerableNamePanel().getSelectedLayers();
                if (lyrs.length == 0) {
                    return I18N.getInstance().get("com.vividsolutions.jump.workbench.plugin.Exactly-one-layer-must-be-selected");
                }
                if (lyrs[0].getFeatureCollectionWrapper().getFeatureSchema().getAttributeCount() < 2) {
                    return I18N.getInstance().get("ui.renderer.style.ColorThemingPanel.layer-must-have-at-least-1-attribute");
                }
                return null;
            }
        });
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        this.sourceLayer = context.getSelectedLayer(0);
        MultiInputDialog dialog = new MultiInputDialog(context.getWorkbenchFrame(), this.getName(), true);
        this.setDialogFields(dialog);
        GUIUtil.centreOnWindow(dialog);
        dialog.setVisible(true);
        if (dialog.wasOKPressed()) {
            String attrName = dialog.getText(LAYER_ATTRIBUTE);
            this.extractLayers(context, this.sourceLayer, attrName);
            return true;
        }
        return false;
    }

    private void setDialogFields(MultiInputDialog dialog) {
        dialog.setSideBarDescription(DIALOGMSG);
        List<String> attributes = AttributeTypeFilter.NO_GEOMETRY_FILTER.filter(this.sourceLayer);
        String layerName = attributes.get(0);
        for (String attribute : attributes) {
            if (!attribute.equalsIgnoreCase(LAYER)) continue;
            layerName = attribute;
            break;
        }
        dialog.addComboBox(LAYER_ATTRIBUTE, layerName, attributes, null);
    }

    @Override
    public String getName() {
        return EXTRACT_LAYERS_BY_ATTRIBUTE;
    }

    private void extractLayers(PlugInContext context, Layer layer, String attributeName) {
        FeatureCollectionWrapper featureCollection = layer.getFeatureCollectionWrapper();
        List<Feature> featureList = featureCollection.getFeatures();
        FeatureSchema featureSchema = layer.getFeatureCollectionWrapper().getFeatureSchema();
        int attributeIndex = featureSchema.getAttributeIndex(attributeName);
        HashMap<String, FeatureCollection> newLayersMap = new HashMap<String, FeatureCollection>();
        for (Feature feature : featureList) {
            FeatureCollection fc;
            String attributeString;
            Object attribute = feature.getAttribute(attributeIndex);
            String string = attributeString = attribute == null ? NULL : attribute.toString().trim();
            if (attributeString.length() == 0) {
                attributeString = EMPTY;
            }
            if ((fc = (FeatureCollection)newLayersMap.get(attributeString)) == null) {
                fc = new FeatureDataset(featureSchema);
                newLayersMap.put(attributeString, fc);
            }
            fc.add(feature);
        }
        for (Map.Entry entry : new TreeMap(newLayersMap).entrySet()) {
            context.addLayer(EXTRACT, (String)entry.getKey(), (FeatureCollection)entry.getValue());
        }
        context.getLayerViewPanel().repaint();
    }
}

