/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.layer;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.BasicFeature;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureCollectionWrapper;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.io.datasource.DataSourceQuery;
import com.vividsolutions.jump.util.FileUtil;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.datastore.ConnectionDescriptor;
import com.vividsolutions.jump.workbench.imagery.ReferencedImageStyle;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.model.WMSLayer;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import java.awt.Color;
import java.io.File;
import java.math.BigDecimal;
import javax.swing.Icon;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Polygon;
import org.openjump.core.apitools.LayerTools;
import org.openjump.core.apitools.objecttyperoles.FeatureCollectionRole;
import org.openjump.core.apitools.objecttyperoles.RoleOutline;
import org.openjump.core.ccordsys.utils.ProjUtils;
import org.openjump.core.ccordsys.utils.SRSInfo;
import org.openjump.core.rasterimage.RasterImageLayer;
import org.openjump.core.rasterimage.TiffTags;

public class ExportLayerableEnvelopeAsGeometryPlugIn
extends AbstractPlugIn {
    private static final String SOURCE_PATH = I18N.getInstance().get("org.openjump.core.ui.plugin.layer.LayerPropertiesPlugIn.Source-Path");
    private static final String NOTSAVED = I18N.getInstance().get("org.openjump.core.ui.plugin.layer.LayerPropertiesPlugIn.Not-Saved");
    private static final String MULTIPLESOURCE = I18N.getInstance().get("org.openjump.core.ui.plugin.layer.LayerPropertiesPlugIn.Multiple-Sources");
    private static final String SRID = "SRID";
    private static final String minX = "minX";
    private static final String maxX = "maxX";
    private static final String minY = "minY";
    private static final String maxY = "maxY";
    private static final String LAYER = I18N.getInstance().get("ui.GenericNames.LAYER");
    String ENVELOPE = I18N.getInstance().get("ui.plugin.LayerStatisticsPlugIn.envelope") + "_";

    @Override
    public Icon getIcon() {
        return IconLoader.icon("envelope.png");
    }

    public MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerNamePanelMustBeActiveCheck()).add(checkFactory.createAtLeastNLayerablesMustBeSelectedCheck(1, Layerable.class));
    }

    public String getIconString() {
        return null;
    }

    @Override
    public String getName() {
        return I18N.getInstance().get("org.openjump.core.ui.plugin.layer.pirolraster.ExportEnvelopeAsGeometryPlugIn.Export-Envelope-As-Geometry");
    }

    @Override
    public void initialize(PlugInContext context) throws Exception {
        super.initialize(context);
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        String name;
        Polygon geom;
        Layerable layer = LayerTools.getSelectedLayerable(context, Layerable.class);
        WorkbenchContext wbcontext = context.getWorkbenchContext();
        Envelope envelope = new Envelope();
        for (Layerable layerable : wbcontext.getLayerableNamePanel().selectedNodes(Layerable.class)) {
            Layerable slayer = layerable;
            if (slayer instanceof WMSLayer) {
                envelope.expandToInclude(((WMSLayer)slayer).getEnvelope());
                continue;
            }
            if (slayer instanceof Layer) {
                if (((Layer)slayer).getFeatureCollectionWrapper().isEmpty()) {
                    context.getWorkbenchFrame().warnUser(I18N.getInstance().get("org.openjump.sigle.plugin.ReplaceValuePlugIn.Layer-has-no-feature"));
                    return false;
                }
                envelope.expandToInclude(((Layer)slayer).getFeatureCollectionWrapper().getEnvelope());
                continue;
            }
            if (!(slayer instanceof RasterImageLayer)) continue;
            envelope.expandToInclude(((RasterImageLayer)slayer).getWholeImageEnvelope());
        }
        GeometryFactory gf = new GeometryFactory();
        Envelope envCopy = new Envelope(envelope);
        if (envCopy.isNull()) {
            geom = gf.createPolygon(gf.createLinearRing(new Coordinate[0]));
        } else {
            if (envCopy.getArea() == 0.0) {
                envCopy.expandBy(1.0E-6);
            }
            geom = gf.toGeometry(envCopy);
        }
        FeatureSchema schema = this.getFeatureSchema();
        FeatureDataset newFeaturecollection = new FeatureDataset(schema);
        BasicFeature feature = new BasicFeature(schema);
        feature.setGeometry((Geometry)geom);
        int size = context.getSelectedLayerables().size();
        String path = NOTSAVED;
        String srid = null;
        if (size == 1 && layer != null) {
            name = layer.getName();
            if (layer instanceof WMSLayer) {
                path = ((WMSLayer)layer).getServerURL();
                srid = ((WMSLayer)layer).getSRS();
            } else if (layer instanceof RasterImageLayer) {
                path = ((RasterImageLayer)layer).getImageFileName();
                srid = this.getInfoProjection((RasterImageLayer)layer).getCode();
            } else if (layer instanceof Layer && ((Layer)layer).getStyle(ReferencedImageStyle.class) == null) {
                DataSourceQuery dsq = ((Layer)layer).getDataSourceQuery();
                if (dsq != null && dsq.getDataSource() != null) {
                    Object fnameObj = dsq.getDataSource().getProperties().get("File");
                    if (fnameObj == null) {
                        fnameObj = dsq.getDataSource().getProperties().get("Connection Descriptor");
                        path = ((ConnectionDescriptor)fnameObj).getParametersString();
                    } else {
                        path = fnameObj.toString().replace("%20", " ");
                    }
                }
                srid = this.getInfoProjection((Layer)layer).getCode();
            } else if (layer instanceof Layer && ((Layer)layer).getStyle(ReferencedImageStyle.class) != null) {
                FeatureCollectionWrapper featureCollection = ((Layer)layer).getFeatureCollectionWrapper();
                for (Feature feat : featureCollection) {
                    path = feat.getString("IMG_URI");
                    if (path == null) continue;
                    path = path.substring(5).replace("%20", " ");
                }
                srid = this.getInfoProjection((Layer)layer).getCode();
            }
        } else {
            name = MULTIPLESOURCE;
            path = MULTIPLESOURCE;
        }
        feature.setAttribute(LAYER, (Object)name);
        feature.setAttribute(SOURCE_PATH, (Object)path);
        feature.setAttribute(SRID, (Object)srid);
        feature.setAttribute(minX, envelope.isNull() ? null : Double.valueOf(ExportLayerableEnvelopeAsGeometryPlugIn.roundOff(envelope.getMinX())));
        feature.setAttribute(maxX, envelope.isNull() ? null : Double.valueOf(ExportLayerableEnvelopeAsGeometryPlugIn.roundOff(envelope.getMaxX())));
        feature.setAttribute(minY, envelope.isNull() ? null : Double.valueOf(ExportLayerableEnvelopeAsGeometryPlugIn.roundOff(envelope.getMinY())));
        feature.setAttribute(maxY, envelope.isNull() ? null : Double.valueOf(ExportLayerableEnvelopeAsGeometryPlugIn.roundOff(envelope.getMaxY())));
        newFeaturecollection.add(feature);
        ExportLayerableEnvelopeAsGeometryPlugIn.addLayer(this.ENVELOPE + "_" + name, newFeaturecollection, context, new RoleOutline(), Color.yellow);
        return false;
    }

    public static Layer addLayer(String title, FeatureCollection featCollection, PlugInContext context, FeatureCollectionRole role, Color color) {
        return LayerTools.addStandardResultLayer(title, featCollection, color, context, role);
    }

    private FeatureSchema getFeatureSchema() {
        FeatureSchema defaultSchema = new FeatureSchema();
        defaultSchema.addAttribute("GEOMETRY", AttributeType.GEOMETRY);
        defaultSchema.addAttribute(LAYER, AttributeType.STRING);
        defaultSchema.addAttribute(SOURCE_PATH, AttributeType.STRING);
        defaultSchema.addAttribute(SRID, AttributeType.STRING);
        defaultSchema.addAttribute(minX, AttributeType.DOUBLE);
        defaultSchema.addAttribute(maxX, AttributeType.DOUBLE);
        defaultSchema.addAttribute(minY, AttributeType.DOUBLE);
        defaultSchema.addAttribute(maxY, AttributeType.DOUBLE);
        return defaultSchema;
    }

    public static double roundOff(double number) {
        BigDecimal bigDecimal = new BigDecimal(number);
        BigDecimal roundedWithScale = bigDecimal.setScale(6, 6);
        double rounded = roundedWithScale.doubleValue();
        return rounded;
    }

    private SRSInfo getInfoProjection(Layer layer) throws Exception {
        SRSInfo srsInfo;
        try {
            srsInfo = ProjUtils.getSRSInfoFromLayerStyleOrSource(layer);
        }
        catch (Exception e) {
            srsInfo = ProjUtils.getSRSInfoFromLayerSource(layer);
        }
        if (srsInfo == null) {
            srsInfo = new SRSInfo();
        }
        return srsInfo;
    }

    private SRSInfo getInfoProjection(RasterImageLayer layer) throws Exception {
        TiffTags.TiffMetadata metadata;
        String fileSourcePath = layer.getImageFileName();
        String extension = FileUtil.getExtension(fileSourcePath).toLowerCase();
        SRSInfo srsInfo = extension.equals("tif") || extension.equals("tiff") ? ((metadata = TiffTags.readMetadata(new File(fileSourcePath))).isGeoTiff() ? metadata.getSRSInfo() : ProjUtils.getSRSInfoFromAuxiliaryFile(fileSourcePath)) : ProjUtils.getSRSInfoFromAuxiliaryFile(fileSourcePath);
        if (srsInfo == null) {
            srsInfo = new SRSInfo();
        }
        return srsInfo;
    }
}

