/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.file;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import com.vividsolutions.jump.workbench.ui.plugin.FeatureInstaller;
import java.io.File;
import javax.swing.ImageIcon;
import org.openjump.core.ui.enablecheck.BooleanPropertyEnableCheck;
import org.openjump.core.ui.plugin.AbstractWizardPlugin;
import org.openjump.core.ui.plugin.file.OpenWizardPlugIn;
import org.openjump.core.ui.plugin.file.open.OpenProjectWizard;

public class OpenProjectPlugIn
extends AbstractWizardPlugin {
    private static final String KEY = OpenProjectPlugIn.class.getName();
    private static final String FILE_DOES_NOT_EXIST = I18N.getInstance().get(KEY + ".file-does-not-exist");
    public static final ImageIcon ICON = IconLoader.icon("folder_page_oj_16.v9.png");
    private File[] files;
    private OpenProjectWizard wizard;

    public OpenProjectPlugIn() {
        super(ICON);
        this.setShortcutKeys(79);
        this.setShortcutModifiers(3);
    }

    public OpenProjectPlugIn(WorkbenchContext workbenchContext, File file) {
        super(file.getName(), ICON, file.getAbsolutePath());
        this.workbenchContext = workbenchContext;
        this.files = new File[]{file};
        this.enableCheck = new BooleanPropertyEnableCheck(file, "exists", true, FILE_DOES_NOT_EXIST + ": " + file.getAbsolutePath());
    }

    public OpenProjectPlugIn(WorkbenchContext workbenchContext, File[] files) {
        this.workbenchContext = workbenchContext;
        this.files = files;
    }

    @Override
    public void initialize(PlugInContext context) throws Exception {
        super.initialize(context);
        FeatureInstaller featureInstaller = context.getFeatureInstaller();
        featureInstaller.addMainMenuPlugin(this, new String[]{MenuNames.FILE});
        this.wizard = new OpenProjectWizard(this.workbenchContext);
        this.setWizard(this.wizard);
        OpenWizardPlugIn.addWizard(this.workbenchContext, this.wizard);
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        if (this.wizard == null) {
            this.wizard = new OpenProjectWizard(this.workbenchContext, this.files);
            this.setWizard(this.wizard);
        }
        return super.execute(context);
    }
}

