/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.file;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.coordsys.CoordinateSystemRegistry;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.io.datasource.Connection;
import com.vividsolutions.jump.io.datasource.DataSourceQuery;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.util.StringUtil;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.datasource.DataSourceQueryChooser;
import com.vividsolutions.jump.workbench.model.StandardCategoryNames;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import com.vividsolutions.jump.workbench.ui.wizard.WizardDialog;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.openjump.core.ui.plugin.file.ComponentWizardPanel;
import org.openjump.core.ui.plugin.file.open.ChooseProjectPanel;
import org.openjump.core.ui.swing.wizard.AbstractWizardGroup;
import org.openjump.core.ui.util.ExceptionUtil;

public class DataSourceQueryChooserOpenWizard
extends AbstractWizardGroup {
    public static final String KEY = DataSourceQueryChooserOpenWizard.class.getName();
    private DataSourceQueryChooser chooser;
    private WorkbenchContext workbenchContext;
    private ChooseProjectPanel chooseProjectPanel;

    public DataSourceQueryChooserOpenWizard(WorkbenchContext workbenchContext, DataSourceQueryChooser chooser) {
        super(chooser.toString(), IconLoader.icon("Table.gif"), chooser.getClass().getName());
        this.workbenchContext = workbenchContext;
        this.chooser = chooser;
    }

    @Override
    public void initialize(WorkbenchContext workbenchContext, WizardDialog dialog) {
        this.removeAllPanels();
        ComponentWizardPanel componentPanel = new ComponentWizardPanel(this.chooser.toString(), this.chooser.getClass().getName(), this.chooser.getComponent());
        this.chooseProjectPanel = new ChooseProjectPanel(workbenchContext, componentPanel.getID());
        this.addPanel(this.chooseProjectPanel);
        this.addPanel(componentPanel);
    }

    @Override
    public String getFirstId() {
        String firstId = super.getFirstId();
        if (!this.chooseProjectPanel.hasActiveTaskFrame() && this.chooseProjectPanel.hasTaskFrames()) {
            this.chooseProjectPanel.setNextID(firstId);
            return this.chooseProjectPanel.getID();
        }
        return firstId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(WizardDialog dialog, TaskMonitor monitor) {
        if (this.chooser.isInputValid()) {
            this.chooseProjectPanel.activateSelectedProject();
            PlugInContext context = this.workbenchContext.createPlugInContext();
            Collection<DataSourceQuery> dataSourceQueries = this.chooser.getDataSourceQueries();
            if (!dataSourceQueries.isEmpty()) {
                boolean exceptionsEncountered = false;
                for (DataSourceQuery dataSourceQuery : dataSourceQueries) {
                    ArrayList<Throwable> exceptions = new ArrayList<Throwable>();
                    if (dataSourceQuery.getDataSource().isReadable()) {
                        monitor.report("Loading " + dataSourceQuery.toString() + "...");
                        try (Connection connection = dataSourceQuery.getDataSource().getConnection();){
                            FeatureCollection dataset = dataSourceQuery.getDataSource().installCoordinateSystem(connection.executeQuery(dataSourceQuery.getQuery(), exceptions, monitor), CoordinateSystemRegistry.instance(this.workbenchContext.getBlackboard()));
                            if (dataset != null) {
                                context.getLayerManager().addLayer(this.chooseCategory(context), dataSourceQuery.toString(), dataset).setDataSourceQuery(dataSourceQuery).setFeatureCollectionModified(false);
                            }
                        }
                        if (exceptions.isEmpty()) continue;
                        if (!exceptionsEncountered) {
                            context.getOutputFrame().createNewDocument();
                            exceptionsEncountered = true;
                        }
                        this.reportExceptions(exceptions, dataSourceQuery, context);
                        continue;
                    }
                    context.getWorkbenchFrame().warnUser(I18N.getInstance().get("datasource.LoadDatasetPlugIn.query-not-readable"));
                }
                if (exceptionsEncountered) {
                    context.getWorkbenchFrame().warnUser(I18N.getInstance().get("datasource.LoadDatasetPlugIn.problems-were-encountered"));
                }
            } else {
                context.getWorkbenchFrame().warnUser(I18N.getInstance().get(KEY + ".no-queries-found"));
            }
        }
    }

    private String chooseCategory(PlugInContext context) {
        return context.getLayerNamePanel().getSelectedCategories().isEmpty() ? StandardCategoryNames.WORKING : context.getLayerNamePanel().getSelectedCategories().iterator().next().toString();
    }

    private void reportExceptions(List<Throwable> exceptions, DataSourceQuery dataSourceQuery, PlugInContext context) {
        context.getOutputFrame().addHeader(1, exceptions.size() + " " + I18N.getInstance().get("datasource.LoadDatasetPlugIn.problem") + StringUtil.s(exceptions.size()) + " " + I18N.getInstance().get("datasource.LoadDatasetPlugIn.loading") + " " + dataSourceQuery.toString() + "." + (exceptions.size() > 10 ? I18N.getInstance().get("datasource.LoadDatasetPlugIn.first-and-last-five") : ""));
        context.getOutputFrame().addText(I18N.getInstance().get("datasource.LoadDatasetPlugIn.see-view-log"));
        ExceptionUtil.reportExceptions(context, exceptions);
    }
}

