/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.edittoolbox.cursortools;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.geom.EnvelopeUtil;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.ui.AbstractSelection;
import com.vividsolutions.jump.workbench.ui.FeatureSelection;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.SelectionManager;
import com.vividsolutions.jump.workbench.ui.cursortool.QuasimodeTool;
import com.vividsolutions.jump.workbench.ui.cursortool.SelectTool;
import com.vividsolutions.jump.workbench.ui.cursortool.ShortcutsDescriptor;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.NoninvertibleTransformException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicCheckBoxMenuItemUI;
import javax.swing.plaf.basic.BasicMenuItemUI;
import org.locationtech.jts.geom.Coordinate;

public class SelectMultiItemsTool
extends SelectTool
implements ShortcutsDescriptor {
    static final String sSelectMultiItems = I18N.getInstance().get("org.openjump.core.ui.plugin.edittoolbox.cursortools.SelectMultiItemsTool");
    private AbstractSelection selection;
    private Coordinate coordinate;
    private LayerViewPanel layerViewPanel;
    int x;
    int y;

    public SelectMultiItemsTool(WorkbenchContext context) {
        super(context, "SELECTED_FEATURES");
    }

    @Override
    public Icon getIcon() {
        return IconLoader.icon("SelectMulti.png");
    }

    @Override
    public String getName() {
        return sSelectMultiItems;
    }

    @Override
    public boolean isRightMouseButtonUsed() {
        return true;
    }

    @Override
    public void activate(LayerViewPanel layerViewPanel) {
        this.layerViewPanel = layerViewPanel;
        super.activate(layerViewPanel);
        this.selection = layerViewPanel.getSelectionManager().getFeatureSelection();
    }

    @Override
    protected void gestureFinished() throws NoninvertibleTransformException {
        this.reportNothingToUndoYet();
        if (!this.wasShiftPressed()) {
            this.getPanel().getSelectionManager().clear();
        }
        Map<Layer, Set<Feature>> layerToFeaturesInFenceMap = this.getPanel().visibleLayerToFeaturesInFenceMap(EnvelopeUtil.toGeometry(this.getBoxInModelCoordinates()));
        HashMap<Feature, Boolean> map = new HashMap<Feature, Boolean>();
        int count = 0;
        for (Map.Entry<Layer, Set<Feature>> entry : layerToFeaturesInFenceMap.entrySet()) {
            Layer lyr = entry.getKey();
            Collection collection = entry.getValue();
            count += collection.size();
            for (Object obj : collection) {
                map.put((Feature)obj, this.selection.getFeaturesWithSelectedItems().contains(obj));
            }
            this.selection.unselectItems(lyr, collection);
        }
        if (count == 1) {
            Map.Entry<Layer, Set<Feature>> entry = layerToFeaturesInFenceMap.entrySet().iterator().next();
            this.selection.selectItems(entry.getKey(), (Feature)((Collection)entry.getValue()).iterator().next());
        } else if (count > 40) {
            JOptionPane.showMessageDialog(this.getWorkbench().getFrame(), I18N.getInstance().get("org.openjump.core.ui.plugin.edittoolbox.cursortools.SelectMultiItemsTool.Too-many-features"), I18N.getInstance().get("org.openjump.core.ui.plugin.edittoolbox.cursortools.SelectMultiItemsTool.Message"), 1);
            return;
        }
        SelectionManager selectionManager = this.layerViewPanel.getSelectionManager();
        final FeatureSelection featureSelection = selectionManager.getFeatureSelection();
        final JPopupMenu popupMenu = new JPopupMenu();
        JCheckBoxMenuItem jcbAll = new JCheckBoxMenuItem("<html><b>" + I18N.getInstance().get("org.openjump.core.ui.plugin.edittoolbox.cursortools.SelectMultiItemsTool.All") + "</b></html>");
        jcbAll.setUI(new StayOpenCheckBoxMenuItemUI());
        jcbAll.setSelected(false);
        this.addAll(popupMenu, jcbAll, featureSelection, layerToFeaturesInFenceMap);
        popupMenu.add(jcbAll);
        for (final Layer layer : layerToFeaturesInFenceMap.keySet()) {
            for (final Feature feature : (Collection)layerToFeaturesInFenceMap.get(layer)) {
                int fid = feature.getID();
                String label = layer.getName() + " (" + fid + ")";
                if (layer.isSelectable()) {
                    final JCheckBoxMenuItem jcb = new JCheckBoxMenuItem(label);
                    jcb.setSelected((Boolean)map.get(feature));
                    jcb.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            boolean selected = jcb.isSelected();
                            if (!selected) {
                                featureSelection.unselectItems(layer, feature);
                                SelectMultiItemsTool.this.layerViewPanel.fireSelectionChanged();
                                SelectMultiItemsTool.this.layerViewPanel.getSelectionManager().updatePanel();
                            } else {
                                featureSelection.selectItems(layer, feature);
                                SelectMultiItemsTool.this.layerViewPanel.fireSelectionChanged();
                                SelectMultiItemsTool.this.layerViewPanel.getSelectionManager().updatePanel();
                            }
                        }
                    });
                    jcb.setUI(new StayOpenCheckBoxMenuItemUI());
                    popupMenu.add(jcb);
                    continue;
                }
                label = "<html><i>" + label + "</i></html>";
                JMenuItem jmi = new JMenuItem(label);
                jmi.setUI(new StayOpenMenuItemUI());
                popupMenu.add(jmi);
            }
        }
        JMenuItem jcbValid = new JMenuItem("<html><b><i><font color=\"green\">" + I18N.getInstance().get("org.openjump.core.ui.plugin.edittoolbox.cursortools.SelectMultiItemsTool.Validate") + "</font></i></b></html>");
        jcbValid.setSelected(true);
        jcbValid.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                popupMenu.setVisible(false);
                popupMenu.setEnabled(false);
            }
        });
        popupMenu.add(jcbValid);
        if (count > 1) {
            this.layerViewPanel.add(popupMenu);
            popupMenu.show(this.layerViewPanel, (int)this.getViewSource().getX(), (int)this.getViewSource().getY());
            popupMenu.setVisible(true);
        }
    }

    private void addAll(final JPopupMenu popup, final JCheckBoxMenuItem item, final FeatureSelection featureSelection, final Map layerToFeaturesInFenceMap) {
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean selected = item.isSelected();
                if (!selected) {
                    for (Layer lyr : layerToFeaturesInFenceMap.keySet()) {
                        featureSelection.unselectItems(lyr, (Collection)layerToFeaturesInFenceMap.get(lyr));
                    }
                    SelectMultiItemsTool.this.layerViewPanel.fireSelectionChanged();
                    SelectMultiItemsTool.this.layerViewPanel.getSelectionManager().updatePanel();
                } else {
                    for (Layer lyr : layerToFeaturesInFenceMap.keySet()) {
                        if (!lyr.isSelectable()) continue;
                        featureSelection.selectItems(lyr, (Collection)layerToFeaturesInFenceMap.get(lyr));
                    }
                    SelectMultiItemsTool.this.layerViewPanel.fireSelectionChanged();
                    SelectMultiItemsTool.this.layerViewPanel.getSelectionManager().updatePanel();
                }
                MenuElement[] elements = popup.getSubElements();
                for (int i = 1; i < elements.length; ++i) {
                    if (!(elements[i] instanceof JCheckBoxMenuItem)) continue;
                    ((JCheckBoxMenuItem)elements[i]).setSelected(selected);
                }
            }
        });
    }

    @Override
    public Map<QuasimodeTool.ModifierKeySpec, String> describeShortcuts() {
        return null;
    }

    public static class StayOpenMenuItemUI
    extends BasicMenuItemUI {
        @Override
        protected void doClick(MenuSelectionManager msm) {
            this.menuItem.doClick(0);
        }

        public static ComponentUI createUI(JComponent c) {
            return new StayOpenCheckBoxMenuItemUI();
        }
    }

    public static class StayOpenCheckBoxMenuItemUI
    extends BasicCheckBoxMenuItemUI {
        @Override
        protected void doClick(MenuSelectionManager msm) {
            this.menuItem.doClick(0);
        }

        public static ComponentUI createUI(JComponent c) {
            return new StayOpenCheckBoxMenuItemUI();
        }
    }
}

