/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.edittoolbox.cursortools;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.ui.EditTransaction;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.cursortool.DragTool;
import com.vividsolutions.jump.workbench.ui.cursortool.QuasimodeTool;
import com.vividsolutions.jump.workbench.ui.cursortool.ShortcutsDescriptor;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import com.vividsolutions.jump.workbench.ui.snap.SnapManager;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.NoninvertibleTransformException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateFilter;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.openjump.core.geomutils.GeoUtils;

public class ScaleSelectedItemsTool
extends DragTool
implements ShortcutsDescriptor {
    private String scaleSelectedItems = "Scale Selected Items";
    private String sScaleFactor = "scale factor";
    private EnableCheckFactory checkFactory;
    private Shape selectionBBoxShape;
    private Geometry originalItemsAsLines = null;
    private Geometry outlineItems = null;
    private Shape outlineItemsShape = null;
    private GeometryFactory geometryFactory = new GeometryFactory();
    private List verticesToSnap = null;
    private Coordinate centerCoord;
    private Geometry originalBBox = null;
    private double xscale = 0.0;
    private double yscale = 0.0;
    private Coordinate mousePos = null;
    private Coordinate center = null;
    DecimalFormat df2 = new DecimalFormat("##0.0#");
    boolean startScaling = false;
    double toleranceFactor = 2.0;
    private BasicStroke originalStroke = null;
    boolean somethingChanged = false;
    int style = 1;
    Cursor cursor2 = ScaleSelectedItemsTool.createCursor(IconLoader.icon("MoveVertexCursor.gif").getImage());
    Cursor cursor1 = null;

    public ScaleSelectedItemsTool(WorkbenchContext context) {
        super(context);
        this.scaleSelectedItems = I18N.getInstance().get("org.openjump.core.ui.plugin.edittoolbox.cursortools.ScaleSelectedItemsTool.Scale-Selected-Items");
        this.sScaleFactor = I18N.getInstance().get("org.openjump.core.ui.plugin.edittoolbox.cursortools.ScaleSelectedItemsTool.scale-factor");
        this.checkFactory = EnableCheckFactory.getInstance(context);
        this.originalStroke = new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{3.0f, 3.0f}, 0.0f);
        this.setStroke(this.originalStroke);
        this.style = 1;
        this.allowSnapping();
        this.cursor1 = this.getCursor();
    }

    @Override
    protected void gestureFinished() throws Exception {
        if (this.startScaling) {
            this.reportNothingToUndoYet();
            ArrayList<EditTransaction> transactions = new ArrayList<EditTransaction>();
            for (Layer layerWithSelectedItems : this.getPanel().getSelectionManager().getLayersWithSelectedItems()) {
                transactions.add(this.createTransaction(layerWithSelectedItems));
            }
            EditTransaction.commit(transactions);
            this.startScaling = false;
            this.originalBBox = this.createSelectedItemsBoundingBox();
            this.outlineItemsShape = this.selectionBBoxShape = this.getPanel().getJava2DConverter().toShape(this.originalBBox);
            this.startScaling = false;
            this.somethingChanged = true;
        }
    }

    private EditTransaction createTransaction(Layer layer) {
        EditTransaction transaction = EditTransaction.createTransactionOnSelection(new EditTransaction.SelectionEditor(){

            public Geometry edit(Geometry geometryWithSelectedItems, Collection selectedItems) {
                for (Geometry item : selectedItems) {
                    ScaleSelectedItemsTool.this.scale(item);
                }
                return geometryWithSelectedItems;
            }
        }, this.getPanel(), this.getPanel().getContext(), this.getName(), layer, this.isRollingBackInvalidEdits(), false);
        return transaction;
    }

    private void scale(Geometry geometry) {
        geometry.apply(new CoordinateFilter(){

            public void filter(Coordinate coordinate) {
                coordinate.x = ((ScaleSelectedItemsTool)ScaleSelectedItemsTool.this).center.x + ScaleSelectedItemsTool.this.xscale * (coordinate.x - ((ScaleSelectedItemsTool)ScaleSelectedItemsTool.this).center.x);
                coordinate.y = ((ScaleSelectedItemsTool)ScaleSelectedItemsTool.this).center.y + ScaleSelectedItemsTool.this.yscale * (coordinate.y - ((ScaleSelectedItemsTool)ScaleSelectedItemsTool.this).center.y);
            }
        });
    }

    @Override
    public Icon getIcon() {
        return new ImageIcon(this.getClass().getResource("ScalePolygon.gif"));
    }

    @Override
    public String getName() {
        return this.scaleSelectedItems;
    }

    @Override
    public void activate(LayerViewPanel panel) {
        super.activate(panel);
        try {
            this.originalBBox = this.createSelectedItemsBoundingBox();
            this.outlineItemsShape = this.selectionBBoxShape = this.getPanel().getJava2DConverter().toShape(this.originalBBox);
            this.setStroke(this.originalStroke);
            this.setColor(Color.RED);
            this.style = 1;
            this.somethingChanged = true;
        }
        catch (Throwable t) {
            this.getPanel().getContext().handleThrowable(t);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.setStroke(this.originalStroke);
        this.setColor(Color.RED);
        this.style = 1;
        try {
            this.setMousePos(this.getPanel().getViewport().toModelCoordinate(e.getPoint()));
        }
        catch (Throwable t) {
            this.getPanel().getContext().handleThrowable(t);
        }
        double tolerance = (double)SnapManager.getToleranceInPixels(this.getWorkbench().getBlackboard()) / this.getPanel().getViewport().getScale();
        LineString ls = (LineString)this.originalBBox.getBoundary();
        MultiPoint mps = new GeometryFactory().createMultiPoint(ls.getCoordinates());
        Geometry buffergeom = mps.buffer(tolerance * this.toleranceFactor);
        Point mousep = new GeometryFactory().createPoint(this.mousePos);
        if (buffergeom.contains((Geometry)mousep)) {
            try {
                if (!this.check(this.checkFactory.createAtLeastNFeaturesMustBeSelectedCheck(1))) {
                    return;
                }
                if (!this.check(this.checkFactory.createSelectedItemsLayersMustBeEditableCheck())) {
                    return;
                }
                this.verticesToSnap = null;
                super.mousePressed(e);
                this.setSelectedItemsOutlines();
                this.originalBBox = this.createSelectedItemsBoundingBox();
                LineString lsBBox = (LineString)this.originalBBox.getBoundary();
                this.outlineItems = this.originalItemsAsLines.union((Geometry)lsBBox);
                this.outlineItemsShape = this.getPanel().getJava2DConverter().toShape(this.outlineItems);
                this.center = this.getFarestPoint(this.originalBBox, this.mousePos);
                this.startScaling = true;
                this.somethingChanged = true;
            }
            catch (Throwable t) {
                this.getPanel().getContext().handleThrowable(t);
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.startScaling) {
            super.mouseDragged(e);
            try {
                this.setMousePos(this.getPanel().getViewport().toModelCoordinate(e.getPoint()));
                double dxMouse = Math.abs(this.center.x - this.mousePos.x);
                double dyMouse = Math.abs(this.center.y - this.mousePos.y);
                double envWidth = this.originalBBox.getEnvelopeInternal().getWidth();
                double envHeight = this.originalBBox.getEnvelopeInternal().getHeight();
                this.xscale = envWidth == 0.0 ? 1.0 : dxMouse / envWidth;
                double d = this.yscale = envHeight == 0.0 ? 1.0 : dyMouse / envHeight;
                if (e.isShiftDown()) {
                    this.yscale = this.xscale;
                }
                this.getPanel().getContext().setStatusMessage(this.sScaleFactor + " x: " + this.df2.format(this.xscale) + "  " + this.sScaleFactor + " y: " + this.df2.format(this.yscale));
                Geometry geoms = (Geometry)this.outlineItems.clone();
                this.scale(geoms);
                this.outlineItemsShape = this.getPanel().getJava2DConverter().toShape(geoms);
                this.somethingChanged = true;
            }
            catch (Throwable t) {
                this.getPanel().getContext().handleThrowable(t);
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        try {
            this.setMousePos(this.getPanel().getViewport().toModelCoordinate(e.getPoint()));
            double tolerance = (double)SnapManager.getToleranceInPixels(this.getWorkbench().getBlackboard()) / this.getPanel().getViewport().getScale();
            LineString ls = (LineString)this.originalBBox.getBoundary();
            MultiPoint mps = new GeometryFactory().createMultiPoint(ls.getCoordinates());
            Geometry buffergeom = mps.buffer(tolerance * this.toleranceFactor);
            Point mousep = new GeometryFactory().createPoint(this.mousePos);
            if (buffergeom.contains((Geometry)mousep)) {
                if (this.style == 1) {
                    this.getPanel().setCursor(this.cursor2);
                    this.style = 2;
                    this.somethingChanged = true;
                }
            } else if (this.style == 2) {
                this.getPanel().setCursor(this.cursor1);
                this.style = 1;
                this.somethingChanged = true;
            }
            if (this.somethingChanged) {
                this.redrawShape();
                this.somethingChanged = false;
            }
        }
        catch (Throwable t) {
            this.getPanel().getContext().handleThrowable(t);
        }
    }

    private Geometry createSelectedItemsBoundingBox() {
        Collection<Geometry> selectedGeos = this.getPanel().getSelectionManager().getSelectedItems();
        double xmin = 0.0;
        double xmax = 0.0;
        double ymin = 0.0;
        double ymax = 0.0;
        int count = 0;
        for (Geometry element : selectedGeos) {
            if (count == 0) {
                xmin = element.getEnvelopeInternal().getMinX();
                xmax = element.getEnvelopeInternal().getMaxX();
                ymin = element.getEnvelopeInternal().getMinY();
                ymax = element.getEnvelopeInternal().getMaxY();
            } else {
                if (element.getEnvelopeInternal().getMinX() < xmin) {
                    xmin = element.getEnvelopeInternal().getMinX();
                }
                if (element.getEnvelopeInternal().getMaxX() > xmax) {
                    xmax = element.getEnvelopeInternal().getMaxX();
                }
                if (element.getEnvelopeInternal().getMinY() < ymin) {
                    ymin = element.getEnvelopeInternal().getMinY();
                }
                if (element.getEnvelopeInternal().getMaxY() > ymax) {
                    ymax = element.getEnvelopeInternal().getMaxY();
                }
            }
            ++count;
        }
        Coordinate[] coords = new Coordinate[]{new Coordinate(xmin, ymin), new Coordinate(xmin, ymax), new Coordinate(xmax, ymax), new Coordinate(xmax, ymin), new Coordinate(xmin, ymin)};
        LinearRing ring = new GeometryFactory().createLinearRing(coords);
        Polygon geo = new GeometryFactory().createPolygon(ring, null);
        this.centerCoord = geo.getCentroid().getCoordinate();
        return geo;
    }

    private void setSelectedItemsOutlines() throws NoninvertibleTransformException {
        Collection<Geometry> selectedGeos = this.getPanel().getSelectionManager().getSelectedItems();
        Geometry geo = null;
        for (Geometry element : selectedGeos) {
            if (geo == null) {
                if (element instanceof Polygon) {
                    geo = element.getBoundary();
                    continue;
                }
                geo = (Geometry)element.clone();
                continue;
            }
            if (element instanceof Polygon) {
                geo = geo.union(element.getBoundary());
                continue;
            }
            geo = geo.union((Geometry)element.clone());
        }
        this.originalItemsAsLines = geo;
    }

    @Override
    protected Shape getShape() {
        return this.outlineItemsShape;
    }

    public void deactivate(MouseEvent e) {
        super.deactivate();
        this.cleanup((Graphics2D)this.getPanel().getGraphics());
    }

    protected void setMousePos(Coordinate destination) {
        this.mousePos = this.snap(destination);
    }

    private Coordinate getFarestPoint(Geometry box, Coordinate point) {
        Coordinate farestp = null;
        double maxDist = 0.0;
        double dist = 0.0;
        Coordinate[] coords = box.getCoordinates();
        for (int i = 0; i < coords.length; ++i) {
            dist = GeoUtils.distance(coords[i], point);
            if (!(dist > maxDist)) continue;
            maxDist = dist;
            farestp = (Coordinate)coords[i].clone();
        }
        return farestp;
    }

    @Override
    public Map<QuasimodeTool.ModifierKeySpec, String> describeShortcuts() {
        HashMap<QuasimodeTool.ModifierKeySpec, String> map = new HashMap<QuasimodeTool.ModifierKeySpec, String>();
        map.put(new QuasimodeTool.ModifierKeySpec(new int[]{16}), I18N.getInstance().get(this.getClass().getName() + ".keep-aspect-ratio"));
        return map;
    }
}

