/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.edittoolbox.cursortools;

import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.ui.EditTransaction;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import java.awt.geom.NoninvertibleTransformException;
import java.util.ArrayList;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.operation.valid.IsValidOp;
import org.openjump.core.ui.plugin.edittoolbox.cursortools.ConstrainedMultiClickTool;

public abstract class ConstrainedPolygonTool
extends ConstrainedMultiClickTool {
    public ConstrainedPolygonTool(WorkbenchContext context) {
        super(context);
        this.drawClosed = true;
    }

    protected Polygon getPolygon() throws NoninvertibleTransformException {
        ArrayList<Coordinate> closedPoints = new ArrayList<Coordinate>(this.getCoordinates());
        if (!closedPoints.get(0).equals(closedPoints.get(closedPoints.size() - 1))) {
            closedPoints.add(new Coordinate((Coordinate)closedPoints.get(0)));
        }
        return new GeometryFactory().createPolygon(new GeometryFactory().createLinearRing(this.toArray(closedPoints)), null);
    }

    protected boolean checkPolygon() throws NoninvertibleTransformException {
        if (this.getCoordinates().size() < 3) {
            this.getPanel().getContext().warnUser("The polygon must have at least 3 points");
            return false;
        }
        IsValidOp isValidOp = new IsValidOp((Geometry)this.getPolygon());
        if (!isValidOp.isValid()) {
            this.getPanel().getContext().warnUser(isValidOp.getValidationError().getMessage());
            if (PersistentBlackboardPlugIn.get(this.getWorkbench().getContext()).get(EditTransaction.ROLLING_BACK_INVALID_EDITS_KEY, false)) {
                return false;
            }
        }
        return true;
    }
}

