/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.datastore.postgis;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.datastore.SQLUtil;
import com.vividsolutions.jump.datastore.postgis.PostgisDataStoreDriver;
import com.vividsolutions.jump.workbench.datasource.DataSourceQueryChooser;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JOptionPane;
import org.openjump.core.ccordsys.srid.SRIDStyle;
import org.openjump.core.ui.plugin.datastore.postgis.PostGISSaveDriverPanel;
import org.openjump.core.ui.plugin.datastore.postgis.SaveToPostGISDataSource;
import org.openjump.core.ui.plugin.datastore.postgis.SaveToPostGISDataSourceQuery;

public class PostGISSaveDataSourceQueryChooser
implements DataSourceQueryChooser {
    public static final String KEY = PostGISSaveDataSourceQueryChooser.class.getName();
    static final String ERROR = I18N.getInstance().get(KEY + ".error");
    static final String NO_CONNECTION_CHOOSEN = I18N.getInstance().get(KEY + ".no-connection-choosen");
    static final String NO_TABLE_CHOOSEN = I18N.getInstance().get(KEY + ".no-table-choosen");
    static final String CONNECTION_IS_NOT_POSTGIS = I18N.getInstance().get(KEY + ".selected-connection-is-not-postgis");
    static final String UNIQUE_IDENTIFIER_NEEDED = I18N.getInstance().get(KEY + ".unique-identifier-is-needed");
    private PlugInContext context;
    private PostGISSaveDriverPanel pgpanel = null;
    private SaveToPostGISDataSource dataSource;
    private Map<String, Object> properties = new HashMap<String, Object>();

    public PostGISSaveDataSourceQueryChooser(SaveToPostGISDataSource dataSource, PlugInContext context) {
        this.dataSource = dataSource;
        this.context = context;
    }

    @Override
    public Component getComponent() {
        if (this.pgpanel == null) {
            this.pgpanel = new PostGISSaveDriverPanel(this.context);
        }
        return this.pgpanel;
    }

    public Collection getDataSourceQueries() {
        String updateQuery = (String)this.properties.get("Table");
        SaveToPostGISDataSourceQuery query = new SaveToPostGISDataSourceQuery(this.getDataSource(), updateQuery, (String)this.properties.get("Table"));
        query.setProperties(this.getProperties());
        ArrayList<SaveToPostGISDataSourceQuery> queries = new ArrayList<SaveToPostGISDataSourceQuery>();
        queries.add(query);
        return queries;
    }

    @Override
    public boolean isInputValid() {
        PostGISSaveDriverPanel panel = (PostGISSaveDriverPanel)this.getComponent();
        if (panel.getConnectionDescriptor() == null) {
            JOptionPane.showMessageDialog(panel, NO_CONNECTION_CHOOSEN, ERROR, 0);
            return false;
        }
        if (!panel.getConnectionDescriptor().getDataStoreDriverClassName().equals(PostgisDataStoreDriver.class.getName())) {
            JOptionPane.showMessageDialog(null, CONNECTION_IS_NOT_POSTGIS, ERROR, 0);
            return false;
        }
        if (panel.getTableName() == null || panel.getTableName().trim().length() == 0) {
            JOptionPane.showMessageDialog(panel, NO_TABLE_CHOOSEN, ERROR, 0);
            return false;
        }
        if ((panel.getPrimaryKey() == null || panel.getPrimaryKey().trim().length() == 0) && (panel.getSaveMethod().equals("Update") || panel.getSaveMethod().equals("Delete"))) {
            JOptionPane.showMessageDialog(panel, UNIQUE_IDENTIFIER_NEEDED, ERROR, 0);
            return false;
        }
        this.properties.put("Table", panel.getTableName());
        return true;
    }

    protected Map getProperties() {
        PostGISSaveDriverPanel panel = (PostGISSaveDriverPanel)this.getComponent();
        if (this.properties == null) {
            this.properties = new HashMap<String, Object>();
        }
        this.properties.put("Connection Descriptor", panel.getConnectionDescriptor());
        this.properties.put("Table", panel.getTableName());
        this.properties.put("Save method", panel.getSaveMethod());
        this.properties.put("Primary Key", panel.getPrimaryKey());
        this.properties.put("Use DB Primary Key", panel.isCreatePrimaryKeyColumnSelected());
        Layer[] layers = this.context.getWorkbenchContext().getLayerNamePanel().getSelectedLayers();
        if (layers.length == 1) {
            this.properties.put("Dataset Name", layers[0].getName());
            String[] schema_table = SQLUtil.splitTableName(panel.getTableName());
            this.properties.put("SQL Query", "SELECT * FROM " + SQLUtil.compose(schema_table[0], schema_table[1]) + " LIMIT 100000");
            SRIDStyle sridStyle = (SRIDStyle)layers[0].getStyle(SRIDStyle.class);
            this.properties.put("SRID", sridStyle.getSRID());
        }
        return this.properties;
    }

    protected SaveToPostGISDataSource getDataSource() {
        return this.dataSource;
    }

    @Override
    public String toString() {
        return I18N.getInstance().get(KEY + ".postgis-table");
    }
}

