/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.datastore;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.coordsys.CoordinateSystemRegistry;
import com.vividsolutions.jump.datastore.spatialdatabases.SpatialDSLayer;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.io.datasource.Connection;
import com.vividsolutions.jump.io.datasource.DataSource;
import com.vividsolutions.jump.io.datasource.DataSourceQuery;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.workbench.Logger;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.datastore.ConnectionDescriptor;
import com.vividsolutions.jump.workbench.model.Category;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.model.StandardCategoryNames;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import com.vividsolutions.jump.workbench.ui.plugin.AddNewLayerPlugIn;
import com.vividsolutions.jump.workbench.ui.wizard.WizardDialog;
import java.awt.Color;
import java.util.Collection;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import org.openjump.core.ccordsys.srid.SRIDStyle;
import org.openjump.core.ui.plugin.datastore.AddWritableDataStoreLayerPanel;
import org.openjump.core.ui.plugin.datastore.AddWritableDataStoreLayerWizardPanel;
import org.openjump.core.ui.plugin.datastore.DataStoreDataSourceFactory;
import org.openjump.core.ui.plugin.datastore.WritableDataStoreDataSource;
import org.openjump.core.ui.plugin.datastore.transaction.DataStoreTransactionManager;
import org.openjump.core.ui.plugin.file.open.ChooseProjectPanel;
import org.openjump.core.ui.swing.wizard.AbstractWizardGroup;

public class AddWritableDataStoreLayerWizard
extends AbstractWizardGroup {
    private static final String KEY = AddWritableDataStoreLayerWizard.class.getName();
    private AddWritableDataStoreLayerWizardPanel dataStoreWizardPanel;
    private String txManagerName;
    private WorkbenchContext workbenchContext;
    private ChooseProjectPanel chooseProjectPanel;

    public AddWritableDataStoreLayerWizard(String name, ImageIcon icon, WorkbenchContext workbenchContext, String txManagerName) {
        super(name, icon, AddWritableDataStoreLayerWizardPanel.class.getName());
        this.txManagerName = txManagerName;
        this.workbenchContext = workbenchContext;
        this.dataStoreWizardPanel = new AddWritableDataStoreLayerWizardPanel(workbenchContext);
        this.addPanel(this.dataStoreWizardPanel);
        this.chooseProjectPanel = new ChooseProjectPanel(workbenchContext, this.dataStoreWizardPanel.getID());
        this.addPanel(this.chooseProjectPanel);
    }

    public AddWritableDataStoreLayerWizard(WorkbenchContext workbenchContext, String txManagerName) {
        super(I18N.getInstance().get(KEY), IconLoader.icon("database_writable_add.png"), AddWritableDataStoreLayerWizardPanel.class.getName());
        this.txManagerName = txManagerName;
        this.workbenchContext = workbenchContext;
        this.dataStoreWizardPanel = new AddWritableDataStoreLayerWizardPanel(workbenchContext);
        this.addPanel(this.dataStoreWizardPanel);
        this.chooseProjectPanel = new ChooseProjectPanel(workbenchContext, this.dataStoreWizardPanel.getID());
        this.addPanel(this.chooseProjectPanel);
    }

    @Override
    public String getFirstId() {
        String firstId = super.getFirstId();
        if (!this.chooseProjectPanel.hasActiveTaskFrame() && this.chooseProjectPanel.hasTaskFrames()) {
            this.chooseProjectPanel.setNextID(firstId);
            return this.chooseProjectPanel.getID();
        }
        return firstId;
    }

    @Override
    public void run(WizardDialog dialog, TaskMonitor monitor) throws Exception {
        this.chooseProjectPanel.activateSelectedProject();
        AddWritableDataStoreLayerPanel dataStorePanel = this.dataStoreWizardPanel.getDataStorePanel();
        if (dataStorePanel.validateInput() != null) {
            throw new Exception(dataStorePanel.validateInput());
        }
        final Layer layer = this.createLayer(dataStorePanel, monitor);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Collection<Category> selectedCategories = AddWritableDataStoreLayerWizard.this.workbenchContext.getLayerableNamePanel().getSelectedCategories();
                LayerManager layerManager = AddWritableDataStoreLayerWizard.this.workbenchContext.getLayerManager();
                String categoryName = StandardCategoryNames.WORKING;
                if (!selectedCategories.isEmpty()) {
                    categoryName = selectedCategories.iterator().next().getName();
                }
                try {
                    AddWritableDataStoreLayerWizard.this.workbenchContext.getLayerViewPanel().getViewport().update();
                }
                catch (Exception e) {
                    Logger.warn("Exception thrown by AddWritableDataStoreLayerWizard while displaying data in the view", e);
                }
                layerManager.addLayerable(categoryName, layer);
            }
        });
        this.workbenchContext.getLayerViewPanel().getViewport().update();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Layer createLayer(AddWritableDataStoreLayerPanel panel, TaskMonitor monitor) throws Exception {
        String datasetName = panel.getDatasetName();
        LayerManager layerManager = this.workbenchContext.getLayerManager();
        Color fillColor = layerManager.generateLayerFillColor();
        FeatureCollection featureCollection = AddNewLayerPlugIn.createBlankFeatureCollection();
        SpatialDSLayer layer = new SpatialDSLayer(datasetName, fillColor, featureCollection, layerManager, this.workbenchContext);
        String geometryAttributeName = panel.getGeometryAttributeName();
        String identifierAttributeName = panel.getIdentifierAttributeName();
        String whereClause = panel.getWhereClause();
        int limit = panel.getMaxFeatures();
        ConnectionDescriptor connectionDescriptor = panel.getConnectionDescriptor();
        boolean limitedToView = panel.isLimitedToView();
        boolean manageConflicts = panel.isManageConfictsActive();
        WritableDataStoreDataSource ds = DataStoreDataSourceFactory.createWritableDataStoreDataSource(connectionDescriptor, datasetName, geometryAttributeName, identifierAttributeName, true, this.txManagerName, this.workbenchContext);
        ds.setMaxFeature(limit);
        ds.setWhereClause(whereClause);
        ds.setLimitedToView(limitedToView);
        ds.setManageConflicts(manageConflicts);
        ds.setWorkbenchContext(this.workbenchContext);
        ds.setMultiGeometry(panel.getGeometryColumn().getType().toLowerCase().startsWith("multi"));
        ds.setCoordDimension(panel.getGeometryColumn().getCoordDimension());
        ds.setSRID(panel.getGeometryColumn().getSRID());
        DataSourceQuery dsq = new DataSourceQuery(ds, null, datasetName);
        boolean isFiringEvents = layerManager.isFiringEvents();
        layerManager.setFiringEvents(false);
        layer.setDataSourceQuery(dsq);
        CoordinateSystemRegistry crsRegistry = CoordinateSystemRegistry.instance(this.workbenchContext.getBlackboard());
        try {
            AddWritableDataStoreLayerWizard.load(layer, crsRegistry, monitor);
            SRIDStyle sridStyle = new SRIDStyle();
            sridStyle.setSRID(panel.getGeometryColumn().getSRID());
            layer.addStyle(sridStyle);
            Logger.info("Add layer '" + layer.getName() + "' to '" + layerManager.getTask().getName() + "' using WritableDataStoreDataSource with :");
            Logger.info("    geometry column    = " + geometryAttributeName);
            Logger.info("    is_multi           = " + panel.getGeometryColumn().getType().toLowerCase().startsWith("multi"));
            Logger.info("    coord_dimension    = " + panel.getGeometryColumn().getCoordDimension());
            Logger.info("    srid               = " + sridStyle.getSRID());
            Logger.info("    external PK column = " + identifierAttributeName);
            Logger.info("    max features       = " + limit);
            Logger.info("    where clause       = " + whereClause);
            Logger.info("    limit to view      = " + limitedToView);
        }
        finally {
            layerManager.setFiringEvents(isFiringEvents);
        }
        Object txManager = DataStoreTransactionManager.getTxInstance(this.txManagerName);
        ((DataStoreTransactionManager)txManager).registerLayer(layer, this.workbenchContext.getTask());
        return layer;
    }

    public static void load(Layer layer, CoordinateSystemRegistry registry, TaskMonitor monitor) throws Exception {
        layer.setFeatureCollection(AddWritableDataStoreLayerWizard.executeQuery(layer.getDataSourceQuery().getQuery(), layer.getDataSourceQuery().getDataSource(), registry, monitor));
        layer.setFeatureCollectionModified(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FeatureCollection executeQuery(String query, DataSource dataSource, CoordinateSystemRegistry registry, TaskMonitor monitor) throws Exception {
        try (Connection connection = dataSource.getConnection();){
            FeatureCollection featureCollection = dataSource.installCoordinateSystem(connection.executeQuery(query, monitor), registry);
            return featureCollection;
        }
    }
}

