/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.io.file;

import java.io.File;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Locale;
import javax.swing.filechooser.FileFilter;

public class FileNameExtensionFilter
extends FileFilter {
    private final String description;
    private String fullDescription;
    private final String[] extensions;
    private final String[] lowerCaseExtensions;
    private boolean filter = true;

    public FileNameExtensionFilter(String description, String extension) {
        this(description, new String[]{extension});
    }

    public FileNameExtensionFilter(String description, String[] extensions) {
        if (extensions == null || extensions.length == 0) {
            this.filter = false;
        }
        this.description = description;
        this.extensions = new String[extensions.length];
        this.lowerCaseExtensions = new String[extensions.length];
        for (int i = 0; i < extensions.length; ++i) {
            if (extensions[i] == null || extensions[i].length() == 0) {
                throw new IllegalArgumentException("Each extension must be non-null and not empty");
            }
            if (extensions[i] == "*") {
                this.filter = false;
            }
            this.extensions[i] = extensions[i];
            this.lowerCaseExtensions[i] = extensions[i].toLowerCase(Locale.ENGLISH);
        }
    }

    @Override
    public boolean accept(File f) {
        if (f != null) {
            if (!this.filter) {
                return true;
            }
            if (f.isDirectory()) {
                return true;
            }
            String filename = f.getName().toLowerCase();
            for (String extension : this.lowerCaseExtensions) {
                if (!filename.endsWith("." + extension)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public String getDescription() {
        return this.getFullDescription();
    }

    public String[] getExtensions() {
        String[] result = new String[this.extensions.length];
        System.arraycopy(this.extensions, 0, result, 0, this.extensions.length);
        return result;
    }

    public String toString() {
        return super.toString() + "[description=" + this.getDescription() + " extensions=" + Arrays.asList(this.getExtensions()) + "]";
    }

    public String getFullDescription() {
        if (this.fullDescription != null) {
            return this.fullDescription.toString();
        }
        StringBuffer buffy = new StringBuffer();
        buffy.append(this.description);
        if (this.extensions.length > 0) {
            buffy.append(" (");
            Iterator<String> extensions = Arrays.asList(this.extensions).iterator();
            while (extensions.hasNext()) {
                String extension = extensions.next();
                buffy.append("*.");
                buffy.append(extension);
                if (!extensions.hasNext()) continue;
                buffy.append(",");
            }
            buffy.append(")");
        }
        buffy.setCharAt(0, Character.toUpperCase(buffy.charAt(0)));
        int maxlen = 80;
        this.fullDescription = buffy.length() > maxlen ? buffy.substring(0, maxlen) + "..." : buffy.toString();
        return this.fullDescription;
    }
}

