/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.rasterimage.styler.ui;

import com.vividsolutions.jump.I18N;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openjump.core.rasterimage.styler.ColorMapEntry;
import org.openjump.core.rasterimage.styler.ui.GUIUtils;
import org.openjump.core.rasterimage.styler.ui.GradientCanvas;

public class GradientLabelLegendComponent
extends JComponent {
    private final TreeMap<Double, Color> colorMapEntries_tm;
    private final double noDataValue;
    private final String rasterName;

    public GradientLabelLegendComponent(TreeMap<Double, Color> colorMapEntries, double noDataValue, String rasterName) {
        this.colorMapEntries_tm = colorMapEntries;
        this.noDataValue = noDataValue;
        this.rasterName = rasterName;
        this.jInit();
    }

    private void jInit() {
        double minValue = Double.MAX_VALUE;
        double maxValue = Double.MIN_VALUE;
        for (Map.Entry<Double, Color> colorMapEntry : this.colorMapEntries_tm.entrySet()) {
            if (colorMapEntry.getKey() == this.noDataValue) continue;
            if (colorMapEntry.getKey() < minValue) {
                minValue = colorMapEntry.getKey();
            }
            if (!(colorMapEntry.getKey() > maxValue)) continue;
            maxValue = colorMapEntry.getKey();
        }
        ColorMapEntry[] paletteColorMapEntry = new ColorMapEntry[this.colorMapEntries_tm.size() - 1];
        int count = 0;
        Color noDataColor = null;
        for (Map.Entry<Double, Color> colorMapEntry : this.colorMapEntries_tm.entrySet()) {
            if (colorMapEntry.getKey() != this.noDataValue) {
                double quantity = (colorMapEntry.getKey() - minValue) / (maxValue - minValue);
                paletteColorMapEntry[count] = new ColorMapEntry(quantity, colorMapEntry.getValue());
                ++count;
                continue;
            }
            noDataColor = colorMapEntry.getValue();
        }
        JPanel jPanel_Gradient = new JPanel();
        JLabel jLabel_MaxValue = new JLabel();
        JLabel jLabel_MinValue = new JLabel();
        JLabel jLabel_RasterName = new JLabel(this.rasterName);
        JLabel jLabel_NoDataTitle = new JLabel(I18N.getInstance().get("org.openjump.core.ui.plugin.raster.nodata.nodata"));
        JLabel jLabel_NoDataColor = new JLabel();
        JLabel jLabel_NoDataValue = new JLabel(Double.toString(this.noDataValue));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        jLabel_RasterName.setFont(new Font("Tahoma", 1, 14));
        jLabel_RasterName.setPreferredSize(new Dimension(50, 14));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 10, 10);
        this.add((Component)jLabel_RasterName, gridBagConstraints);
        jPanel_Gradient.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        jPanel_Gradient.setMinimumSize(new Dimension(40, 100));
        jPanel_Gradient.setPreferredSize(new Dimension(40, 100));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(20, 0, 11, 0);
        this.add((Component)jPanel_Gradient, gridBagConstraints);
        jLabel_MaxValue.setText(Double.toString(GUIUtils.round(maxValue, 3)));
        jLabel_MaxValue.setMinimumSize(new Dimension(50, 14));
        jLabel_MaxValue.setPreferredSize(new Dimension(50, 14));
        jLabel_MaxValue.setFont(new Font("Tahoma", 0, 12));
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(20, 5, 0, 0);
        this.add((Component)jLabel_MaxValue, gridBagConstraints);
        jLabel_MinValue.setText(Double.toString(GUIUtils.round(minValue, 3)));
        jLabel_MinValue.setMinimumSize(new Dimension(50, 14));
        jLabel_MinValue.setPreferredSize(new Dimension(50, 14));
        jLabel_MinValue.setFont(new Font("Tahoma", 0, 12));
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.insets = new Insets(0, 5, 11, 0);
        this.add((Component)jLabel_MinValue, gridBagConstraints);
        jLabel_NoDataTitle.setMinimumSize(new Dimension(70, 14));
        jLabel_NoDataTitle.setPreferredSize(new Dimension(70, 14));
        jLabel_NoDataTitle.setFont(new Font("Tahoma", 0, 12));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.add((Component)jLabel_NoDataTitle, gridBagConstraints);
        jLabel_NoDataColor.setBackground(noDataColor);
        jLabel_NoDataColor.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        jLabel_NoDataColor.setMaximumSize(new Dimension(40, 25));
        jLabel_NoDataColor.setMinimumSize(new Dimension(40, 25));
        jLabel_NoDataColor.setPreferredSize(new Dimension(40, 25));
        jLabel_NoDataColor.setFont(new Font("Tahoma", 0, 12));
        jLabel_NoDataColor.setOpaque(true);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.add((Component)jLabel_NoDataColor, gridBagConstraints);
        jLabel_NoDataValue.setPreferredSize(new Dimension(50, 14));
        jLabel_NoDataValue.setFont(new Font("Tahoma", 0, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.add((Component)jLabel_NoDataValue, gridBagConstraints);
        GradientCanvas gradientCanvas = new GradientCanvas(paletteColorMapEntry, 40, 100, GradientCanvas.GradientType.VERTICAL, GradientCanvas.GradientOrientation.INVERSE);
        jPanel_Gradient.setLayout(new BorderLayout());
        jPanel_Gradient.add((Component)gradientCanvas, "Center");
        this.setPreferredSize(new Dimension(200, 250));
    }
}

