/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.rasterimage.sextante.rasterWrappers;

import java.awt.Point;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import javax.media.jai.RasterFactory;
import org.openjump.core.rasterimage.sextante.OpenJUMPSextanteRasterLayer;
import org.openjump.core.rasterimage.sextante.rasterWrappers.GridWrapperNotInterpolated;

public class GridRasterWrapper {
    public static double[][] rasterToMatrix(OpenJUMPSextanteRasterLayer rstLayer, int band) {
        int nx = rstLayer.getLayerGridExtent().getNX();
        int ny = rstLayer.getLayerGridExtent().getNY();
        GridWrapperNotInterpolated gwrapper = new GridWrapperNotInterpolated(rstLayer, rstLayer.getLayerGridExtent());
        double[][] data = new double[nx][ny];
        for (int x = 0; x < nx; ++x) {
            for (int y = 0; y < ny; ++y) {
                double value;
                data[x][y] = value = gwrapper.getCellValueAsDouble(x, y, band);
            }
        }
        return data;
    }

    public static double[][] rasterToEmptyMatrix(OpenJUMPSextanteRasterLayer rstLayer, int band) {
        int nx = rstLayer.getLayerGridExtent().getNX();
        int ny = rstLayer.getLayerGridExtent().getNY();
        double[][] data = new double[nx][ny];
        for (int x = 0; x < nx; ++x) {
            for (int y = 0; y < ny; ++y) {
                data[x][y] = rstLayer.getNoDataValue();
            }
        }
        return data;
    }

    public static double[][] rasterToMatrix(OpenJUMPSextanteRasterLayer rstLayer) {
        return GridRasterWrapper.rasterToMatrix(rstLayer, 0);
    }

    public static double[] rasterToArray(OpenJUMPSextanteRasterLayer rstLayer, int band) {
        int nx = rstLayer.getLayerGridExtent().getNX();
        int ny = rstLayer.getLayerGridExtent().getNY();
        GridWrapperNotInterpolated gwrapper = new GridWrapperNotInterpolated(rstLayer, rstLayer.getLayerGridExtent());
        double[] data = new double[nx * ny];
        int i = 0;
        for (int x = 0; x < nx; ++x) {
            for (int y = 0; y < ny; ++y) {
                double value = gwrapper.getCellValueAsDouble(x, y, band);
                if (value == rstLayer.getNoDataValue()) continue;
                data[i] = value;
                ++i;
            }
        }
        double[] data2 = new double[i];
        System.arraycopy(data, 0, data2, 0, i);
        return data2;
    }

    public static double[] rasterToArray(OpenJUMPSextanteRasterLayer rstLayer) {
        return GridRasterWrapper.rasterToArray(rstLayer, 0);
    }

    public static double[] rasterToArray(OpenJUMPSextanteRasterLayer rstLayer, int band, double min, double max) {
        int nx = rstLayer.getLayerGridExtent().getNX();
        int ny = rstLayer.getLayerGridExtent().getNY();
        GridWrapperNotInterpolated gwrapper = new GridWrapperNotInterpolated(rstLayer, rstLayer.getLayerGridExtent());
        double[] data = new double[nx * ny];
        int i = 0;
        for (int x = 0; x < nx; ++x) {
            for (int y = 0; y < ny; ++y) {
                double value = gwrapper.getCellValueAsDouble(x, y, band);
                if (!(value != rstLayer.getNoDataValue() & value > min & value < max)) continue;
                data[i] = value;
                ++i;
            }
        }
        double[] data2 = new double[i];
        System.arraycopy(data, 0, data2, 0, i);
        return data2;
    }

    public static double[] rasterToArray(OpenJUMPSextanteRasterLayer rstLayer, double min, double max) {
        return GridRasterWrapper.rasterToArray(rstLayer, 0, min, max);
    }

    public static Raster matrixToRaster(double[][] matrix, SampleModel model) {
        return GridRasterWrapper.matrixToRaster(matrix, model, 0);
    }

    public static Raster matrixToRaster(double[][] matrix, SampleModel model, int band) {
        int w = matrix.length;
        int h = matrix[0].length;
        WritableRaster raster = Raster.createWritableRaster(model, new Point(0, 0));
        for (int i = 0; i < w; ++i) {
            for (int j = 0; j < h; ++j) {
                raster.setSample(i, j, band, matrix[i][j]);
            }
        }
        return raster;
    }

    public static double[][] rasterToMatrix(Raster raster) {
        try {
            int w = raster.getWidth();
            int h = raster.getHeight();
            double[][] pixels = new double[w][h];
            for (int x = 0; x < w; ++x) {
                for (int y = 0; y < h; ++y) {
                    pixels[x][y] = raster.getSampleDouble(x, y, 0);
                }
            }
            return pixels;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static WritableRaster matrixToRaster(double[][] matrix) {
        int w = matrix.length;
        int h = matrix[0].length;
        WritableRaster raster = RasterFactory.createBandedRaster((int)4, (int)w, (int)h, (int)1, null);
        for (int i = 0; i < w; ++i) {
            for (int j = 0; j < h; ++j) {
                raster.setSample(i, j, 0, matrix[i][j]);
            }
        }
        return raster;
    }
}

