/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.rasterimage;

import com.vividsolutions.jump.workbench.Logger;
import com.vividsolutions.jump.workbench.imagery.ReferencedImageException;
import com.vividsolutions.jump.workbench.imagery.geoimg.GeoReferencedRaster;
import it.geosolutions.imageioimpl.plugins.tiff.TIFFImageReaderSpi;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.awt.image.renderable.ParameterBlock;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.WeakHashMap;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.media.jai.JAI;
import javax.media.jai.RenderedOp;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.commons.imaging.formats.tiff.TiffField;
import org.apache.commons.imaging.formats.tiff.TiffImageMetadata;
import org.apache.commons.imaging.formats.tiff.TiffImageParser;
import org.apache.commons.imaging.formats.tiff.fieldtypes.FieldTypeAscii;
import org.apache.commons.imaging.formats.tiff.fieldtypes.FieldTypeByte;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.openjump.core.rasterimage.GDALInternalMetadata;
import org.openjump.core.rasterimage.GDALPamDataset;
import org.openjump.core.rasterimage.ImageAndMetadata;
import org.openjump.core.rasterimage.Metadata;
import org.openjump.core.rasterimage.Overviews;
import org.openjump.core.rasterimage.RasterImageIO;
import org.openjump.core.rasterimage.Resolution;
import org.openjump.core.rasterimage.Stats;
import org.openjump.core.rasterimage.TiffTags;
import org.xml.sax.SAXException;

public class TiffUtilsV2 {
    private static WeakHashMap<File, GeoReferencedRaster> geoRasterCache = new WeakHashMap();

    public static void removeFromGeoRastercache(File file) {
        geoRasterCache.remove(file);
    }

    public static RenderedOp getRenderedOp(File tiffFile) throws IOException {
        RenderedOp rop;
        GeoReferencedRaster geoRaster = TiffUtilsV2.getGeoReferencedRaster(tiffFile);
        try {
            rop = geoRaster.getRenderedOp();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        return rop;
    }

    public static Envelope getEnvelope(File tiffFile) throws IOException {
        GeoReferencedRaster geoRaster = TiffUtilsV2.getGeoReferencedRaster(tiffFile);
        return geoRaster.getOriginalEnvelope();
    }

    private static GeoReferencedRaster getGeoReferencedRaster(File tiffFile) throws IOException {
        GeoReferencedRaster geoRaster;
        if (geoRasterCache.containsKey(tiffFile)) {
            return geoRasterCache.get(tiffFile);
        }
        try {
            geoRaster = new GeoReferencedRaster(tiffFile.toString(), new TIFFImageReaderSpi());
        }
        catch (ReferencedImageException e) {
            throw new IOException(e);
        }
        geoRasterCache.put(tiffFile, geoRaster);
        return geoRaster;
    }

    public static RenderedOp readSubsampled(File tiffFile, float xScale, float yScale) throws IOException {
        RenderedOp renderedOp = TiffUtilsV2.getRenderedOp(tiffFile);
        ParameterBlock parameterBlock = new ParameterBlock();
        parameterBlock.addSource(renderedOp);
        parameterBlock.add(xScale);
        parameterBlock.add(yScale);
        return JAI.create((String)"scale", (ParameterBlock)parameterBlock);
    }

    public static ImageAndMetadata readImage(File tiffFile, Envelope viewportEnvelope, Resolution requestedRes, Overviews overviews, Stats stats) throws NoninvertibleTransformException, IOException, FileNotFoundException, TiffTags.TiffReadingException, Exception {
        TiffTags.TiffMetadata tiffMetadata = TiffTags.readMetadata(tiffFile);
        int originalImageWidth = tiffMetadata.getColsCount();
        int originalImageHeight = tiffMetadata.getRowsCount();
        Resolution cellSize = tiffMetadata.getResolution();
        Double noData = tiffMetadata.getNoData();
        Envelope wholeImageEnvelope = TiffUtilsV2.getEnvelope(tiffFile);
        if (requestedRes == null) {
            requestedRes = cellSize;
        }
        int overviewLevel = overviews.pickOverviewLevel(requestedRes);
        if (stats == null) {
            stats = TiffUtilsV2.calculateStats(tiffFile, noData, tiffFile);
        }
        if (overviews.getOverviewsCount() == 1) {
            int actualImageHeight;
            int actualImageWidth;
            Envelope imagePartEnvelope;
            BufferedImage bufferedImage;
            float xScale = (float)(cellSize.getX() / requestedRes.getX());
            float yScale = (float)(cellSize.getY() / requestedRes.getY());
            xScale = Math.min(xScale, 1.0f);
            yScale = Math.min(yScale, 1.0f);
            RenderedOp renderedOp = TiffUtilsV2.readSubsampled(tiffFile, xScale, yScale);
            Resolution subsetResolution = new Resolution(wholeImageEnvelope.getWidth() / (double)renderedOp.getWidth(), wholeImageEnvelope.getHeight() / (double)renderedOp.getHeight());
            Rectangle imageSubset = RasterImageIO.getDrawingRectangle(renderedOp.getWidth(), renderedOp.getHeight(), wholeImageEnvelope, viewportEnvelope, subsetResolution);
            if (imageSubset == null) {
                bufferedImage = null;
                imagePartEnvelope = null;
                actualImageWidth = 0;
                actualImageHeight = 0;
            } else {
                bufferedImage = renderedOp.getAsBufferedImage(imageSubset, null);
                imagePartEnvelope = TiffUtilsV2.getImageSubsetEnvelope(wholeImageEnvelope, imageSubset, subsetResolution);
                actualImageWidth = bufferedImage.getWidth();
                actualImageHeight = bufferedImage.getHeight();
            }
            Metadata metadata = new Metadata(wholeImageEnvelope, imagePartEnvelope, new Point(originalImageWidth, originalImageHeight), new Point(actualImageWidth, actualImageHeight), (cellSize.getX() + cellSize.getY()) / 2.0, (subsetResolution.getX() + subsetResolution.getY()) / 2.0, noData, stats);
            return new ImageAndMetadata(bufferedImage, metadata);
        }
        ImageAndMetadata imageAndMetadata = TiffUtilsV2.readImage(tiffFile, overviewLevel, 0, new Point(originalImageWidth, originalImageHeight), cellSize, wholeImageEnvelope, viewportEnvelope, noData, stats);
        if (imageAndMetadata == null) {
            File ovrFile = new File(tiffFile.getParent(), tiffFile.getName() + ".ovr");
            imageAndMetadata = TiffUtilsV2.readImage(ovrFile, overviewLevel, overviews.getInternalOverviewsCount(), new Point(originalImageWidth, originalImageHeight), cellSize, wholeImageEnvelope, viewportEnvelope, noData, stats);
        }
        return imageAndMetadata;
    }

    public static ImageAndMetadata readImageAndMetadata(File tiffFile, Envelope viewportEnvelope, Resolution requestedRes, Stats stats) throws NoninvertibleTransformException, IOException, FileNotFoundException, Exception {
        int actualImageHeight;
        int actualImageWidth;
        Envelope imagePartEnvelope;
        BufferedImage bufferedImage;
        RenderedOp renderedOp1 = TiffUtilsV2.getRenderedOp(tiffFile);
        Envelope wholeImageEnvelope = TiffUtilsV2.getEnvelope(tiffFile);
        TiffImageParser parser = new TiffImageParser();
        TiffImageMetadata tmetadata = (TiffImageMetadata)parser.getMetadata(tiffFile);
        List tiffFields = tmetadata.getAllFields();
        Double noData = Double.NaN;
        for (TiffField tiffField : tiffFields) {
            if (tiffField.getTag() != 42113) continue;
            try {
                String noDataString = "";
                if (tiffField.getFieldType() instanceof FieldTypeAscii) {
                    noDataString = tiffField.getStringValue();
                    if (noDataString.equalsIgnoreCase("NaN")) {
                        noDataString = "NaN";
                    }
                } else if (tiffField.getFieldType() instanceof FieldTypeByte) {
                    noDataString = new String(tiffField.getByteArrayValue());
                }
                noData = Double.parseDouble(noDataString);
            }
            catch (NumberFormatException e) {
                Logger.error("Failed to read no data. Using standard -99999.0D", e);
                noData = -99999.0;
            }
        }
        double cellSizeX = wholeImageEnvelope.getWidth() / (double)renderedOp1.getWidth();
        double cellSizeY = wholeImageEnvelope.getHeight() / (double)renderedOp1.getHeight();
        if (requestedRes == null) {
            requestedRes = new Resolution(cellSizeX, cellSizeY);
        }
        if (stats == null) {
            stats = TiffUtilsV2.calculateStats(tiffFile, noData, tiffFile);
        }
        float xScale = (float)(cellSizeX / requestedRes.getX());
        float yScale = (float)(cellSizeY / requestedRes.getY());
        xScale = Math.min(xScale, 1.0f);
        yScale = Math.min(yScale, 1.0f);
        RenderedOp renderedOp = TiffUtilsV2.readSubsampled(tiffFile, xScale, yScale);
        Resolution subsetResolution = new Resolution(wholeImageEnvelope.getWidth() / (double)renderedOp.getWidth(), wholeImageEnvelope.getHeight() / (double)renderedOp.getHeight());
        Rectangle imageSubset = RasterImageIO.getDrawingRectangle(renderedOp.getWidth(), renderedOp.getHeight(), wholeImageEnvelope, viewportEnvelope, subsetResolution);
        if (imageSubset == null) {
            bufferedImage = null;
            imagePartEnvelope = null;
            actualImageWidth = 0;
            actualImageHeight = 0;
        } else {
            bufferedImage = renderedOp.getAsBufferedImage(imageSubset, null);
            imagePartEnvelope = TiffUtilsV2.getImageSubsetEnvelope(wholeImageEnvelope, imageSubset, subsetResolution);
            actualImageWidth = bufferedImage.getWidth();
            actualImageHeight = bufferedImage.getHeight();
        }
        Metadata metadata = new Metadata(wholeImageEnvelope, imagePartEnvelope, new Point(renderedOp1.getWidth(), renderedOp1.getHeight()), new Point(actualImageWidth, actualImageHeight), (cellSizeX + cellSizeY) / 2.0, (subsetResolution.getX() + subsetResolution.getY()) / 2.0, noData, stats);
        return new ImageAndMetadata(bufferedImage, metadata);
    }

    private static ImageAndMetadata readImage(File tiffFile, int overviewIndex, int indexStart, Point originalSize, Resolution originalCellSize, Envelope wholeImageEnvelope, Envelope viewportEnvelope, double noDataValue, Stats stats) throws IOException, NoninvertibleTransformException {
        ImageInputStream imageInputStream = ImageIO.createImageInputStream(tiffFile);
        Iterator<ImageReader> iterator = ImageIO.getImageReaders(imageInputStream);
        if (iterator != null && iterator.hasNext()) {
            ImageReader imageReader = iterator.next();
            imageReader.setInput(imageInputStream);
            for (int i = 0; i < imageReader.getNumImages(true); ++i) {
                int imageHeight;
                int imageWidth;
                Envelope imagePartEnvelope;
                BufferedImage bufferedImage;
                if (i + indexStart != overviewIndex) continue;
                Resolution subsetResolution = new Resolution(wholeImageEnvelope.getWidth() / (double)imageReader.getWidth(i), wholeImageEnvelope.getHeight() / (double)imageReader.getHeight(i));
                Rectangle imageSubset = RasterImageIO.getDrawingRectangle(imageReader.getWidth(i), imageReader.getHeight(i), wholeImageEnvelope, viewportEnvelope, subsetResolution);
                if (imageSubset == null) {
                    bufferedImage = null;
                    imagePartEnvelope = null;
                    imageWidth = 0;
                    imageHeight = 0;
                } else {
                    ImageReadParam imageReadParam = new ImageReadParam();
                    imageReadParam.setSourceRegion(imageSubset);
                    bufferedImage = imageReader.read(i, imageReadParam);
                    imagePartEnvelope = TiffUtilsV2.getImageSubsetEnvelope(wholeImageEnvelope, imageSubset, subsetResolution);
                    imageWidth = bufferedImage.getWidth();
                    imageHeight = bufferedImage.getHeight();
                }
                Metadata metadata = new Metadata(wholeImageEnvelope, imagePartEnvelope, originalSize, new Point(imageWidth, imageHeight), (originalCellSize.getX() + originalCellSize.getY()) / 2.0, (subsetResolution.getX() + subsetResolution.getY()) / 2.0, noDataValue, stats);
                if (imageReader != null) {
                    imageReader.dispose();
                }
                if (imageInputStream != null) {
                    imageInputStream.close();
                }
                return new ImageAndMetadata(bufferedImage, metadata);
            }
        }
        return null;
    }

    private static Stats calculateStats(File tiffFile, double noDataValue, File imageFile) throws ParserConfigurationException, TransformerException, IOException, SAXException {
        Stats stats = null;
        try {
            TiffImageParser parser = new TiffImageParser();
            TiffImageMetadata metadata = (TiffImageMetadata)parser.getMetadata(tiffFile);
            List tiffFields = metadata.getAllFields();
            for (TiffField tiffField : tiffFields) {
                if (tiffField.getTag() != 42112) continue;
                GDALInternalMetadata gdalParser = new GDALInternalMetadata();
                stats = gdalParser.readStatistics(tiffField.getStringValue());
                break;
            }
        }
        catch (Exception ex) {
            stats = null;
        }
        if (stats != null) {
            return stats;
        }
        File auxXmlFile = new File(imageFile.getParent(), imageFile.getName() + ".aux.xml");
        if (auxXmlFile.exists()) {
            GDALPamDataset gdalPamDataset = new GDALPamDataset();
            try {
                stats = gdalPamDataset.readStatistics(auxXmlFile);
                return stats;
            }
            catch (Exception ex) {
                Logger.error("Failed to read statistics.", ex);
                return TiffUtilsV2.createStatsXml(tiffFile, noDataValue, auxXmlFile);
            }
        }
        return TiffUtilsV2.createStatsXml(tiffFile, noDataValue, auxXmlFile);
    }

    private static Stats createStatsXml(File tiffFile, double noDataValue, File auxXmlFile) throws ParserConfigurationException, TransformerException, TransformerConfigurationException, SAXException, IOException {
        BufferedImage bufferedImage = TiffUtilsV2.readSubsampled(tiffFile, 1.0f, 1.0f).getAsBufferedImage();
        int bandCount = bufferedImage.getRaster().getNumBands();
        double[] minValue = new double[bandCount];
        double[] maxValue = new double[bandCount];
        double[] sum = new double[bandCount];
        double[] sumSquare = new double[bandCount];
        long[] cellsCount = new long[bandCount];
        for (int b = 0; b < bandCount; ++b) {
            minValue[b] = Double.MAX_VALUE;
            maxValue[b] = -1.7976931348623157E308;
        }
        for (int r = 0; r < bufferedImage.getHeight(); ++r) {
            Raster raster = bufferedImage.getData(new Rectangle(0, r, bufferedImage.getWidth(), 1));
            for (int c = 0; c < bufferedImage.getWidth(); ++c) {
                for (int b = 0; b < bandCount; ++b) {
                    double value = raster.getSampleDouble(c, r, b);
                    if (value == noDataValue || (float)value == (float)noDataValue || Double.isNaN(value) || Double.isInfinite(value)) continue;
                    if (value < minValue[b]) {
                        minValue[b] = value;
                    }
                    if (value > maxValue[b]) {
                        maxValue[b] = value;
                    }
                    int n = b;
                    cellsCount[n] = cellsCount[n] + 1L;
                    int n2 = b;
                    sum[n2] = sum[n2] + value;
                    int n3 = b;
                    sumSquare[n3] = sumSquare[n3] + value * value;
                }
            }
        }
        Stats stats = new Stats(bandCount);
        for (int b = 0; b < bandCount; ++b) {
            double meanValue = sum[b] / (double)cellsCount[b];
            double stdDevValue = Math.sqrt(sumSquare[b] / (double)cellsCount[b] - meanValue * meanValue);
            stats.setStatsForBand(b, minValue[b], maxValue[b], meanValue, stdDevValue);
        }
        GDALPamDataset gdalPamDataset = new GDALPamDataset();
        gdalPamDataset.writeStatistics(auxXmlFile, stats);
        return stats;
    }

    private static Envelope getImageSubsetEnvelope(Envelope wholeImageEnvelope, Rectangle imageSubset, Resolution subsetResolution) {
        double ulX = Math.max(wholeImageEnvelope.getMinX(), wholeImageEnvelope.getMinX() + imageSubset.getX() * subsetResolution.getX());
        double ulY = Math.min(wholeImageEnvelope.getMaxY(), wholeImageEnvelope.getMaxY() - imageSubset.getY() * subsetResolution.getY());
        double lrX = Math.min(wholeImageEnvelope.getMaxX(), wholeImageEnvelope.getMinX() + imageSubset.getX() * subsetResolution.getX() + imageSubset.getWidth() * subsetResolution.getX());
        double lrY = Math.max(wholeImageEnvelope.getMinY(), wholeImageEnvelope.getMaxY() - imageSubset.getY() * subsetResolution.getY() - imageSubset.getHeight() * subsetResolution.getY());
        Coordinate ulCoord = new Coordinate(ulX, ulY);
        Coordinate lrCoord = new Coordinate(lrX, lrY);
        Envelope imagePartEnvelope = new Envelope(ulCoord, lrCoord);
        return imagePartEnvelope;
    }

    public static Double readCellValue(File tiffFile, int col, int row, int band) throws Exception {
        Rectangle rectangle = new Rectangle(col, row, 1, 1);
        return TiffUtilsV2.getRenderedOp(tiffFile).getData(rectangle).getSampleDouble(col, row, band);
    }
}

