/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.rasterimage;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.imaging.formats.tiff.TiffField;
import org.apache.commons.imaging.formats.tiff.TiffImageMetadata;
import org.apache.commons.imaging.formats.tiff.TiffImageParser;
import org.apache.commons.imaging.formats.tiff.fieldtypes.FieldTypeAscii;
import org.apache.commons.imaging.formats.tiff.fieldtypes.FieldTypeByte;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.openjump.core.ccordsys.Unit;
import org.openjump.core.ccordsys.utils.SRSInfo;
import org.openjump.core.rasterimage.Resolution;

public class TiffTags {
    public static final int FIELDTYPE_SHORT = 3;
    public static final int FIELDTYPE_LONG = 4;
    public static final int TIFFTAG_GDAL_NODATA = 42113;
    public static final int TIFFTAG_GDAL_METADATA = 42112;

    public static TiffMetadata readMetadata(File tiffFile) throws IOException, TiffReadingException {
        Integer colCount = null;
        Integer rowCount = null;
        Double noData = -3.40282346639E38;
        Coordinate pixelOffset = null;
        Coordinate tiePoint = null;
        Resolution pixelScale = null;
        Envelope envelope = null;
        SRSInfo srsInfo = new SRSInfo().setSource(tiffFile.getPath());
        TiffImageParser parser = new TiffImageParser();
        TiffImageMetadata metadata = (TiffImageMetadata)parser.getMetadata(tiffFile);
        List tiffFields = metadata.getAllFields();
        int[] geoKeyDirectoryTag = null;
        double[] geoDoubleParams = null;
        String geoAsciiParams = null;
        for (TiffField tiffField : tiffFields) {
            switch (tiffField.getTag()) {
                case 256: {
                    colCount = tiffField.getIntValue();
                    break;
                }
                case 257: {
                    rowCount = tiffField.getIntValue();
                    break;
                }
                case 42113: {
                    String noDataString = "";
                    if (tiffField.getFieldType() instanceof FieldTypeAscii) {
                        noDataString = tiffField.getStringValue();
                        if (noDataString.equalsIgnoreCase("NaN")) {
                            noDataString = "NaN";
                        }
                    } else if (tiffField.getFieldType() instanceof FieldTypeByte) {
                        noDataString = new String(tiffField.getByteArrayValue());
                    }
                    noData = Double.parseDouble(noDataString);
                    break;
                }
                case 33922: {
                    double[] tiePointValues = tiffField.getDoubleArrayValue();
                    pixelOffset = new Coordinate(tiePointValues[0], tiePointValues[1], tiePointValues[2]);
                    tiePoint = new Coordinate(tiePointValues[3], tiePointValues[4], tiePointValues[5]);
                    break;
                }
                case 33550: {
                    double[] pixelSCaleValues = tiffField.getDoubleArrayValue();
                    if (pixelSCaleValues.length == 2 || pixelSCaleValues[2] == 0.0) {
                        pixelScale = new Resolution(pixelSCaleValues[0], pixelSCaleValues[1]);
                        break;
                    }
                    pixelScale = new Resolution(pixelSCaleValues[0], pixelSCaleValues[1], pixelSCaleValues[2]);
                    break;
                }
                case 34735: {
                    geoKeyDirectoryTag = tiffField.getIntArrayValue();
                    break;
                }
                case 34736: {
                    geoDoubleParams = tiffField.getDoubleArrayValue();
                    break;
                }
                case 34737: {
                    geoAsciiParams = tiffField.getStringValue();
                    geoAsciiParams = geoAsciiParams.replaceAll("[\\s\\|_;]+", " ").trim();
                    srsInfo.setDescription(geoAsciiParams);
                }
            }
        }
        if (tiePoint != null && pixelScale != null) {
            Coordinate upperLeft = pixelOffset == null ? tiePoint : new Coordinate(tiePoint.x - pixelOffset.x * pixelScale.getX(), tiePoint.y - pixelOffset.y * pixelScale.getY());
            Coordinate lowerRight = new Coordinate(upperLeft.x + (double)colCount.intValue() * pixelScale.getX(), upperLeft.y - (double)rowCount.intValue() * pixelScale.getY());
            envelope = new Envelope(upperLeft, lowerRight);
        }
        if (geoKeyDirectoryTag != null && geoKeyDirectoryTag.length >= 4) {
            TiffTags.readGeoKeys(geoKeyDirectoryTag, geoDoubleParams, geoAsciiParams, srsInfo);
            srsInfo.complete();
        } else {
            srsInfo = null;
        }
        return new TiffTags().new TiffMetadata(colCount, rowCount, pixelScale, noData, envelope, srsInfo);
    }

    private static void readGeoKeys(int[] geoKeys, double[] geoDoubleParams, String geoAsciiParams, SRSInfo srsInfo) {
        int numberOfKeys = geoKeys[3];
        block9: for (int i = 1; i <= numberOfKeys; ++i) {
            int keyID = geoKeys[i * 4];
            int location = geoKeys[i * 4 + 1];
            int count = geoKeys[i * 4 + 2];
            int offset = geoKeys[i * 4 + 3];
            switch (keyID) {
                case 1024: {
                    int coordSystemType = offset;
                    if (coordSystemType == 2) {
                        srsInfo.setUnit(Unit.DEGREE);
                        continue block9;
                    }
                    if (coordSystemType != 1) continue block9;
                    srsInfo.setUnit(Unit.METRE);
                    continue block9;
                }
                case 1026: {
                    continue block9;
                }
                case 2048: 
                case 3072: {
                    Object value = TiffTags.getGeoValue(location, count, offset, geoDoubleParams, geoAsciiParams);
                    if (value instanceof String) {
                        srsInfo.setDescription((String)value);
                        continue block9;
                    }
                    if (!(value instanceof Integer)) continue block9;
                    if ((Integer)value < Short.MAX_VALUE) {
                        srsInfo.setRegistry(SRSInfo.Registry.EPSG).setCode(value.toString());
                        continue block9;
                    }
                    if ((Integer)value != Short.MAX_VALUE) continue block9;
                    srsInfo.setRegistry(SRSInfo.Registry.SRID).setCode("USER-DEFINED");
                    continue block9;
                }
                case 2049: {
                    continue block9;
                }
                case 3073: {
                    continue block9;
                }
                case 4096: {
                    continue block9;
                }
                case 2052: 
                case 2054: 
                case 3076: {
                    srsInfo.setUnit(Unit.find(Integer.toString(offset)));
                }
            }
        }
    }

    private static Object getGeoValue(int location, int count, int offset, double[] geoDoubleParams, String geoAsciiParams) {
        if (location == 0) {
            return offset;
        }
        if (location == 34736) {
            if (count == 0) {
                return new double[0];
            }
            double[] dd = new double[count];
            System.arraycopy(geoDoubleParams, offset, dd, 0, count);
            return dd;
        }
        if (location == 34737) {
            if (geoAsciiParams == null || geoAsciiParams.length() == 0) {
                return "";
            }
            String substring = geoAsciiParams.substring(offset, offset + count);
            return substring.endsWith("|") ? substring.substring(0, substring.length() - 1) : substring;
        }
        return "";
    }

    static TiffField readField(File tiffFile, int tagCode) throws IOException {
        TiffImageParser parser = new TiffImageParser();
        TiffImageMetadata metadata = (TiffImageMetadata)parser.getMetadata(tiffFile);
        List tiffFields = metadata.getAllFields();
        for (TiffField tiffField : tiffFields) {
            if (tiffField.getTag() != tagCode) continue;
            return tiffField;
        }
        return null;
    }

    public static TiffField readField(File tiffFile, String tagName) throws IOException {
        TiffImageParser parser = new TiffImageParser();
        TiffImageMetadata metadata = (TiffImageMetadata)parser.getMetadata(tiffFile);
        List tiffFields = metadata.getAllFields();
        for (TiffField tiffField : tiffFields) {
            if (!tiffField.getTagName().equalsIgnoreCase(tagName)) continue;
            return tiffField;
        }
        return null;
    }

    public static List<TiffField> readAllFields(File tiffFile, int tagCode) throws IOException {
        TiffImageParser parser = new TiffImageParser();
        TiffImageMetadata metadata = (TiffImageMetadata)parser.getMetadata(tiffFile);
        List tiffFields = metadata.getAllFields();
        return tiffFields;
    }

    public class TiffReadingException
    extends Exception {
        public TiffReadingException() {
        }

        public TiffReadingException(String message) {
            super(message);
        }
    }

    public class TiffMetadata {
        private Integer colsCount;
        private Integer rowsCount;
        private Resolution resolution;
        private Double noData;
        private Envelope envelope;
        private SRSInfo srsInfo;

        public TiffMetadata(Integer colsCount, Integer rowsCount, Resolution resolution, Double noData, Envelope envelope, SRSInfo srsInfo) {
            this.colsCount = colsCount;
            this.rowsCount = rowsCount;
            this.resolution = resolution;
            this.noData = noData;
            this.envelope = envelope;
            this.srsInfo = srsInfo;
        }

        public Integer getColsCount() {
            return this.colsCount;
        }

        public Integer getRowsCount() {
            return this.rowsCount;
        }

        public Resolution getResolution() {
            return this.resolution;
        }

        public Double getNoData() {
            return this.noData;
        }

        public Envelope getEnvelope() {
            return this.envelope;
        }

        public boolean isGeoTiff() {
            return this.srsInfo != null;
        }

        public SRSInfo getSRSInfo() {
            return this.srsInfo;
        }
    }
}

