/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.rasterimage;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.openjump.core.rasterimage.Stats;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class GDALInternalMetadata
extends DefaultHandler {
    private String tmpValue;
    private final List<Double> minVals_l = new ArrayList<Double>();
    private final List<Double> maxVals_l = new ArrayList<Double>();
    private final List<Double> meanVals_l = new ArrayList<Double>();
    private final List<Double> stdDevVals_l = new ArrayList<Double>();
    private int sampleNr;
    private static final String itemName = "name";
    private static final String itemSample = "sample";
    private static String item;
    private static final String STATISTICS_MAXIMUM = "STATISTICS_MAXIMUM";
    private static final String STATISTICS_MINIMUM = "STATISTICS_MINIMUM";
    private static final String STATISTICS_MEAN = "STATISTICS_MEAN";
    private static final String STATISTICS_STDDEV = "STATISTICS_STDDEV";

    public Stats readStatistics(String statsTag) throws ParserConfigurationException, SAXException, IOException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        SAXParser parser = factory.newSAXParser();
        parser.parse((InputStream)new ByteArrayInputStream(statsTag.getBytes(StandardCharsets.UTF_8)), (DefaultHandler)this);
        ++this.sampleNr;
        Stats stats = new Stats(this.sampleNr);
        for (int b = 0; b < this.sampleNr; ++b) {
            stats.setStatsForBand(b, this.minVals_l.get(b), this.maxVals_l.get(b), this.meanVals_l.get(b), this.stdDevVals_l.get(b));
        }
        return stats;
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        super.endElement(uri, localName, qName);
        if (item == null) {
            return;
        }
        if (item.equals(STATISTICS_MINIMUM)) {
            Double value = Double.parseDouble(this.tmpValue);
            this.minVals_l.add(value);
        } else if (item.equals(STATISTICS_MAXIMUM)) {
            Double value = Double.parseDouble(this.tmpValue);
            this.maxVals_l.add(value);
        } else if (item.equals(STATISTICS_MEAN)) {
            Double value = Double.parseDouble(this.tmpValue);
            this.meanVals_l.add(value);
        } else if (item.equals(STATISTICS_STDDEV)) {
            Double value = Double.parseDouble(this.tmpValue);
            this.stdDevVals_l.add(value);
        }
        item = null;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        super.startElement(uri, localName, qName, attributes);
        if (localName.equalsIgnoreCase("Item")) {
            for (int a = 0; a < attributes.getLength(); ++a) {
                if (attributes.getQName(a).equalsIgnoreCase(itemSample)) {
                    int newSampleNr = Integer.parseInt(attributes.getValue(a));
                    if (newSampleNr <= this.sampleNr) continue;
                    this.sampleNr = newSampleNr;
                    continue;
                }
                if (!attributes.getQName(a).equalsIgnoreCase(itemName)) continue;
                item = attributes.getValue(a);
            }
        }
    }

    @Override
    public void characters(char[] ac, int i, int j) throws SAXException {
        this.tmpValue = new String(ac, i, j);
    }
}

