/*
 * Decompiled with CFR 0.152.
 */
package org.libtiff.jai.codecimpl;

import com.sun.media.jai.codec.ImageCodec;
import com.sun.media.jai.codec.ImageDecodeParam;
import com.sun.media.jai.codec.ImageDecoder;
import com.sun.media.jai.codec.ImageEncodeParam;
import com.sun.media.jai.codec.ImageEncoder;
import com.sun.media.jai.codec.SeekableStream;
import com.sun.media.jai.codec.TIFFDecodeParam;
import com.sun.media.jai.codec.TIFFEncodeParam;
import java.awt.image.RenderedImage;
import java.io.OutputStream;
import org.libtiff.jai.codecimpl.XTIFFFaxTileCodec;
import org.libtiff.jai.codecimpl.XTIFFImageDecoder;
import org.libtiff.jai.codecimpl.XTIFFImageEncoder;
import org.libtiff.jai.codecimpl.XTIFFLZWTileCodec;
import org.libtiff.jai.codecimpl.XTIFFPackTileCodec;
import org.libtiff.jai.codecimpl.XTIFFUncompTileCodec;

public class XTIFFCodec
extends ImageCodec {
    public String getFormatName() {
        return "xtiff";
    }

    public Class getEncodeParamClass() {
        return TIFFEncodeParam.class;
    }

    public Class getDecodeParamClass() {
        return TIFFDecodeParam.class;
    }

    public boolean canEncodeImage(RenderedImage im, ImageEncodeParam param) {
        return true;
    }

    protected ImageEncoder createImageEncoder(OutputStream dst, ImageEncodeParam param) {
        return new XTIFFImageEncoder(dst, param);
    }

    protected ImageDecoder createImageDecoder(SeekableStream src, ImageDecodeParam param) {
        return new XTIFFImageDecoder(src, param);
    }

    public int getNumHeaderBytes() {
        return 4;
    }

    public boolean isFormatRecognized(byte[] header) {
        if (header[0] == 73 && header[1] == 73 && header[2] == 42 && header[3] == 0) {
            return true;
        }
        return header[0] == 77 && header[1] == 77 && header[2] == 0 && header[3] == 42;
    }

    static {
        new XTIFFUncompTileCodec().register();
        new XTIFFLZWTileCodec().register();
        new XTIFFPackTileCodec().register();
        new XTIFFFaxTileCodec().register();
    }
}

