/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.dbffile;

import com.vividsolutions.jump.io.EndianDataInputStream;
import com.vividsolutions.jump.workbench.Logger;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.geotools.dbffile.DbfConsts;
import org.geotools.dbffile.DbfFieldDef;

public class DbfFile
implements DbfConsts,
AutoCloseable {
    private int dbf_id;
    private int last_update_d;
    private int last_update_m;
    private int last_update_y;
    private int last_rec;
    private int rec_size;
    private EndianDataInputStream dFile;
    private RandomAccessFile rFile;
    private long data_offset;
    private long filesize;
    private int numfields;
    private Map<String, String> uniqueStrings;
    public DbfFieldDef[] fielddef;
    public static final SimpleDateFormat DATE_PARSER = new SimpleDateFormat("yyyyMMdd"){
        {
            this.setLenient(true);
        }
    };
    private Charset charset = Charset.defaultCharset();
    private DateFormat lastFormat = DATE_PARSER;

    protected DbfFile() {
    }

    public DbfFile(String file) throws Exception {
        this(file, Charset.defaultCharset());
    }

    public DbfFile(String file, Charset charset) throws IOException {
        this.charset = charset;
        Logger.debug("DbfFile constructor");
        InputStream in = Files.newInputStream(Paths.get(file, new String[0]), new OpenOption[0]);
        EndianDataInputStream sfile = new EndianDataInputStream(in);
        this.init(sfile);
        this.rFile = new RandomAccessFile(new File(file), "r");
    }

    public String getLastUpdate() {
        return this.last_update_d + "/" + this.last_update_m + "/" + this.last_update_y;
    }

    public int getLastRec() {
        return this.last_rec;
    }

    public int getRecSize() {
        return this.rec_size;
    }

    public int getNumFields() {
        return this.numfields;
    }

    public String getFieldName(int col) {
        return this.fielddef[col].fieldname.toString();
    }

    public String getFieldType(int col) {
        String realtype;
        char type = this.fielddef[col].fieldtype;
        switch (type) {
            case 'C': {
                realtype = "STRING";
                break;
            }
            case 'N': {
                if (this.fielddef[col].fieldnumdec == 0) {
                    if (this.fielddef[col].fieldlen > 9) {
                        realtype = "LONG";
                        break;
                    }
                    realtype = "INTEGER";
                    break;
                }
                realtype = "DOUBLE";
                break;
            }
            case 'F': {
                realtype = "DOUBLE";
                break;
            }
            case 'D': {
                realtype = "DATE";
                break;
            }
            case 'L': {
                realtype = "BOOLEAN";
                break;
            }
            default: {
                realtype = "STRING";
            }
        }
        return realtype;
    }

    public long getFileSize() {
        return this.filesize;
    }

    private void init(EndianDataInputStream sfile) throws IOException {
        new DbfFileHeader(sfile);
        this.uniqueStrings = new HashMap<String, String>();
        this.dFile = sfile;
        this.fielddef = new DbfFieldDef[this.numfields];
        int widthsofar = 1;
        for (int index = 0; index < this.numfields; ++index) {
            this.fielddef[index] = new DbfFieldDef();
            this.fielddef[index].setup(widthsofar, this.dFile, this.charset);
            widthsofar += this.fielddef[index].fieldlen;
        }
        sfile.skipBytes(1);
        Logger.debug("Dbf file initialized");
    }

    public StringBuffer GetNextDbfRec() throws IOException {
        StringBuffer record = new StringBuffer(this.rec_size + this.numfields);
        for (int i = 0; i < this.rec_size; ++i) {
            record.append((char)this.rFile.readUnsignedByte());
        }
        return record;
    }

    public byte[] GetDbfRec(long row) throws IOException {
        this.rFile.seek(this.data_offset + (long)this.rec_size * row);
        byte[] strbuf = new byte[this.rec_size];
        this.dFile.readByteLEnum(strbuf);
        return strbuf;
    }

    public Object ParseRecordColumn(byte[] rec, int wantedCol) throws Exception {
        int start = this.fielddef[wantedCol].fieldstart;
        int len = this.fielddef[wantedCol].fieldlen;
        switch (this.fielddef[wantedCol].fieldtype) {
            case 'C': {
                int end;
                for (end = start + len; start < end && (rec[end - 1] == 32 || rec[end - 1] == 0); --end) {
                }
                String s = new String(rec, start, end - start, this.charset.name());
                String masterString = this.uniqueStrings.get(s);
                if (masterString != null) {
                    return masterString;
                }
                this.uniqueStrings.put(s, s);
                return s;
            }
            case 'F': 
            case 'N': {
                boolean isInteger = this.fielddef[wantedCol].fieldnumdec == 0 && this.fielddef[wantedCol].fieldtype == 'N';
                boolean isLong = isInteger && this.fielddef[wantedCol].fieldlen > 9;
                String numb = new String(rec, start, len).trim();
                if (isLong) {
                    try {
                        return numb.length() == 0 ? null : Long.valueOf(Long.parseLong(numb));
                    }
                    catch (NumberFormatException e) {
                        return null;
                    }
                }
                if (isInteger) {
                    try {
                        return numb.length() == 0 ? null : Integer.valueOf(Integer.parseInt(numb));
                    }
                    catch (NumberFormatException e) {
                        return null;
                    }
                }
                try {
                    return numb.length() == 0 ? null : Double.valueOf(Double.parseDouble(numb));
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
            case 'L': {
                String bool = new String(rec, start, len).trim().toLowerCase();
                if (bool.equals("?") || bool.trim().equals("")) {
                    return null;
                }
                if (bool.equals("t") || bool.equals("y") || bool.equals("1")) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            case 'D': {
                return this.parseDate(new String(rec, start, len));
            }
        }
        String s = new String(rec, start, len);
        String masterString = this.uniqueStrings.get(s);
        if (masterString != null) {
            return masterString;
        }
        this.uniqueStrings.put(s, s);
        return s;
    }

    @Override
    public void close() throws IOException {
        this.dFile.close();
        this.rFile.close();
    }

    protected Date parseDate(String s) throws ParseException {
        Date date = null;
        if (s.trim().length() != 0 && !s.equals("00000000")) {
            try {
                date = this.lastFormat.parse(s);
            }
            catch (ParseException e) {
                String[] patterns = new String[]{"yyyyMMdd", "yy/mm/dd"};
                for (int i = 0; i < patterns.length; ++i) {
                    SimpleDateFormat df = new SimpleDateFormat(patterns[i]);
                    df.setLenient(true);
                    try {
                        date = df.parse(s);
                        this.lastFormat = df;
                        break;
                    }
                    catch (ParseException pe) {
                        date = null;
                        continue;
                    }
                }
            }
        }
        return date;
    }

    public static void main(String[] args) throws Exception {
        System.out.println(new SimpleDateFormat("yyyyMMdd"){
            {
                this.setLenient(false);
            }
        }.parse("00010101"));
    }

    class DbfFileHeader {
        public DbfFileHeader(EndianDataInputStream file) throws IOException {
            this.getDbfFileHeader(file);
        }

        private void getDbfFileHeader(EndianDataInputStream file) throws IOException {
            DbfFile.this.dbf_id = file.readUnsignedByteLE();
            Logger.debug("Dbf header id: " + DbfFile.this.dbf_id);
            DbfFile.this.last_update_y = file.readUnsignedByteLE() + 1900;
            DbfFile.this.last_update_m = file.readUnsignedByteLE();
            DbfFile.this.last_update_d = file.readUnsignedByteLE();
            Logger.debug(String.format("Dbf last update: %s/%s/%s", DbfFile.this.last_update_d, DbfFile.this.last_update_m, DbfFile.this.last_update_y));
            DbfFile.this.last_rec = file.readIntLE();
            Logger.debug("Dbf las record: " + DbfFile.this.last_rec);
            DbfFile.this.data_offset = (char)file.readShortLE();
            Logger.debug("Dbf data offset: " + DbfFile.this.data_offset);
            DbfFile.this.rec_size = (char)file.readShortLE();
            Logger.debug("Dbf rec size: " + DbfFile.this.rec_size);
            DbfFile.this.filesize = (long)(DbfFile.this.rec_size * DbfFile.this.last_rec) + DbfFile.this.data_offset + 1L;
            Logger.debug("Dbf file size :" + DbfFile.this.filesize);
            DbfFile.this.numfields = (int)((DbfFile.this.data_offset - 32L - 1L) / 32L);
            Logger.debug("Dbf number of fields :" + DbfFile.this.numfields);
            file.skipBytes(20);
        }
    }
}

