/*
 * Decompiled with CFR 0.152.
 */
package de.soldin.jumpcore.geomconv;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.workbench.Logger;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.FeatureSelection;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.OKCancelDialog;
import com.vividsolutions.jump.workbench.ui.SelectionManagerProxy;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import com.vividsolutions.jump.workbench.ui.plugin.FeatureInstaller;
import de.soldin.jumpcore.UndoableSetGeometry;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;
import org.locationtech.jts.algorithm.Orientation;
import org.locationtech.jts.algorithm.PointLocation;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateList;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryComponentFilter;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.util.GeometryEditor;
import org.locationtech.jts.geom.util.LinearComponentExtracter;

public class GCPlugin
extends AbstractPlugIn {
    private static final I18N I18N = com.vividsolutions.jump.I18N.getInstance(new File("language/geomconv/gc"));
    private static GeometryFactory factory = new GeometryFactory();
    private static Map<String, Method> geoms = null;
    private static List<String> items = new ArrayList<String>();
    private String target = null;
    private boolean youvebeenwarned = false;

    public GCPlugin() {
    }

    protected GCPlugin(String target) {
        this.target = target;
    }

    @Override
    public void initialize(PlugInContext context) throws Exception {
        super.initialize(context);
        if (this.target != null) {
            return;
        }
        FeatureInstaller f = context.getFeatureInstaller();
        String[] menuchain = new String[]{MenuNames.TOOLS, MenuNames.TOOLS_EDIT_GEOMETRY, this.getName()};
        this.addToMainMenu(context, menuchain);
        JMenuItem mainMenuItem = FeatureInstaller.childMenuItem(this.getName(), FeatureInstaller.wrapMenu(f.menuBar()), Arrays.copyOf(menuchain, menuchain.length - 1));
        if (mainMenuItem != null) {
            mainMenuItem.setIcon(this.getIcon());
        }
        JPopupMenu popupMenu = LayerViewPanel.popupMenu();
        String[] popupchain = new String[]{this.getName()};
        this.addToPopupMenu(context, popupMenu, popupchain);
        JMenuItem popupItem = FeatureInstaller.childMenuItem(this.getName(), FeatureInstaller.wrapMenu(popupMenu));
        if (popupItem != null) {
            popupItem.setIcon(this.getIcon());
        }
    }

    public void addToPopupMenu(PlugInContext context, JPopupMenu popupMenu, String[] popupchain) throws Exception {
        EnableCheck checker = this.createEnableCheck();
        for (String menuentry : items) {
            GCPlugin plugin = new GCPlugin(menuentry);
            plugin.initialize(context);
            if (menuentry.equals("separator")) {
                this.getSubMenu(popupMenu, popupchain).addSeparator();
                continue;
            }
            context.getFeatureInstaller().addPopupMenuPlugin(popupMenu, plugin, popupchain, this._m(menuentry.toLowerCase(), new Object[0]), false, null, checker);
        }
    }

    public void addToMainMenu(PlugInContext context, String[] menuchain) throws Exception {
        EnableCheck checker = this.createEnableCheck();
        for (String menuentry : items) {
            GCPlugin plugin = new GCPlugin(menuentry);
            plugin.initialize(context);
            if (menuentry.equals("separator")) {
                context.getFeatureInstaller().addMenuSeparator(menuchain);
                continue;
            }
            context.getFeatureInstaller().addMainMenuPlugin(plugin, menuchain, this._m(menuentry.toLowerCase(), new Object[0]), false, null, checker);
        }
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        Collection<Layer> layers;
        if (this.layerMode()) {
            String message;
            layers = this.getLayers();
            StringBuffer buf = new StringBuffer();
            for (Layer layer : layers) {
                String name = layer.getName();
                buf.append(buf.length() == 0 ? name : ", " + name);
            }
            String string = message = this.target.equalsIgnoreCase("close-lines") || this.target.equalsIgnoreCase("remove-closing-segment") ? "treat-all-with-tools" : "convert-all-to";
            if (!this.okCancel(this._m("are-you-sure", new Object[0]), this._m(message, buf, this._m(this.target.toLowerCase(), new Object[0])))) {
                return false;
            }
        }
        context.getLayerManager().getUndoableEditReceiver().reportNothingToUndoYet();
        layers = this.getLayers();
        UndoableSetGeometry action = new UndoableSetGeometry(this.getName());
        for (Layer layer : layers) {
            Collection<Feature> feats = this.getFeatures(layer);
            UndoableSetGeometry layeraction = new UndoableSetGeometry(layer, this.getName());
            for (Feature feat : feats) {
                try {
                    Geometry geom_orig;
                    Geometry geom_src = geom_orig = layeraction.getGeom(feat);
                    Geometry geom_new = null;
                    this.youvebeenwarned = false;
                    if (this.target.equalsIgnoreCase("close-lines") || this.target.equalsIgnoreCase("remove-closing-segment")) {
                        if (geom_src instanceof LinearRing || geom_src instanceof Polygon || geom_src instanceof MultiPolygon) {
                            geom_src = factory.createMultiLineString(this.getLines(geom_src));
                        }
                        int count = geom_src.getNumGeometries();
                        boolean changed = false;
                        Geometry[] geoms_new = new Geometry[count];
                        GeometryEditor editor = new GeometryEditor();
                        for (int j = 0; j < count; ++j) {
                            Geometry geom = geom_src.getGeometryN(j);
                            if (geom instanceof LinearRing) {
                                geom = factory.createLineString(geom.getCoordinates());
                            }
                            if (this.target.equalsIgnoreCase("close-lines")) {
                                geoms_new[j] = editor.edit(geom, (GeometryEditor.GeometryEditorOperation)new CloseRing());
                            } else if (this.target.equalsIgnoreCase("remove-closing-segment")) {
                                geoms_new[j] = editor.edit(geom, (GeometryEditor.GeometryEditorOperation)new RemoveClosing());
                            }
                            if (geoms_new[j].equalsExact(geom)) continue;
                            changed = true;
                        }
                        if (changed && count > 1) {
                            geom_new = factory.createGeometryCollection(geoms_new);
                            geom_new = this.convert(geom_new, geom_src.getGeometryType());
                        } else if (changed && count == 1) {
                            geom_new = geoms_new[0];
                        } else {
                            this.warnUser(this._m("nothing-to-do", feat.getID()));
                        }
                    } else {
                        geom_new = this.convert(geom_src, this.target);
                    }
                    if (geom_new == null || geom_new.equalsExact(geom_orig)) continue;
                    layeraction.setGeom(feat, geom_new);
                }
                catch (IllegalArgumentException e) {
                    this.warnUser(this._e(e.getMessage()));
                }
                catch (InvocationTargetException ie) {
                    if (ie.getCause() == null) continue;
                    this.warnUser(this._e(ie.getCause().getLocalizedMessage()));
                }
            }
            if (layeraction.isEmpty()) continue;
            action.add(layeraction);
        }
        if (!action.isEmpty()) {
            action.execute();
            this.getWorkbenchContext().getLayerManager().getUndoableEditReceiver().receive(action);
            return true;
        }
        if (!this.youvebeenwarned) {
            this.warnUser(this._m("nothing-changed", new Object[0]));
        }
        return false;
    }

    @Override
    public String getName() {
        return this._m("convert-selected-to", new Object[0]);
    }

    @Override
    public Icon getIcon() {
        if (this.target == null) {
            return IconLoader.icon("geometry_converter.png");
        }
        if (GCPlugin.getCreateGeometryMethods().containsKey(this.target)) {
            ImageIcon icon = IconLoader.icon("Edit" + this.target + ".gif");
            return GUIUtil.pad(icon, 3);
        }
        if (this.target.equals("close-lines")) {
            return IconLoader.icon("geometry_converter_closering.png");
        }
        if (this.target.equals("remove-closing-segment")) {
            return IconLoader.icon("geometry_converter_openring.png");
        }
        return null;
    }

    private JMenu getSubMenu(MenuElement menu, String[] keys) {
        MenuElement[] ms = menu.getSubElements();
        String key = keys[0];
        for (int i = 0; i < ms.length; ++i) {
            MenuElement m = ms[i];
            if (m == null || !(m instanceof JMenu) || !((JMenu)m).getText().equals(key)) continue;
            if (keys.length > 1) {
                String[] subkeys = new String[keys.length - 1];
                for (int j = 1; j < keys.length; ++j) {
                    subkeys[j] = keys[j];
                }
                m = this.getSubMenu(menu, subkeys);
                continue;
            }
            return (JMenu)m;
        }
        return null;
    }

    public EnableCheck createEnableCheck() {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance(this.getWorkbenchContext());
        MultiEnableCheck checker = new MultiEnableCheck();
        checker.add(checkFactory.createWindowWithLayerViewPanelMustBeActiveCheck());
        checker.add(new EnableCheck(){

            @Override
            public String check(JComponent component) {
                Collection layers = GCPlugin.this.getLayers();
                if (layers == null || layers.isEmpty()) {
                    return GCPlugin.this._m("select-geometries-or-layers", new Object[0]);
                }
                for (Layer layer : layers) {
                    if (layer.isEditable()) continue;
                    return GCPlugin.this._m("layer-not-editable", new Object[]{layer.getName()});
                }
                return null;
            }
        });
        return checker;
    }

    private boolean layerMode() {
        FeatureSelection sel = ((SelectionManagerProxy)((Object)this.getWorkbenchContext().getWorkbench().getFrame().getActiveInternalFrame())).getSelectionManager().getFeatureSelection();
        return sel.getFeaturesWithSelectedItems().isEmpty();
    }

    private Collection<Feature> getFeatures(Layer layer) {
        FeatureSelection sel = ((SelectionManagerProxy)((Object)this.getWorkbenchContext().getWorkbench().getFrame().getActiveInternalFrame())).getSelectionManager().getFeatureSelection();
        Collection<Feature> feats = !sel.getFeaturesWithSelectedItems().isEmpty() ? sel.getFeaturesWithSelectedItems(layer) : layer.getFeatureCollectionWrapper().getFeatures();
        return feats;
    }

    private Collection<Layer> getLayers() {
        Collection<Layer> layers = ((SelectionManagerProxy)((Object)this.getWorkbenchContext().getWorkbench().getFrame().getActiveInternalFrame())).getSelectionManager().getFeatureSelection().getLayersWithSelectedItems();
        return layers.isEmpty() ? Arrays.asList(this.getWorkbenchContext().getLayerableNamePanel().getSelectedLayers()) : layers;
    }

    private Collection<String> getTypes(GeometryCollection geom) {
        Vector<String> types = new Vector<String>();
        for (int i = 0; i < geom.getNumGeometries(); ++i) {
            String type = geom.getGeometryN(i).getGeometryType();
            if (types.contains(type)) continue;
            types.add(type);
        }
        return types;
    }

    private static Map<String, Method> getCreateGeometryMethods() {
        if (geoms != null) {
            return geoms;
        }
        geoms = new Hashtable<String, Method>();
        for (String key : items) {
            if (key.equals("separator")) break;
            Method m = null;
            m = key.equals("Point") ? GCPlugin.findMethod("create" + key, Coordinate.class) : (key.equals("Polygon") ? GCPlugin.findMethod("create" + key, LinearRing.class, LinearRing[].class) : (key.equals("MultiPoint") ? GCPlugin.findMethod("createMultiPointFromCoords", Coordinate[].class) : (key.equals("MultiLineString") ? GCPlugin.findMethod("create" + key, LineString[].class) : (key.equals("MultiPolygon") ? GCPlugin.findMethod("create" + key, Polygon[].class) : (key.equals("GeometryCollection") ? GCPlugin.findMethod("create" + key, Geometry[].class) : GCPlugin.findMethod("create" + key, Coordinate[].class))))));
            if (m == null) continue;
            geoms.put(key, m);
        }
        return geoms;
    }

    private static Method findMethod(String name, Class ... params) {
        try {
            return GeometryFactory.class.getDeclaredMethod(name, params);
        }
        catch (Exception e) {
            Logger.error(e);
            return null;
        }
    }

    private static boolean validType(Class clazz) {
        String name = clazz.isArray() ? clazz.getComponentType().getName() : clazz.getName();
        return name.equals("org.locationtech.jts.geom.Coordinate") || name.equals("org.locationtech.jts.geom.LinearRing") || name.equals("org.locationtech.jts.geom.LineString") || name.equals("org.locationtech.jts.geom.Polygon") || name.equals("org.locationtech.jts.geom.Geometry");
    }

    private void warnUser(String message) {
        this.youvebeenwarned = true;
        this.getWorkbenchContext().getLayerViewPanel().getContext().warnUser(message);
    }

    private Geometry convert(Geometry geom_src, String type) throws Exception {
        String name;
        Geometry geom_new = null;
        Method method = GCPlugin.getCreateGeometryMethods().get(type);
        if (method == null) {
            this.warnUser(this._m("no-conversion-method", this._m(type.toLowerCase(), new Object[0]), type));
            return null;
        }
        Class<?>[] cparams = method.getParameterTypes();
        if (geom_src.isEmpty()) {
            ArrayList params = new ArrayList();
            for (Class<?> clazz : cparams) {
                params.add(null);
            }
            geom_new = (Geometry)method.invoke((Object)factory, params.toArray());
            return geom_new;
        }
        boolean isArray = cparams[0].isArray();
        String string = name = isArray ? cparams[0].getComponentType().getName() : cparams[0].getName();
        if (!isArray && name.equals("org.locationtech.jts.geom.Coordinate")) {
            if (geom_src.getCoordinates().length > 1) {
                this.warnUser(this._m("only-one-coordinate", type));
            } else {
                Coordinate coord = geom_src.getCoordinates().length < 1 ? null : geom_src.getCoordinates()[0];
                geom_new = (Geometry)method.invoke((Object)factory, coord);
            }
        } else if (isArray && name.equals("org.locationtech.jts.geom.Coordinate")) {
            geom_new = (Geometry)method.invoke((Object)factory, new Object[]{geom_src.getCoordinates()});
        } else if (isArray && name.equals("org.locationtech.jts.geom.LineString")) {
            geom_new = (Geometry)method.invoke((Object)factory, new Object[]{this.getLines(geom_src)});
        } else if (cparams.length == 2 && name.equals("org.locationtech.jts.geom.LinearRing") && cparams[1].isArray() && name.equals(cparams[1].getComponentType().getName())) {
            geom_new = this.constructPolygon(geom_src);
        } else if (isArray && name.equals("org.locationtech.jts.geom.Polygon")) {
            Polygon[] polys = this.constructPolygons(geom_src);
            if (polys != null) {
                geom_new = (Geometry)method.invoke((Object)factory, new Object[]{polys});
            }
        } else if (isArray && name.equals("org.locationtech.jts.geom.Geometry")) {
            Geometry[] geoms = new Geometry[geom_src.getNumGeometries()];
            for (int j = 0; j < geom_src.getNumGeometries(); ++j) {
                geoms[j] = geom_src.getGeometryN(j);
            }
            geom_new = (Geometry)method.invoke((Object)factory, new Object[]{geoms});
        } else {
            this.warnUser(this._m("conversion-not-implemented", this._m(type.toLowerCase(), new Object[0]), type));
        }
        return geom_new;
    }

    private Polygon constructPolygon(Geometry src) {
        if (src instanceof GeometryCollection) {
            Collection<String> types = this.getTypes((GeometryCollection)src);
            if (types.size() == 1 && types.iterator().next().equalsIgnoreCase("point")) {
                src = factory.createLinearRing(src.getCoordinates());
            } else if (src.getNumGeometries() == 1 && src.getGeometryN(0) instanceof Polygon) {
                return (Polygon)src.getGeometryN(0);
            }
        } else {
            if (src instanceof Polygon) {
                return (Polygon)src;
            }
            if (src instanceof LineString) {
                return factory.createPolygon(factory.createLinearRing(src.getCoordinates()));
            }
        }
        ArrayList<Object> shells = new ArrayList<Object>();
        ArrayList<LinearRing> holes = new ArrayList<LinearRing>();
        try {
            for (int i = 0; i < src.getNumGeometries(); ++i) {
                Geometry geom = src.getGeometryN(i);
                LinearRing ring = factory.createLinearRing(geom.getCoordinates());
                if (Orientation.isCCW((Coordinate[])ring.getCoordinates())) {
                    holes.add(ring);
                    continue;
                }
                shells.add(ring);
            }
            if (shells.size() != 1) {
                shells.addAll(holes);
                holes.clear();
                ArrayList<LinearRing> foundholes = this.findCWHoles(shells);
                if (foundholes.size() > 0) {
                    shells.removeAll(foundholes);
                    for (int j = 0; j < foundholes.size(); ++j) {
                        LinearRing hole = foundholes.get(j);
                        if (!Orientation.isCCW((Coordinate[])hole.getCoordinates())) {
                            hole = this.reverseRing(hole);
                        }
                        holes.add(hole);
                    }
                }
            }
            if (shells.size() != 1) {
                this.warnUser(this._m("missing-exactly-one-shell", new Object[0]));
                return null;
            }
            return factory.createPolygon((LinearRing)shells.get(0), holes.toArray(new LinearRing[0]));
        }
        catch (IllegalArgumentException e) {
            this.warnUser(this._e(e.getMessage()));
            return null;
        }
    }

    public Polygon[] constructPolygons(Geometry src) {
        int i;
        if (src instanceof MultiPolygon) {
            Polygon[] polys = new Polygon[src.getNumGeometries()];
            for (int i2 = 0; i2 < src.getNumGeometries(); ++i2) {
                polys[i2] = (Polygon)src.getGeometryN(i2);
            }
            return polys;
        }
        if (src instanceof Polygon) {
            return new Polygon[]{(Polygon)src};
        }
        src = factory.createMultiLineString((LineString[])this.getRings(src));
        GeometryFactory geometryFactory = factory;
        ArrayList<LinearRing> shells = new ArrayList<LinearRing>();
        ArrayList<Object> holes = new ArrayList();
        for (int i3 = 0; i3 < src.getNumGeometries(); ++i3) {
            Geometry geom = src.getGeometryN(i3);
            Coordinate[] points = geom.getCoordinates();
            try {
                LinearRing ring = geometryFactory.createLinearRing(points);
                if (Orientation.isCCW((Coordinate[])points)) {
                    holes.add(ring);
                    continue;
                }
                shells.add(ring);
                continue;
            }
            catch (IllegalArgumentException e) {
                this.warnUser(this._m("bad-rings", new Object[0]));
                return null;
            }
        }
        if (shells.size() > 1 && holes.size() == 0 && (holes = this.findCWHoles(shells)).size() > 0) {
            shells.removeAll(holes);
            ArrayList<LinearRing> ccwHoles = new ArrayList<LinearRing>(holes.size());
            for (int i4 = 0; i4 < holes.size(); ++i4) {
                ccwHoles.add(this.reverseRing((LinearRing)holes.get(i4)));
            }
            holes = ccwHoles;
        }
        ArrayList holesForShells = new ArrayList(shells.size());
        ArrayList<LinearRing> holesWithoutShells = new ArrayList<LinearRing>();
        for (i = 0; i < shells.size(); ++i) {
            holesForShells.add(new ArrayList());
        }
        for (i = 0; i < holes.size(); ++i) {
            LinearRing testRing = (LinearRing)holes.get(i);
            LinearRing minShell = null;
            Envelope minEnv = null;
            Envelope testEnv = testRing.getEnvelopeInternal();
            Coordinate testPt = testRing.getCoordinateN(0);
            for (int j = 0; j < shells.size(); ++j) {
                LinearRing tryRing = (LinearRing)shells.get(j);
                Envelope tryEnv = tryRing.getEnvelopeInternal();
                if (minShell != null) {
                    minEnv = minShell.getEnvelopeInternal();
                }
                boolean isContained = false;
                Coordinate[] coordList = tryRing.getCoordinates();
                if (tryEnv.contains(testEnv) && PointLocation.isInRing((Coordinate)testPt, (Coordinate[])coordList)) {
                    isContained = true;
                }
                if (!isContained || minShell != null && !minEnv.contains(tryEnv)) continue;
                minShell = tryRing;
            }
            if (minShell == null) {
                holesWithoutShells.add(testRing);
                continue;
            }
            ((ArrayList)holesForShells.get(shells.indexOf(minShell))).add(testRing);
        }
        Polygon[] polygons = new Polygon[shells.size() + holesWithoutShells.size()];
        for (i = 0; i < shells.size(); ++i) {
            polygons[i] = geometryFactory.createPolygon((LinearRing)shells.get(i), ((ArrayList)holesForShells.get(i)).toArray(new LinearRing[0]));
        }
        for (i = 0; i < holesWithoutShells.size(); ++i) {
            polygons[shells.size() + i] = geometryFactory.createPolygon(this.reverseRing((LinearRing)holesWithoutShells.get(i)), null);
        }
        holesForShells = null;
        holesWithoutShells = null;
        shells = null;
        holes = null;
        return polygons;
    }

    private ArrayList<LinearRing> findCWHoles(ArrayList shells) {
        ArrayList<LinearRing> holesCW = new ArrayList<LinearRing>(shells.size());
        LinearRing[] noHole = new LinearRing[]{};
        for (int i = 0; i < shells.size(); ++i) {
            LinearRing iRing = (LinearRing)shells.get(i);
            Envelope iEnv = iRing.getEnvelopeInternal();
            Coordinate[] coordList = iRing.getCoordinates();
            for (int j = 0; j < shells.size(); ++j) {
                Polygon jPoly;
                Polygon iPoly;
                if (i == j) continue;
                LinearRing jRing = (LinearRing)shells.get(j);
                Envelope jEnv = jRing.getEnvelopeInternal();
                Coordinate jPt = jRing.getCoordinateN(0);
                Coordinate jPt2 = jRing.getCoordinateN(1);
                if (!iEnv.contains(jEnv) || !PointLocation.isInRing((Coordinate)jPt, (Coordinate[])coordList) || !PointLocation.isInRing((Coordinate)jPt2, (Coordinate[])coordList) || holesCW.contains(jRing) || !(iPoly = factory.createPolygon(iRing, noHole)).contains((Geometry)(jPoly = factory.createPolygon(jRing, noHole)))) continue;
                holesCW.add(jRing);
            }
        }
        return holesCW;
    }

    private LinearRing reverseRing(LinearRing lr) {
        int numPoints = lr.getNumPoints();
        Coordinate[] newCoords = new Coordinate[numPoints];
        for (int t = 0; t < numPoints; ++t) {
            newCoords[t] = lr.getCoordinateN(numPoints - t - 1);
        }
        return factory.createLinearRing(newCoords);
    }

    private LineString[] getLines(Geometry geom_src) {
        return (LineString[])this.getLines(geom_src, false);
    }

    private LinearRing[] getRings(Geometry geom_src) {
        return (LinearRing[])this.getLines(geom_src, true);
    }

    private Geometry[] getLines(Geometry geom_src, boolean asRings) {
        ArrayList<Object> linescol = new ArrayList<Object>();
        for (int i = 0; i < geom_src.getNumGeometries(); ++i) {
            Geometry g = geom_src.getGeometryN(i);
            if (g.getNumGeometries() > 1) {
                linescol.addAll(Arrays.asList(this.getLines(g, asRings)));
                continue;
            }
            if (g.getGeometryType().toLowerCase().endsWith("polygon")) {
                LinearComponentExtracter.getLines((Geometry)g, linescol, (!asRings ? 1 : 0) != 0);
                continue;
            }
            if (asRings) {
                linescol.add(factory.createLinearRing(g.getCoordinates()));
                continue;
            }
            linescol.add(factory.createLineString(g.getCoordinates()));
        }
        return asRings ? GeometryFactory.toLinearRingArray(linescol) : GeometryFactory.toLineStringArray(linescol);
    }

    private boolean okCancel(String title, String message) {
        JPanel panel = new JPanel();
        JLabel label = new JLabel("<html> " + message + " </html>");
        Font xx = label.getFont();
        int fontHeight = label.getFontMetrics(xx).getHeight();
        int stringWidth = label.getFontMetrics(xx).stringWidth(label.getText());
        int linesCount = (int)Math.floor(stringWidth / 300);
        linesCount = Math.max(1, linesCount + 2);
        label.setPreferredSize(new Dimension(300, fontHeight * linesCount));
        FlowLayout f = new FlowLayout(1, 10, 10);
        panel.setLayout(f);
        panel.add(label);
        OKCancelDialog dlg = new OKCancelDialog(this.getWorkbenchContext().getWorkbench().getFrame(), title, true, (Component)panel, new OKCancelDialog.Validator(){

            @Override
            public String validateInput(Component component) {
                return null;
            }
        });
        dlg.setVisible(true);
        return dlg.wasOKPressed();
    }

    private String _m(String string, Object ... objects) {
        return I18N.get(string, objects);
    }

    private String _e(String string) {
        return this.getMessageByMessage(string);
    }

    private String getMessageByMessage(String string) {
        Pattern pattern = Pattern.compile("(\\b)[\\d]+(\\b)");
        Matcher matcher = pattern.matcher(string);
        Vector<String> numbers = new Vector<String>();
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (matcher.find()) {
            numbers.add(matcher.group());
            matcher.appendReplacement(result, "{" + i++ + "}");
        }
        matcher.appendTail(result);
        String key = result.toString().toLowerCase().replaceAll("[\\s:=-]+", "-");
        String message = this._m(key, numbers.toArray());
        return message.equals(key) ? string : message;
    }

    static {
        items.add("Point");
        items.add("LineString");
        items.add("LinearRing");
        items.add("Polygon");
        items.add("MultiPoint");
        items.add("MultiLineString");
        items.add("MultiPolygon");
        items.add("GeometryCollection");
        items.add("separator");
        items.add("close-lines");
        items.add("remove-closing-segment");
    }

    private class LineFilter
    implements GeometryComponentFilter {
        private Collection lines;

        public LineFilter(List lines) {
            this.lines = lines;
        }

        public void filter(Geometry geom) {
            ArrayList linescol = new ArrayList();
            for (int i = 0; i < geom.getNumGeometries(); ++i) {
                LineString line = geom.getFactory().createLineString(geom.getGeometryN(i).getCoordinates());
                this.lines.add(line);
            }
        }
    }

    private static class RemoveClosing
    extends GeometryEditor.CoordinateOperation {
        private RemoveClosing() {
        }

        public Coordinate[] edit(Coordinate[] coordinates, Geometry geometry) {
            int lastIndex;
            for (lastIndex = coordinates.length - 1; lastIndex > 1 && coordinates[lastIndex].equals((Object)coordinates[0]); --lastIndex) {
            }
            if (lastIndex < coordinates.length - 1) {
                Coordinate[] newCoordinates = new Coordinate[lastIndex + 1];
                System.arraycopy(coordinates, 0, newCoordinates, 0, lastIndex + 1);
                return newCoordinates;
            }
            return coordinates;
        }
    }

    private static class CloseRing
    extends GeometryEditor.CoordinateOperation {
        private CloseRing() {
        }

        public Coordinate[] edit(Coordinate[] coordinates, Geometry geometry) {
            CoordinateList list = new CoordinateList(coordinates);
            list.closeRing();
            return list.toCoordinateArray();
        }
    }
}

