/*
 * Decompiled with CFR 0.152.
 */
package de.soldin.awt;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.Serializable;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class VerticalFlowLayout
implements LayoutManager,
Serializable {
    public static final int TOP = 0;
    public static final int CENTER = 1;
    public static final int BOTTOM = 2;
    int align;
    int hgap;
    int vgap;
    private Dimension preferred = null;
    public static final int WIDTH = 0;
    public static final int HEIGHT = 1;
    private int wrapMode = 0;
    private double defRatio = 1.0;

    public VerticalFlowLayout() {
        this(1, 5, 5);
    }

    public VerticalFlowLayout(int align) {
        this(align, 5, 5);
    }

    public VerticalFlowLayout(int align, int hgap, int vgap) {
        this.hgap = hgap;
        this.vgap = vgap;
        this.setAlignment(align);
    }

    public int getAlignment() {
        return this.align;
    }

    public void setAlignment(int align) {
        this.align = align;
    }

    public int getWrapMode() {
        return this.wrapMode;
    }

    public void setWrapMode(int wrapMode) {
        this.wrapMode = wrapMode;
    }

    public double getDefaultRatio() {
        return this.defRatio;
    }

    public void setDefaultRatio(double defRatio) {
        this.defRatio = defRatio;
    }

    public int getHgap() {
        return this.hgap;
    }

    public void setHgap(int hgap) {
        this.hgap = hgap;
    }

    public int getVgap() {
        return this.vgap;
    }

    public void setVgap(int vgap) {
        this.vgap = vgap;
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }

    @Override
    public Dimension preferredLayoutSize(Container target) {
        if (this.preferred == null) {
            this.layoutContainer(target);
            Dimension dim = this.padSize(target, this.preferred);
            return new Dimension(dim.width + 20, dim.height + 20);
        }
        return this.padScroll(target, this.padSize(target, this.preferred));
    }

    @Override
    public Dimension minimumLayoutSize(Container target) {
        return new Dimension(100, 100);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            Dimension dim;
            Insets insets = target.getInsets();
            int targetHeight = target.getSize().height;
            int targetWidth = target.getSize().width;
            if (targetHeight <= 0) {
                targetHeight = Integer.MAX_VALUE;
            }
            if (targetWidth <= 0) {
                targetWidth = Integer.MAX_VALUE;
            }
            int maxHeight = Integer.MAX_VALUE;
            int maxWidth = Integer.MAX_VALUE;
            Dimension scrollFix = this.scrollFix(target);
            if (targetWidth == Integer.MAX_VALUE && this.wrapMode == 0) {
                dim = this.calculateSizeByRatio(target);
                maxWidth = dim.width + scrollFix.width;
            } else if (targetHeight == Integer.MAX_VALUE && this.wrapMode == 1) {
                dim = this.calculateSizeByRatio(target);
                maxHeight = dim.height + scrollFix.height;
            } else {
                maxHeight = targetHeight - (insets.top + insets.bottom);
                maxWidth = targetWidth - (insets.left + insets.right);
            }
            int nmembers = target.getComponentCount();
            int x = 0;
            int y = 0;
            int columnWidth = 0;
            int start = 0;
            boolean ttb = target.getComponentOrientation().isLeftToRight();
            if (this.wrapMode == 1) {
                int maxColHeight = 0;
                for (int i = 0; i < nmembers; ++i) {
                    Component m = target.getComponent(i);
                    if (!m.isVisible()) continue;
                    Dimension d = m.getPreferredSize();
                    m.setSize(d.width, d.height);
                    if (y == 0 || y + d.height <= maxHeight) {
                        if (y > 0) {
                            y += this.vgap;
                        }
                        columnWidth = Math.max(columnWidth, d.width);
                        maxColHeight = Math.max(maxColHeight, y += d.height);
                        continue;
                    }
                    this.moveComponents(target, x, 0, columnWidth, maxHeight - y, start, i, ttb);
                    y = d.height;
                    x += this.hgap + columnWidth;
                    columnWidth = d.width;
                    start = i;
                }
                this.moveComponents(target, x, 0, columnWidth, maxHeight - y, start, nmembers, ttb);
                this.preferred = new Dimension(x + columnWidth, maxColHeight);
            } else {
                int maxColHeight = 0;
                boolean tooWide = false;
                for (int j = 0; j < nmembers && (maxColHeight == 0 || tooWide); ++j) {
                    tooWide = false;
                    x = 0;
                    y = 0;
                    columnWidth = 0;
                    start = 0;
                    for (int i = 0; i < nmembers && x < maxWidth; ++i) {
                        Component m = target.getComponent(i);
                        if (!m.isVisible()) continue;
                        Dimension d = m.getPreferredSize();
                        m.setSize(d.width, d.height);
                        if (y == 0 || i <= j || y + d.height <= maxColHeight) {
                            if (y > 0) {
                                y += this.vgap;
                            }
                            y += d.height;
                            columnWidth = Math.max(columnWidth, d.width);
                            if (i > j) continue;
                            maxColHeight = y;
                            continue;
                        }
                        this.moveComponents(target, x, 0, columnWidth, maxHeight - y, start, i, ttb);
                        y = d.height;
                        x += this.hgap + columnWidth;
                        columnWidth = d.width;
                        start = i;
                    }
                    this.moveComponents(target, x, 0, columnWidth, maxHeight - y, start, nmembers, ttb);
                    tooWide = (x += columnWidth + this.hgap) > maxWidth;
                }
                int scrollBug = this.preferred == null ? 0 : 0;
                this.preferred = new Dimension(x + scrollBug, maxColHeight + scrollBug);
            }
        }
    }

    private void moveComponents(Container target, int x, int y, int width, int height, int columnStart, int columnEnd, boolean ttb) {
        Insets insets = target.getInsets();
        x += insets.left;
        y += ttb ? insets.top : insets.bottom;
        switch (this.align) {
            case 0: {
                y += ttb ? 0 : height;
                break;
            }
            case 1: {
                y += height / 2;
                break;
            }
            case 2: {
                y += ttb ? height : 0;
            }
        }
        for (int i = columnStart; i < columnEnd; ++i) {
            Component m = target.getComponent(i);
            if (!m.isVisible()) continue;
            int cx = x + (width - m.getSize().width) / 2;
            if (ttb) {
                m.setLocation(cx, y);
            } else {
                m.setLocation(cx, target.getSize().height - y - m.getSize().height);
            }
            y += m.getSize().height + this.vgap;
        }
    }

    private Dimension calculateSizeByRatio(Container target) {
        boolean tooHigh = true;
        int maxAllowedColHeight = 0;
        int columnWidth = 0;
        int x = 0;
        int y = 0;
        while (tooHigh) {
            x = 0;
            y = 0;
            int firstColHeightMinusOne = 0;
            for (int i = 0; i < target.getComponentCount(); ++i) {
                Component m = target.getComponent(i);
                Dimension d = m.getPreferredSize();
                if (!m.isVisible()) continue;
                if (maxAllowedColHeight <= 0 || y < maxAllowedColHeight) {
                    if (y > 0) {
                        y += this.vgap;
                    }
                    y += d.height;
                    columnWidth = Math.max(columnWidth, d.width);
                } else {
                    y = d.height;
                    x += this.hgap + columnWidth;
                    columnWidth = d.width;
                }
                if (x != 0) continue;
                firstColHeightMinusOne = y - this.vgap - d.height;
            }
            tooHigh = firstColHeightMinusOne > 0 && (maxAllowedColHeight <= 0 || this.defRatio * (double)maxAllowedColHeight > (double)(x += this.hgap + columnWidth));
            if (!tooHigh) continue;
            maxAllowedColHeight = firstColHeightMinusOne;
        }
        return new Dimension(x, maxAllowedColHeight);
    }

    private Dimension padSize(Container target, Dimension in) {
        Dimension dim = new Dimension(in);
        Insets insets = target.getInsets();
        dim.width += insets.left + insets.right;
        dim.height += insets.top + insets.bottom;
        return dim;
    }

    private Dimension padScroll(Container target, Dimension dim) {
        Dimension scrollFix = this.scrollFix(target);
        dim.width -= scrollFix.width;
        dim.height -= scrollFix.height;
        return dim;
    }

    private Dimension scrollFix(Container target) {
        int height = 0;
        int width = 0;
        JScrollPane scrollPane = (JScrollPane)SwingUtilities.getAncestorOfClass(JScrollPane.class, target);
        if (scrollPane != null) {
            height = scrollPane.getHorizontalScrollBar().getPreferredSize().height;
            width = scrollPane.getVerticalScrollBar().getPreferredSize().width;
        }
        return new Dimension(width, height);
    }

    public String toString() {
        String str = "";
        switch (this.align) {
            case 0: {
                str = ",align=top";
                break;
            }
            case 1: {
                str = ",align=center";
                break;
            }
            case 2: {
                str = ",align=bottom";
            }
        }
        return this.getClass().getName() + "[hgap=" + this.hgap + ",vgap=" + this.vgap + str + "]";
    }

    public static void main(String[] args) {
        JPanel main = new JPanel(new BorderLayout());
        VerticalFlowLayout l = new VerticalFlowLayout(0, 5, 10);
        JPanel p = new JPanel(l);
        p.setBorder(BorderFactory.createMatteBorder(10, 10, 20, 20, Color.LIGHT_GRAY));
        for (int i = 0; i <= 100; ++i) {
            String text = i % 5 == 0 ? "<html>" + i + "<br><br>some more</html>" : i + "";
            p.add(new JLabel(text));
        }
        JScrollPane scroll = new JScrollPane(p);
        main.add((Component)scroll, "Center");
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        frame.add(main);
        frame.pack();
        frame.setVisible(true);
    }
}

