/*
 * Decompiled with CFR 0.152.
 */
package de.latlon.deejump.plugin.style;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.util.Blackboard;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.UndoableCommand;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import com.vividsolutions.jump.workbench.ui.WorkbenchFrame;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import com.vividsolutions.jump.workbench.ui.renderer.style.ColorThemingStylePanel;
import com.vividsolutions.jump.workbench.ui.renderer.style.Style;
import com.vividsolutions.jump.workbench.ui.style.DecorationStylePanel;
import com.vividsolutions.jump.workbench.ui.style.LabelStylePanel;
import com.vividsolutions.jump.workbench.ui.style.ScaleStylePanel;
import com.vividsolutions.jump.workbench.ui.style.StylePanel;
import de.latlon.deejump.plugin.style.DeeRenderingStylePanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.locationtech.jts.util.Assert;

public class DeeChangeStylesPlugIn
extends AbstractPlugIn {
    private static final String LAST_TAB_KEY = DeeChangeStylesPlugIn.class.getName() + " - LAST TAB";

    @Override
    public String getName() {
        return I18N.getInstance().get("ui.style.ChangeStylesPlugIn.change-styles");
    }

    @Override
    public void initialize(PlugInContext context) throws Exception {
        super.initialize(context);
    }

    @Override
    public boolean execute(final PlugInContext context) throws Exception {
        WorkbenchFrame wbframe = context.getWorkbenchFrame();
        WorkbenchContext wbcontext = context.getWorkbenchContext();
        Blackboard blackboard = wbcontext.getWorkbench().getBlackboard();
        Blackboard pb = PersistentBlackboardPlugIn.get(wbcontext);
        final Layer layer = context.getSelectedLayer(0);
        final MultiInputDialog dialog = new MultiInputDialog(wbframe, I18N.getInstance().get("ui.style.ChangeStylesPlugIn.change-styles") + " - " + layer.getName(), true);
        dialog.setApplyVisible(true);
        dialog.setInset(0);
        dialog.setSideBarImage(IconLoader.icon("Symbology.gif"));
        dialog.setSideBarDescription(I18N.getInstance().get("ui.style.ChangeStylesPlugIn.you-can-use-this-dialog-to-change-the-colour-line-width"));
        final ArrayList<StylePanel> stylePanels = new ArrayList<StylePanel>();
        DeeRenderingStylePanel renderingStylePanel = new DeeRenderingStylePanel(blackboard, layer, pb);
        Collection<Style> oldStyles = layer.cloneStyles();
        stylePanels.add(renderingStylePanel);
        stylePanels.add(new ScaleStylePanel(layer, context.getLayerViewPanel()));
        DecorationStylePanel decorationStylePanel = new DecorationStylePanel(layer, wbframe.getChoosableStyleClasses());
        decorationStylePanel.setPreferredSize(new Dimension(400, 300));
        FeatureSchema schema = layer.getFeatureCollectionWrapper().getFeatureSchema();
        int numberOfAttributesUsableInColorTheming = schema.getAttributeCount() - 1;
        if (schema.hasAttribute("R_G_B")) {
            --numberOfAttributesUsableInColorTheming;
        }
        if (numberOfAttributesUsableInColorTheming >= 1) {
            ColorThemingStylePanel colorThemingStylePanel = new ColorThemingStylePanel(layer, wbcontext);
            colorThemingStylePanel.setPreferredSize(new Dimension(400, 300));
            stylePanels.add(colorThemingStylePanel);
            GUIUtil.sync(renderingStylePanel.getTransparencySlider(), colorThemingStylePanel.getTransparencySlider());
            GUIUtil.sync(renderingStylePanel.getSynchronizeCheckBox(), colorThemingStylePanel.getSynchronizeCheckBox());
            GUIUtil.sync(renderingStylePanel.getLineWidthSlider(), colorThemingStylePanel.getLineWidthSlider());
        } else {
            stylePanels.add(new DummyColorThemingStylePanel());
        }
        stylePanels.add(new LabelStylePanel(layer, context.getLayerViewPanel(), dialog, context.getErrorHandler()));
        stylePanels.add(decorationStylePanel);
        JTabbedPane tabbedPane = new JTabbedPane();
        for (final StylePanel stylePanel : stylePanels) {
            tabbedPane.add((Component)((Object)stylePanel), stylePanel.getTitle());
            dialog.addEnableChecks(stylePanel.getTitle(), new EnableCheck(){

                @Override
                public String check(JComponent component) {
                    return stylePanel.validateInput();
                }
            });
        }
        dialog.addRow(tabbedPane);
        String selectedTab = (String)blackboard.get(LAST_TAB_KEY, ((StylePanel)stylePanels.iterator().next()).getTitle());
        dialog.addOKCancelApplyPanelActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (dialog.wasApplyPressed()) {
                    for (StylePanel stylePanel : stylePanels) {
                        if (stylePanel.validateInput() == null) continue;
                        context.getWorkbenchFrame().handleThrowable(new Exception(stylePanel.validateInput()), dialog);
                        return;
                    }
                    if (dialog.wasApplyPressed()) {
                        DeeChangeStylesPlugIn.this.testStyles(layer, stylePanels);
                    }
                }
            }
        });
        tabbedPane.setSelectedComponent(this.find(stylePanels, selectedTab));
        dialog.pack();
        GUIUtil.centreOnWindow(dialog);
        dialog.setVisible(true);
        blackboard.put(LAST_TAB_KEY, ((StylePanel)((Object)tabbedPane.getSelectedComponent())).getTitle());
        if (dialog.wasOKPressed()) {
            this.applyStyles(layer, stylePanels, oldStyles, context);
            return true;
        }
        this.reportNothingToUndoYet(context);
        return false;
    }

    private void testStyles(Layer layer, ArrayList<StylePanel> stylePanels) {
        for (StylePanel stylePanel : stylePanels) {
            stylePanel.updateStyles();
        }
        if (layer.getVertexStyle().isEnabled()) {
            layer.getBasicStyle().setRenderingVertices(false);
        }
    }

    private void applyStyles(final Layer layer, final ArrayList<StylePanel> stylePanels, final Collection<Style> oldStyles, PlugInContext context) {
        layer.getLayerManager().deferFiringEvents(new Runnable(){

            @Override
            public void run() {
                for (StylePanel stylePanel : stylePanels) {
                    stylePanel.updateStyles();
                }
            }
        });
        layer.getLayerManager().deferFiringEvents(new Runnable(){

            @Override
            public void run() {
                if (layer.getVertexStyle().isEnabled()) {
                    layer.getBasicStyle().setRenderingVertices(false);
                }
            }
        });
        final Collection<Style> newStyles = layer.cloneStyles();
        this.execute(new UndoableCommand(this.getName()){

            @Override
            public void execute() {
                layer.setStyles(newStyles);
            }

            @Override
            public void unexecute() {
                layer.setStyles(oldStyles);
            }
        }, context);
    }

    private Component find(Collection<StylePanel> stylePanels, String title) {
        for (StylePanel stylePanel : stylePanels) {
            if (!stylePanel.getTitle().equals(title)) continue;
            return (Component)((Object)stylePanel);
        }
        Assert.shouldNeverReachHere();
        return null;
    }

    @Override
    public ImageIcon getIcon() {
        return IconLoader.icon("Palette.png");
    }

    public MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerNamePanelMustBeActiveCheck()).add(checkFactory.createWindowWithLayerViewPanelMustBeActiveCheck()).add(checkFactory.createExactlyNLayersMustBeSelectedCheck(1));
    }

    private class DummyColorThemingStylePanel
    extends JPanel
    implements StylePanel {
        private static final long serialVersionUID = 2217457292163045134L;

        private DummyColorThemingStylePanel() {
            super(new GridBagLayout());
            this.add(new JLabel(I18N.getInstance().get("ui.style.ChangeStylesPlugIn.this-layer-has-no-attributes")));
        }

        @Override
        public String getTitle() {
            return ColorThemingStylePanel.TITLE;
        }

        @Override
        public void updateStyles() {
        }

        @Override
        public String validateInput() {
            return null;
        }
    }
}

