/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.wms;

import com.vividsolutions.jump.workbench.Logger;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public enum AxisOrder {
    LATLON,
    LONLAT;

    public static final List<String> LATLONCRS;
    public static boolean initialized;

    public static AxisOrder getAxisOrder(String srs) {
        AxisOrder.init();
        return Collections.binarySearch(LATLONCRS, srs.toUpperCase()) >= 0 ? LATLON : LONLAT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void init() {
        if (initialized) {
            return;
        }
        InputStream is = null;
        BufferedReader br = null;
        try {
            is = AxisOrder.class.getResourceAsStream("latlonaxisorder.csv");
            br = new BufferedReader(new InputStreamReader(is));
            String namespace = "EPSG";
            String line = null;
            while (null != (line = br.readLine())) {
                if ((line = line.trim()).length() == 0) continue;
                char firstChar = line.charAt(0);
                if (Character.isLetter(firstChar)) {
                    namespace = line.toUpperCase();
                    continue;
                }
                if (!Character.isDigit(firstChar)) continue;
                try {
                    LATLONCRS.add(namespace + ":" + line);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            initialized = true;
            Logger.info("LatLon CRS list has been initialized for WMS 1.3.0");
        }
        catch (IOException ioe) {
            System.out.println("Initialization of 'latlonaxisorder.csv' failed !");
            Logger.error("Initialization of 'latlonaxisorder.csv' failed !");
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
            Collections.sort(LATLONCRS);
        }
    }

    static {
        LATLONCRS = new ArrayList<String>();
        initialized = false;
    }
}

