/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.zoom;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.JUMPException;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.geom.EnvelopeUtil;
import com.vividsolutions.jump.util.CoordinateArrays;
import com.vividsolutions.jump.util.StringUtil;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.cursortool.Animations;
import java.awt.Color;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.JOptionPane;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;

public class ZoomToCoordinatePlugIn
extends AbstractPlugIn {
    private Coordinate lastCoordinate = new Coordinate(0.0, 0.0);

    @Override
    public void initialize(PlugInContext context) throws Exception {
        super.initialize(context);
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        Coordinate coordinate = null;
        boolean retry = true;
        while (retry) {
            try {
                String value = JOptionPane.showInputDialog(context.getWorkbenchFrame(), I18N.getInstance().get("ui.zoom.ZoomToCoordinatePlugIn.enter-coordinate-to-zoom-to"), this.lastCoordinate.x + ", " + this.lastCoordinate.y);
                if (value == null) {
                    retry = false;
                    continue;
                }
                coordinate = this.toCoordinate(value);
                retry = false;
            }
            catch (Exception e) {
                context.getWorkbenchContext().getErrorHandler().handleThrowable(e);
            }
        }
        if (coordinate == null) {
            return false;
        }
        this.lastCoordinate = coordinate;
        context.getLayerViewPanel().getViewport().zoom(this.toEnvelope(coordinate, context.getLayerManager()));
        Animations.drawExpandingRing(context.getLayerViewPanel().getViewport().toViewPoint(this.lastCoordinate), false, Color.BLUE, context.getLayerViewPanel(), new float[]{20.0f, 20.0f});
        return true;
    }

    private Envelope toEnvelope(Coordinate coordinate, LayerManager layerManager) {
        int segments = 0;
        int segmentSum = 0;
        Iterator<Layer> i = layerManager.iterator(Layer.class);
        block0: while (i.hasNext()) {
            Layer layer = i.next();
            for (Feature feature : layer.getFeatureCollectionWrapper().getFeatures()) {
                List<Coordinate[]> coordinateArrays = CoordinateArrays.toCoordinateArrays(feature.getGeometry(), false);
                for (Coordinate[] coordinates : coordinateArrays) {
                    for (int a = 1; a < coordinates.length; ++a) {
                        segmentSum = (int)((double)segmentSum + coordinates[a].distance(coordinates[a - 1]));
                        if (++segments > 100) break block0;
                    }
                }
            }
        }
        Envelope envelope = new Envelope(coordinate);
        envelope = segmentSum > 0 ? EnvelopeUtil.expand(envelope, (double)segmentSum / (double)segments) : EnvelopeUtil.expand(envelope, 50.0);
        return envelope;
    }

    private Coordinate toCoordinate(String s) throws Exception {
        StringTokenizer tokenizer = new StringTokenizer(s = StringUtil.replaceAll(s, ",", " "));
        if (tokenizer.countTokens() < 2) {
            throw new JUMPException(I18N.getInstance().get("ui.zoom.ZoomToCoordinatePlugIn.enter-two-values"));
        }
        String x = tokenizer.nextToken();
        if (!StringUtil.isNumber(x)) {
            throw new JUMPException(I18N.getInstance().get("ui.zoom.ZoomToCoordinatePlugIn.{0}-is-not-a-number", x));
        }
        String y = tokenizer.nextToken();
        if (!StringUtil.isNumber(y)) {
            throw new JUMPException(I18N.getInstance().get("ui.zoom.ZoomToCoordinatePlugIn.{0}-is-not-a-number", y));
        }
        return new Coordinate(Double.parseDouble(x), Double.parseDouble(y));
    }

    public MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerViewPanelMustBeActiveCheck());
    }
}

