/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.task;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.task.RefreshRated;
import com.vividsolutions.jump.task.TaskMonitorV2;
import com.vividsolutions.jump.workbench.ui.AnimatedClockPanel;
import com.vividsolutions.jump.workbench.ui.ErrorHandler;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.text.JTextComponent;

public class TaskMonitorDialog
extends JDialog
implements TaskMonitorV2,
RefreshRated {
    private JPanel mainPanel = new JPanel();
    private JPanel labelPanel = new JPanel();
    private JButton cancelButton = new JButton();
    boolean allowCancellation = false;
    private ErrorHandler errorHandler;
    private boolean cancelled;
    private JTextComponent taskProgressLabel;
    private Component separator;
    private JTextComponent subtaskProgressLabel;
    public String taskProgress = "";
    public String subtaskProgress = "";
    private Timer timer = new Timer(500, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            TaskMonitorDialog.this.updateLabels();
        }
    });
    private AnimatedClockPanel clockPanel = new AnimatedClockPanel();

    public TaskMonitorDialog(Frame frame, ErrorHandler errorHandler) {
        this(frame, errorHandler, true);
    }

    public TaskMonitorDialog(Frame frame, ErrorHandler errorHandler, boolean modal) {
        super(frame, I18N.getInstance().get("ui.task.TaskMonitorDialog.busy"), modal);
        this.errorHandler = errorHandler;
        try {
            this.setLayout(new GridBagLayout());
            this.jbInit();
            this.pack();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                TaskMonitorDialog.this.cancelButton.setEnabled(true);
            }
        });
        this.setDefaultCloseOperation(0);
    }

    private void jbInit() throws Exception {
        this.mainPanel.setLayout(new GridBagLayout());
        this.cancelButton.setText(I18N.getInstance().get("ui.task.TaskMonitorDialog.cancel"));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TaskMonitorDialog.this.cancelButton_actionPerformed(e);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                TaskMonitorDialog.this.this_componentShown(e);
            }

            @Override
            public void componentHidden(ComponentEvent e) {
                TaskMonitorDialog.this.this_componentHidden(e);
            }
        });
        this.labelPanel.setLayout(new GridBagLayout());
        this.taskProgressLabel = this.createWrapLabel("");
        this.taskProgressLabel.setText(I18N.getInstance().get("ui.task.TaskMonitorDialog.task-progress-goes-here"));
        this.separator = Box.createRigidArea(new Dimension(10, 10));
        this.subtaskProgressLabel = this.createWrapLabel("");
        this.subtaskProgressLabel.setText(I18N.getInstance().get("ui.task.TaskMonitorDialog.subtask-progress-goes-here"));
        this.mainPanel.add((Component)this.labelPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.labelPanel.add((Component)this.taskProgressLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.labelPanel.add(this.separator, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.labelPanel.add((Component)this.subtaskProgressLabel, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        JPanel centerPanel = new JPanel(new GridBagLayout());
        centerPanel.add((Component)this.clockPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 10, 0));
        centerPanel.add((Component)this.mainPanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.setLayout(new GridBagLayout());
        this.add((Component)centerPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)this.cancelButton, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 15, 0, new Insets(0, 0, 10, 0), 0, 0));
    }

    void cancelButton_actionPerformed(ActionEvent e) {
        this.cancelButton.setEnabled(false);
        this.cancelled = true;
    }

    void this_componentHidden(ComponentEvent e) {
        this.clockPanel.stop();
        this.timer.stop();
    }

    void this_componentShown(ComponentEvent e) {
        this.cancelled = false;
        this.cancelButton.setVisible(this.allowCancellation);
        this.timer.start();
        this.clockPanel.start();
        this.updateLabels();
    }

    private void updateLabels() {
        if (this.cancelled) {
            return;
        }
        this.taskProgressLabel.setText(this.taskProgress);
        this.taskProgressLabel.setVisible(!this.taskProgress.isEmpty());
        this.separator.setVisible(!this.taskProgress.isEmpty() && !this.subtaskProgress.isEmpty());
        this.subtaskProgressLabel.setText(this.subtaskProgress);
        this.subtaskProgressLabel.setVisible(!this.subtaskProgress.isEmpty());
        this.pack();
    }

    @Override
    public int getRefreshRate() {
        return this.timer.getDelay();
    }

    @Override
    public void setRefreshRate(int millisecondDelay) {
        this.timer.setDelay(millisecondDelay);
    }

    @Override
    public void report(String description) {
        this.taskProgress = description;
        this.subtaskProgress = "";
    }

    @Override
    public void report(long subtasksDone, long totalSubtasks, String subtaskDescription) {
        this.subtaskProgress = "";
        this.subtaskProgress = this.subtaskProgress + subtasksDone;
        if (totalSubtasks != -1L) {
            this.subtaskProgress = this.subtaskProgress + " / " + totalSubtasks;
        }
        this.subtaskProgress = this.subtaskProgress + " " + subtaskDescription;
    }

    @Override
    public void report(int subtasksDone, int totalSubtasks, String subtaskDescription) {
        this.report((long)subtasksDone, (long)totalSubtasks, subtaskDescription);
    }

    @Override
    public void allowCancellationRequests() {
        this.allowCancellation = true;
        this.cancelButton.setVisible(true);
    }

    @Override
    public void report(Exception exception) {
        this.errorHandler.handleThrowable(exception);
    }

    @Override
    public boolean isCancelRequested() {
        return this.cancelled;
    }

    @Override
    public void setTitle(String title) {
        super.setTitle(title);
    }

    protected JTextComponent createWrapLabel(String text) {
        JTextArea textArea = new JTextArea(0, 30);
        textArea.setText(text);
        textArea.setWrapStyleWord(true);
        textArea.setLineWrap(true);
        textArea.setOpaque(false);
        textArea.setEditable(false);
        textArea.setFocusable(false);
        textArea.setBackground(UIManager.getColor("Label.background"));
        textArea.setFont(UIManager.getFont("Label.font"));
        textArea.setBorder(UIManager.getBorder("Label.border"));
        return textArea;
    }

    public static void main(String[] args) {
        final TaskMonitorDialog d = new TaskMonitorDialog(null, null);
        d.report("This is what we are doing.");
        new Thread(new Runnable(){

            @Override
            public void run() {
                d.pack();
                d.show();
            }
        }).start();
        for (int i = 0; i < 1000; ++i) {
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            d.report(i, 1000, "irgendwas");
            String t = d.taskProgress;
            d.taskProgress = d.taskProgress + "palimipalim";
        }
    }
}

