/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.renderer.style;

import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.Viewport;
import com.vividsolutions.jump.workbench.ui.renderer.style.BasicStyle;
import com.vividsolutions.jump.workbench.ui.renderer.style.SquareVertexStyle;
import com.vividsolutions.jump.workbench.ui.renderer.style.VertexStyle;
import java.awt.Color;
import java.awt.Graphics2D;

public class XBasicStyle
extends BasicStyle {
    VertexStyle vertexStyle = new SquareVertexStyle();

    public XBasicStyle() {
    }

    public XBasicStyle(BasicStyle fromBasicStyle, VertexStyle fromVertexStyle) {
        assert (fromVertexStyle != null) : "XBasicStyle must have a non null VertexStyle";
        this.setEnabled(fromBasicStyle.isEnabled());
        this.setRenderingFill(fromBasicStyle.isRenderingFill());
        this.setFillColor(fromBasicStyle.getFillColor());
        this.setAlpha(fromBasicStyle.getAlpha());
        this.setFillPattern(fromBasicStyle.getFillPattern());
        this.setRenderingFillPattern(fromBasicStyle.isRenderingFillPattern());
        this.setRenderingLine(fromBasicStyle.isRenderingLine());
        this.setLineColor(fromBasicStyle.getLineColor());
        this.setLineWidth(fromBasicStyle.getLineWidth());
        this.setLinePattern(fromBasicStyle.getLinePattern());
        this.setRenderingLinePattern(fromBasicStyle.isRenderingLinePattern());
        this.setInteriorBorder(fromBasicStyle.hasInteriorBorder());
        this.setRenderingVertices(fromVertexStyle == null || !fromVertexStyle.isEnabled());
        if (fromVertexStyle == null) {
            this.vertexStyle = new SquareVertexStyle();
            this.vertexStyle.setFillColor(fromBasicStyle.getFillColor());
            this.vertexStyle.setLineColor(fromBasicStyle.getLineColor());
            this.vertexStyle.setAlpha(fromBasicStyle.getAlpha());
            this.vertexStyle.setEnabled(false);
        } else {
            this.vertexStyle = (VertexStyle)fromVertexStyle.clone();
        }
    }

    @Override
    public Color getFillColor() {
        return GUIUtil.alphaColor(super.getFillColor(), this.getAlpha());
    }

    public VertexStyle getVertexStyle() {
        return this.vertexStyle;
    }

    public void setVertexStyle(VertexStyle vertexStyle) {
        this.vertexStyle = vertexStyle;
    }

    @Override
    public void initialize(Layer layer) {
        super.initialize(layer);
    }

    @Override
    public void paint(Feature f, Graphics2D g, Viewport viewport) throws Exception {
        super.paint(f, g, viewport);
        if (this.vertexStyle.isEnabled()) {
            this.vertexStyle.setAlpha(this.getAlpha());
            this.vertexStyle.paint(f, g, viewport);
        }
    }

    @Override
    public XBasicStyle clone() {
        VertexStyle vs = (VertexStyle)this.vertexStyle.clone();
        return new XBasicStyle(this, vs);
    }

    @Override
    public Color getFeatureColor(Feature feature) {
        return super.getFeatureColor(feature);
    }
}

