/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.renderer.style;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.util.Block;
import com.vividsolutions.jump.util.CollectionUtil;
import com.vividsolutions.jump.util.ImmutableFirstElementList;
import com.vividsolutions.jump.workbench.ui.ColumnBasedTableModel;
import com.vividsolutions.jump.workbench.ui.renderer.style.BasicStyle;
import com.vividsolutions.jump.workbench.ui.renderer.style.ColorScheme;
import com.vividsolutions.jump.workbench.ui.renderer.style.SquareVertexStyle;
import com.vividsolutions.jump.workbench.ui.renderer.style.VertexStyle;
import com.vividsolutions.jump.workbench.ui.renderer.style.XBasicStyle;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableModel;

public class ColorThemingTableModel
extends ColumnBasedTableModel {
    BasicStyle defaultStyle;
    public static final int COLOR_COLUMN = 0;
    public static final int ATTRIBUTE_COLUMN = 1;
    public static final int LABEL_COLUMN = 2;
    protected List<AttributeMapping> attributeMappings;
    private boolean lastSortAscending = true;
    protected String attributeName;

    public ColorThemingTableModel(BasicStyle defaultStyle, String attributeName, Map attributeValueToBasicStyleMap, Map attributeValueToLabelMap, FeatureSchema schema) {
        this.defaultStyle = defaultStyle;
        this.attributeMappings = new ImmutableFirstElementList<AttributeMapping>(new AttributeMapping(null, defaultStyle, null));
        this.attributeName = attributeName;
        this.setMaps(attributeValueToBasicStyleMap, attributeValueToLabelMap);
        this.setColumns(this.createColumns(schema));
    }

    public void setMaps(Map<Object, BasicStyle> attributeValueToBasicStyleMap, Map<Object, String> attributeValueToLabelMap) {
        this.attributeMappings.clear();
        for (Object attributeValue : attributeValueToBasicStyleMap.keySet()) {
            this.attributeMappings.add(new AttributeMapping(attributeValue, attributeValueToBasicStyleMap.get(attributeValue), attributeValueToLabelMap.get(attributeValue)));
        }
        this.fireTableChanged(new TableModelEvent(this));
    }

    public void clear() {
        this.attributeMappings.clear();
        this.fireTableChanged(new TableModelEvent(this));
    }

    public boolean containsNullAttributeValues() {
        for (AttributeMapping attributeMapping : this.nonDefaultAttributeMappings()) {
            if (attributeMapping.getAttributeValue() != null) continue;
            return true;
        }
        return false;
    }

    protected AttributeMapping attributeMapping(int i) {
        return this.attributeMappings.get(i);
    }

    public BasicStyle getDefaultStyle() {
        return this.attributeMapping(0).getBasicStyle();
    }

    public Object findDuplicateAttributeValue() {
        TreeSet<Object> set = new TreeSet<Object>();
        for (AttributeMapping attributeMapping : this.nonDefaultAttributeMappings()) {
            if (attributeMapping.getAttributeValue() == null) continue;
            if (set.contains(attributeMapping.getAttributeValue())) {
                return attributeMapping.getAttributeValue();
            }
            set.add(attributeMapping.getAttributeValue());
        }
        return null;
    }

    protected List createColumns(final FeatureSchema schema) {
        ArrayList<ColumnBasedTableModel.Column> columns = new ArrayList<ColumnBasedTableModel.Column>();
        columns.add(new ColumnBasedTableModel.Column(I18N.getInstance().get("ui.renderer.style.ColorThemingTableModel.style"), BasicStyle.class){

            @Override
            public Object getValueAt(int rowIndex) {
                return ColorThemingTableModel.this.attributeMapping(rowIndex).getBasicStyle();
            }

            @Override
            public void setValueAt(Object value, int rowIndex) {
                ColorThemingTableModel.this.attributeMapping(rowIndex).setBasicStyle((BasicStyle)value);
                ColorThemingTableModel.this.fireTableChanged(new TableModelEvent(ColorThemingTableModel.this, rowIndex));
            }
        });
        columns.add(new ColumnBasedTableModel.Column(I18N.getInstance().get("ui.renderer.style.ColorThemingTableModel.attribute-value"), null){

            @Override
            public Class getDataClass() {
                return ColorThemingTableModel.this.attributeName == null || !schema.hasAttribute(ColorThemingTableModel.this.attributeName) ? Object.class : schema.getAttributeType(ColorThemingTableModel.this.attributeName).toJavaClass();
            }

            @Override
            public Object getValueAt(int rowIndex) {
                return ColorThemingTableModel.this.attributeMapping(rowIndex).getAttributeValue();
            }

            @Override
            public void setValueAt(Object value, int rowIndex) {
                ColorThemingTableModel.this.attributeMapping(rowIndex).setAttributeValue(value);
                ColorThemingTableModel.this.fireTableChanged(new AttributeValueTableModelEvent(ColorThemingTableModel.this, rowIndex));
            }
        });
        columns.add(new ColumnBasedTableModel.Column(I18N.getInstance().get("ui.renderer.style.ColorThemingTableModel.label"), String.class){

            @Override
            public Object getValueAt(int rowIndex) {
                return ColorThemingTableModel.this.attributeMapping(rowIndex).getLabel();
            }

            @Override
            public void setValueAt(Object value, int rowIndex) {
                ColorThemingTableModel.this.attributeMapping(rowIndex).setLabel((String)value);
                ColorThemingTableModel.this.fireTableChanged(new AttributeValueTableModelEvent(ColorThemingTableModel.this, rowIndex));
            }
        });
        return columns;
    }

    public void apply(ColorScheme colorScheme, boolean skipDefaultAttributeMapping) {
        for (AttributeMapping attributeMapping : skipDefaultAttributeMapping ? this.nonDefaultAttributeMappings() : this.attributeMappings) {
            Color color = colorScheme.next();
            VertexStyle newVertexStyle = new SquareVertexStyle();
            newVertexStyle.setEnabled(false);
            if (this.defaultStyle instanceof XBasicStyle) {
                newVertexStyle = ((XBasicStyle)this.defaultStyle).getVertexStyle();
            }
            newVertexStyle.setFillColor(color);
            newVertexStyle.setLineColor(color.darker());
            newVertexStyle.setAlpha(this.defaultStyle.getAlpha());
            XBasicStyle xBasicStyle = new XBasicStyle(this.defaultStyle, newVertexStyle);
            xBasicStyle.setFillColor(color);
            xBasicStyle.setLineColor(color.darker());
            attributeMapping.setBasicStyle(xBasicStyle);
        }
        this.fireTableChanged(new TableModelEvent(this));
    }

    @Override
    public int getRowCount() {
        return this.attributeMappings.size();
    }

    public void setAttributeName(String attributeName) {
        this.attributeName = attributeName;
    }

    public Map getAttributeValueToBasicStyleMap() {
        return this.attributeValueToObjectMap(new Block(){

            @Override
            public Object yield(Object attributeMapping) {
                return ((AttributeMapping)attributeMapping).getBasicStyle();
            }
        });
    }

    public Map getAttributeValueToLabelMap() {
        return this.attributeValueToObjectMap(new Block(){

            @Override
            public Object yield(Object attributeMapping) {
                return ((AttributeMapping)attributeMapping).getLabel();
            }
        });
    }

    private Map attributeValueToObjectMap(Block getter) {
        TreeMap<Object, Object> attributeValueToObjectMap = new TreeMap<Object, Object>();
        for (AttributeMapping attributeMapping : this.nonDefaultAttributeMappings()) {
            attributeValueToObjectMap.put(attributeMapping.getAttributeValue(), getter.yield(attributeMapping));
        }
        return attributeValueToObjectMap;
    }

    public boolean wasLastSortAscending() {
        return this.lastSortAscending;
    }

    public void sort() {
        this.sort(!this.lastSortAscending);
    }

    public void sort(boolean ascending) {
        if (ascending) {
            Collections.sort(this.nonDefaultAttributeMappings());
        } else {
            Collections.sort(this.nonDefaultAttributeMappings(), Collections.reverseOrder());
        }
        this.lastSortAscending = ascending;
        this.fireTableChanged(new TableModelEvent(this));
    }

    public void removeAttributeValues(int[] rows) {
        for (Object e : CollectionUtil.reverseSortedSet(rows)) {
            Integer row = (Integer)e;
            this.attributeMappings.remove(row);
            this.fireTableChanged(new TableModelEvent(this, row, row, -1, -1));
        }
    }

    public int insertAttributeValue(int row, ColorScheme colorScheme) {
        Color color = colorScheme.next();
        BasicStyle bs = new BasicStyle(color);
        SquareVertexStyle vs = new SquareVertexStyle();
        vs.setFillColor(color);
        vs.setLineColor(color.darker());
        vs.setAlpha(bs.getAlpha());
        vs.setEnabled(false);
        XBasicStyle newBasicStyle = new XBasicStyle(bs, vs);
        this.attributeMappings.add(row, new AttributeMapping(null, newBasicStyle, ""));
        this.fireTableChanged(new TableModelEvent(this, row, row, -1, 1));
        return row;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (rowIndex == 0 && columnIndex == 1) {
            return false;
        }
        return rowIndex != 0 || columnIndex != 2;
    }

    protected List<AttributeMapping> nonDefaultAttributeMappings() {
        return this.attributeMappings.subList(1, this.attributeMappings.size());
    }

    public static class AttributeValueTableModelEvent
    extends TableModelEvent {
        public AttributeValueTableModelEvent(TableModel source, int row) {
            super(source, row);
        }
    }

    protected static class AttributeMapping
    implements Comparable {
        private String label;
        private Object attributeValue;
        private BasicStyle basicStyle;

        public AttributeMapping(Object attributeValue, BasicStyle basicStyle, String label) {
            this.attributeValue = attributeValue;
            this.basicStyle = basicStyle;
            this.label = label;
        }

        public Object getAttributeValue() {
            return this.attributeValue;
        }

        public BasicStyle getBasicStyle() {
            return this.basicStyle;
        }

        public int compareTo(Object o) {
            AttributeMapping other = (AttributeMapping)o;
            if (this.attributeValue == null) {
                return -1;
            }
            if (other.attributeValue == null) {
                return 1;
            }
            return ((Comparable)this.attributeValue).compareTo(other.attributeValue);
        }

        public void setAttributeValue(Object object) {
            this.attributeValue = object;
        }

        public void setBasicStyle(BasicStyle style) {
            this.basicStyle = style;
        }

        protected String getLabel() {
            return this.label;
        }

        protected void setLabel(String label) {
            this.label = label;
        }
    }
}

