/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.test;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.BasicFeature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.StandardCategoryNames;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.PlugIn;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;

public class RandomTrianglesPlugIn
extends AbstractPlugIn {
    private GeometryFactory geometryFactory = new GeometryFactory();
    private WKTReader wktReader = new WKTReader(this.geometryFactory);
    private List cities = Arrays.asList("Alabama", "Alaska", "Arizona", "Arkansas", "California", "Colorado", "Connecticut", "Delaware", "Florida", "Georgia", "Hawaii", "Idaho", "Illinois", "Indiana", "Iowa", "Kansas", "Kentucky", "Louisiana", "Maine", "Maryland", "Massachusetts", "Michigan", "Minnesota", "Mississippi", "Missouri", "Montana", "Nebraska", "Nevada", "New Hampshire", "New Jersey", "New Mexico", "New York", "North Carolina", "North Dakota", "Ohio", "Oklahoma", "Oregon", "Pennsylvania", "Rhode Island", "South Carolina", "South Dakota", "Tennessee", "Texas", "Utah", "Vermont", "Virginia", "Washington", "West Virginia", "Wisconsin", "Wyoming");

    @Override
    public void initialize(PlugInContext context) throws Exception {
        context.getFeatureInstaller().addLayerViewMenuItem((PlugIn)this, new String[]{MenuNames.TOOLS, MenuNames.TOOLS_GENERATE}, this.getName());
    }

    @Override
    public boolean execute(PlugInContext context) throws ParseException, IOException {
        return this.execute(context, 50);
    }

    public boolean execute(PlugInContext context, int layerSize) throws ParseException, IOException {
        int n = 1;
        for (int i = 0; i < n; ++i) {
            this.generateLayer(context, layerSize);
        }
        return true;
    }

    private void generateLayer(PlugInContext context, int size) throws ParseException, IOException {
        FeatureSchema featureSchema = new FeatureSchema();
        featureSchema.addAttribute("Geometry", AttributeType.GEOMETRY);
        featureSchema.addAttribute("City", AttributeType.STRING);
        featureSchema.addAttribute("A_Date", AttributeType.DATE);
        featureSchema.addAttribute("B_Integer", AttributeType.INTEGER);
        featureSchema.addAttribute("C_Double", AttributeType.DOUBLE);
        featureSchema.addAttribute("D_Long", AttributeType.LONG);
        featureSchema.addAttribute("E_Boolean", AttributeType.BOOLEAN);
        featureSchema.addAttribute("F_Code", AttributeType.STRING);
        featureSchema.addAttribute("G_Code", AttributeType.STRING);
        featureSchema.addAttribute("H_Code", AttributeType.STRING);
        featureSchema.addAttribute("I_Code", AttributeType.STRING);
        featureSchema.addAttribute("J_Code", AttributeType.STRING);
        featureSchema.addAttribute("K_Code", AttributeType.STRING);
        featureSchema.addAttribute("L_Code", AttributeType.STRING);
        featureSchema.addAttribute("M_Code", AttributeType.STRING);
        featureSchema.addAttribute("N_Code", AttributeType.STRING);
        featureSchema.addAttribute("O_Code", AttributeType.STRING);
        featureSchema.addAttribute("P_Code", AttributeType.STRING);
        FeatureDataset featureCollection = new FeatureDataset(featureSchema);
        this.addFeature(this.cornerSquare(), featureCollection);
        for (int i = 0; i < size; ++i) {
            this.addFeature(this.randomTriangle(), featureCollection);
        }
        Layer layer = context.addLayer(StandardCategoryNames.WORKING, I18N.getInstance().get("ui.test.RandomTriangle.random-triangles"), featureCollection);
        layer.setDescription("ABCDE");
    }

    private Geometry cornerSquare() throws ParseException {
        return this.wktReader.read("POLYGON ((-50 -50, 50 -50, 50 50, -50 50, -50 -50))");
    }

    private void addFeature(Geometry geometry, FeatureCollection featureCollection) {
        BasicFeature feature = new BasicFeature(featureCollection.getFeatureSchema());
        feature.setAttribute("Geometry", (Object)geometry);
        feature.setAttribute("City", this.cities.get((int)Math.floor(Math.random() * (double)this.cities.size())));
        feature.setAttribute("A_Date", (Object)new Date());
        feature.setAttribute("B_Integer", (Object)((int)(Math.random() * 100000.0)));
        feature.setAttribute("C_Double", (Object)(Math.random() * 100000.0));
        feature.setAttribute("D_Long", (Object)((long)(Math.random() * 1.0E12)));
        feature.setAttribute("E_Boolean", (Object)(Math.random() > 0.5 ? 1 : 0));
        feature.setAttribute("F_Code", (Object)("" + (int)(Math.random() * 100000.0)));
        feature.setAttribute("G_Code", (Object)("" + (int)(Math.random() * 100000.0)));
        feature.setAttribute("H_Code", (Object)("" + (int)(Math.random() * 100000.0)));
        feature.setAttribute("I_Code", (Object)("" + (int)(Math.random() * 100000.0)));
        feature.setAttribute("J_Code", (Object)("" + (int)(Math.random() * 100000.0)));
        feature.setAttribute("K_Code", (Object)("" + (int)(Math.random() * 100000.0)));
        feature.setAttribute("L_Code", (Object)("" + (int)(Math.random() * 100000.0)));
        feature.setAttribute("M_Code", (Object)("" + (int)(Math.random() * 100000.0)));
        feature.setAttribute("N_Code", (Object)("" + (int)(Math.random() * 100000.0)));
        feature.setAttribute("O_Code", (Object)("" + (int)(Math.random() * 100000.0)));
        feature.setAttribute("P_Code", (Object)("" + (int)(Math.random() * 100000.0)));
        if (Math.random() > 0.8) {
            feature.setAttribute("E_Boolean", null);
        }
        if (Math.random() > 0.8) {
            feature.setAttribute("F_Code", null);
        }
        featureCollection.add(feature);
    }

    private Geometry randomTriangle() {
        int perturbation = 30;
        int x = (int)(Math.random() * 700.0);
        int y = (int)(Math.random() * 700.0);
        Coordinate firstPoint = this.perturbedPoint(x, y, perturbation);
        return this.geometryFactory.createPolygon(this.geometryFactory.createLinearRing(new Coordinate[]{firstPoint, this.perturbedPoint(x, y, perturbation), this.perturbedPoint(x, y, perturbation), firstPoint}), null);
    }

    private Coordinate perturbedPoint(int x, int y, int perturbation) {
        return new Coordinate((double)x + Math.random() * (double)perturbation, (double)y + Math.random() * (double)perturbation);
    }

    public void setCities(List cities) {
        this.cities = cities;
    }
}

