/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.test;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.BasicFeature;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.geom.CoordUtil;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.StandardCategoryNames;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.PlugIn;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.renderer.style.ArrowLineStringEndpointStyle;
import java.util.ArrayList;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;

public class RandomArrowsPlugIn
extends AbstractPlugIn {
    private static final int FEATURE_COUNT = 20;
    private static final double LAYER_SIDE_LENGTH = 100.0;
    private static final int MAX_SEGMENT_COUNT = 3;
    private static final double MAX_SEGMENT_LENGTH = 20.0;
    private GeometryFactory geometryFactory = new GeometryFactory();

    @Override
    public void initialize(PlugInContext context) throws Exception {
        context.getFeatureInstaller().addLayerViewMenuItem((PlugIn)this, new String[]{MenuNames.TOOLS, MenuNames.TOOLS_GENERATE}, this.getName());
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        FeatureSchema schema = new FeatureSchema();
        schema.addAttribute("GEOMETRY", AttributeType.GEOMETRY);
        FeatureDataset dataset = new FeatureDataset(schema);
        for (int i = 0; i < 20; ++i) {
            dataset.add(this.createFeature(schema));
        }
        this.addLayer(dataset, context);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addLayer(FeatureCollection featureCollection, PlugInContext context) {
        Layer layer = new Layer(I18N.getInstance().get("ui.test.RandomArrowsPlugIn.random-arrows"), context.getLayerManager().generateLayerFillColor(), featureCollection, context.getLayerManager());
        boolean firingEvents = context.getLayerManager().isFiringEvents();
        context.getLayerManager().setFiringEvents(false);
        try {
            layer.addStyle(new ArrowLineStringEndpointStyle.NarrowSolidEnd());
        }
        finally {
            context.getLayerManager().setFiringEvents(firingEvents);
        }
        context.getLayerManager().addLayer(StandardCategoryNames.WORKING, layer);
    }

    private Feature createFeature(FeatureSchema schema) {
        ArrayList<Coordinate> coordinates = new ArrayList<Coordinate>();
        coordinates.add(CoordUtil.add(new Coordinate(50.0, 50.0), this.randomCoordinate(50.0)));
        int walkMax = (int)Math.ceil(Math.random() * 20.0);
        int segmentCount = (int)Math.ceil(Math.random() * 3.0);
        for (int i = 0; i < segmentCount; ++i) {
            Coordinate prevCoordinate = (Coordinate)coordinates.get(coordinates.size() - 1);
            coordinates.add(CoordUtil.add(prevCoordinate, this.randomCoordinate(walkMax)));
        }
        LineString lineString = this.geometryFactory.createLineString(coordinates.toArray(new Coordinate[0]));
        BasicFeature feature = new BasicFeature(schema);
        feature.setGeometry((Geometry)lineString);
        return feature;
    }

    private Coordinate randomCoordinate(double walkMax) {
        return CoordUtil.add(new Coordinate(-walkMax / 2.0, -walkMax / 2.0), new Coordinate(Math.random() * walkMax, Math.random() * walkMax));
    }
}

