/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.analysis;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureCollectionWrapper;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.tools.AttributeMapping;
import com.vividsolutions.jump.tools.OverlayEngine;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.StandardCategoryNames;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.plugin.ThreadedPlugIn;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import com.vividsolutions.jump.workbench.ui.plugin.FeatureInstaller;

public class OverlayPlugIn
extends AbstractPlugIn
implements ThreadedPlugIn {
    private String POLYGON_OUTPUT;
    private String FIRST_LAYER;
    private String SECOND_LAYER;
    private String TRANSFER_ATTRIBUTES_FROM_FIRST_LAYER;
    private String TRANSFER_ATTRIBUTES_FROM_SECOND_LAYER;
    private MultiInputDialog dialog;
    private OverlayEngine overlayEngine;
    private String categoryName = StandardCategoryNames.RESULT;

    public void setCategoryName(String value) {
        this.categoryName = value;
    }

    @Override
    public void initialize(PlugInContext context) throws Exception {
        super.initialize(context);
        FeatureInstaller featureInstaller = context.getFeatureInstaller();
        featureInstaller.addMainMenuPlugin(this, new String[]{MenuNames.TOOLS, MenuNames.TOOLS_ANALYSIS}, this.getName() + "...", false, null, OverlayPlugIn.createEnableCheck(context.getWorkbenchContext()));
    }

    public static MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerNamePanelMustBeActiveCheck()).add(checkFactory.createAtLeastNLayersMustExistCheck(2));
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        this.POLYGON_OUTPUT = I18N.getInstance().get("ui.plugin.analysis.OverlayPlugIn.limit-output-to-polygons-only");
        this.FIRST_LAYER = I18N.getInstance().get("ui.plugin.analysis.OverlayPlugIn.first-layer");
        this.SECOND_LAYER = I18N.getInstance().get("ui.plugin.analysis.OverlayPlugIn.second-layer");
        this.TRANSFER_ATTRIBUTES_FROM_FIRST_LAYER = I18N.getInstance().get("ui.plugin.analysis.OverlayPlugIn.transfer-attributes-from-first-layer");
        this.TRANSFER_ATTRIBUTES_FROM_SECOND_LAYER = I18N.getInstance().get("ui.plugin.analysis.OverlayPlugIn.transfer-attributes-from-second-layer");
        this.overlayEngine = this.prompt(context);
        return this.overlayEngine != null;
    }

    private OverlayEngine prompt(PlugInContext context) {
        this.initDialog(context);
        this.dialog.setVisible(true);
        if (!this.dialog.wasOKPressed()) {
            return null;
        }
        OverlayEngine e = new OverlayEngine();
        e.setAllowingPolygonsOnly(this.dialog.getBoolean(this.POLYGON_OUTPUT));
        e.setSplittingGeometryCollections(this.dialog.getBoolean(this.POLYGON_OUTPUT));
        return e;
    }

    private void initDialog(PlugInContext context) {
        this.dialog = new MultiInputDialog(context.getWorkbenchFrame(), this.getName(), true);
        this.dialog.setSideBarImage(IconLoader.icon("Overlay.gif"));
        this.dialog.setSideBarDescription(I18N.getInstance().get("ui.plugin.analysis.OverlayPlugIn.create-new-layer-containing-intersections-of-all-pairs-of-input-features"));
        String fieldName = this.FIRST_LAYER;
        this.dialog.addLayerComboBox(fieldName, context.getCandidateLayer(0), null, context.getLayerManager());
        String fieldName1 = this.SECOND_LAYER;
        this.dialog.addLayerComboBox(fieldName1, context.getCandidateLayer(1), null, context.getLayerManager());
        this.dialog.addCheckBox(this.POLYGON_OUTPUT, true, I18N.getInstance().get("ui.plugin.analysis.OverlayPlugIn.splits-multipolygons-and-geometry-and-filters-out-non-polygons"));
        this.dialog.addCheckBox(this.TRANSFER_ATTRIBUTES_FROM_FIRST_LAYER, true);
        this.dialog.addCheckBox(this.TRANSFER_ATTRIBUTES_FROM_SECOND_LAYER, true);
        GUIUtil.centreOnWindow(this.dialog);
    }

    @Override
    public void run(TaskMonitor monitor, PlugInContext context) throws Exception {
        FeatureCollectionWrapper a = this.dialog.getLayer(this.FIRST_LAYER).getFeatureCollectionWrapper();
        FeatureCollectionWrapper b = this.dialog.getLayer(this.SECOND_LAYER).getFeatureCollectionWrapper();
        FeatureCollection overlay = this.overlayEngine.overlay(a, b, this.mapping(a, b), monitor);
        context.getLayerManager().addCategory(this.categoryName);
        context.addLayer(this.categoryName, I18N.getInstance().get("ui.plugin.analysis.OverlayPlugIn.overlay"), overlay);
    }

    private AttributeMapping mapping(FeatureCollection a, FeatureCollection b) {
        return new AttributeMapping(this.dialog.getBoolean(this.TRANSFER_ATTRIBUTES_FROM_FIRST_LAYER) ? a.getFeatureSchema() : new FeatureSchema(), this.dialog.getBoolean(this.TRANSFER_ATTRIBUTES_FROM_SECOND_LAYER) ? b.getFeatureSchema() : new FeatureSchema());
    }
}

