/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.util.Blackboard;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.CategoryEvent;
import com.vividsolutions.jump.workbench.model.FeatureEvent;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerEvent;
import com.vividsolutions.jump.workbench.model.LayerEventType;
import com.vividsolutions.jump.workbench.model.LayerListener;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.model.LayerManagerProxy;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.CloneableInternalFrame;
import com.vividsolutions.jump.workbench.ui.InfoFrame;
import com.vividsolutions.jump.workbench.ui.LayerNamePanel;
import com.vividsolutions.jump.workbench.ui.LayerNamePanelProxy;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.LayerViewPanelProxy;
import com.vividsolutions.jump.workbench.ui.OneLayerAttributeTab;
import com.vividsolutions.jump.workbench.ui.SelectionManager;
import com.vividsolutions.jump.workbench.ui.SelectionManagerProxy;
import com.vividsolutions.jump.workbench.ui.TaskFrame;
import com.vividsolutions.jump.workbench.ui.TaskFrameProxy;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import org.locationtech.jts.util.Assert;
import org.openjump.core.ui.swing.DetachableInternalFrame;

public class ViewAttributesPlugIn
extends AbstractPlugIn {
    public static final String BB_ATTRIBUTES_WINDOW_SIZE_WIDTH = ViewAttributesPlugIn.class.getName() + " - ATTRIBUTES_WINDOW_SIZE_WIDTH";
    public static final String BB_ATTRIBUTES_WINDOW_SIZE_HEIGHT = ViewAttributesPlugIn.class.getName() + " - ATTRIBUTES_WINDOW_SIZE_HEIGHT";
    public static final String BB_ATTRIBUTES_WINDOW_POSITION_X = ViewAttributesPlugIn.class.getName() + " - ATTRIBUTES_WINDOW_POSITION_X";
    public static final String BB_ATTRIBUTES_WINDOW_POSITION_Y = ViewAttributesPlugIn.class.getName() + " - ATTRIBUTES_WINDOW_POSITION_Y";
    private static Blackboard blackboard = null;

    @Override
    public void initialize(PlugInContext context) throws Exception {
        super.initialize(context);
        blackboard = PersistentBlackboardPlugIn.get(context.getWorkbenchContext());
    }

    @Override
    public String getName() {
        return I18N.getInstance().get("ui.plugin.ViewAttributesPlugIn.view-edit-attributes");
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        this.reportNothingToUndoYet(context);
        for (JInternalFrame iFrame : context.getWorkbenchFrame().getInternalFrames()) {
            if (!(iFrame instanceof ViewAttributesFrame) || !((ViewAttributesFrame)iFrame).getOneLayerAttributeTab().getLayer().equals(context.getSelectedLayer(0))) continue;
            iFrame.toFront();
            return true;
        }
        ViewAttributesFrame frame = new ViewAttributesFrame(context.getSelectedLayer(0), context);
        frame.setSize(500, 300);
        context.getWorkbenchFrame().addInternalFrame(frame);
        if (blackboard.get(BB_ATTRIBUTES_WINDOW_POSITION_X) != null) {
            int x = blackboard.getInt(BB_ATTRIBUTES_WINDOW_POSITION_X);
            int y = blackboard.getInt(BB_ATTRIBUTES_WINDOW_POSITION_Y);
            int width = blackboard.getInt(BB_ATTRIBUTES_WINDOW_SIZE_WIDTH);
            int height = blackboard.getInt(BB_ATTRIBUTES_WINDOW_SIZE_HEIGHT);
            frame.setBounds(x, y, width, height);
        }
        return true;
    }

    public MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createTaskWindowMustBeActiveCheck()).add(checkFactory.createExactlyNLayersMustBeSelectedCheck(1));
    }

    @Override
    public ImageIcon getIcon() {
        return IconLoader.icon("Row.gif");
    }

    public static class ViewAttributesFrame
    extends DetachableInternalFrame
    implements LayerManagerProxy,
    SelectionManagerProxy,
    LayerNamePanelProxy,
    TaskFrameProxy,
    LayerViewPanelProxy {
        private final LayerManager layerManager;
        private final OneLayerAttributeTab attributeTab;
        private static final ImageIcon ICON12 = IconLoader.icon("Row_14.gif");
        private static final ImageIcon ICON16 = IconLoader.icon("Row_16.gif");

        public ViewAttributesFrame(Layer layer, final PlugInContext context) {
            this.layerManager = context.getLayerManager();
            this.addInternalFrameListener(new InternalFrameAdapter(){

                @Override
                public void internalFrameClosed(InternalFrameEvent e) {
                    attributeTab.getModel().dispose();
                    blackboard.put(BB_ATTRIBUTES_WINDOW_SIZE_WIDTH, this.getSize().width);
                    blackboard.put(BB_ATTRIBUTES_WINDOW_SIZE_HEIGHT, this.getSize().height);
                    blackboard.put(BB_ATTRIBUTES_WINDOW_POSITION_X, this.getLocation().x);
                    blackboard.put(BB_ATTRIBUTES_WINDOW_POSITION_Y, this.getLocation().y);
                }
            });
            this.setResizable(true);
            this.setClosable(true);
            this.setMaximizable(true);
            this.setIconifiable(true);
            this.setFrameIcon(ICON12);
            this.getContentPane().setLayout(new BorderLayout());
            this.attributeTab = new OneLayerAttributeTab(context.getWorkbenchContext(), ((TaskFrameProxy)((Object)context.getActiveInternalFrame())).getTaskFrame(), this).setLayer(layer);
            this.getContentPane().add((Component)this.attributeTab, "Center");
            this.updateTitle(this.attributeTab.getLayer());
            final LayerListener layerListener = new LayerListener(){

                @Override
                public void layerChanged(LayerEvent e) {
                    if (attributeTab.getLayer() != null) {
                        this.updateTitle(attributeTab.getLayer());
                    }
                    if (e.getType() == LayerEventType.REMOVED && e.getLayerable() == attributeTab.getLayer()) {
                        attributeTab.getModel().dispose();
                        context.getWorkbenchFrame().removeInternalFrame(this);
                        this.dispose();
                    }
                }

                @Override
                public void categoryChanged(CategoryEvent e) {
                }

                @Override
                public void featuresChanged(FeatureEvent e) {
                }
            };
            context.getLayerManager().addLayerListener(layerListener);
            this.addInternalFrameListener(new InternalFrameAdapter(){

                @Override
                public void internalFrameOpened(InternalFrameEvent e) {
                    attributeTab.getToolBar().updateEnabledState();
                }

                @Override
                public void internalFrameClosed(InternalFrameEvent e) {
                    context.getLayerManager().removeLayerListener(layerListener);
                    context.getLayerManager().removeLayerListener(((ViewAttributesFrame)this).attributeTab.attributeTabLayerListener);
                    context.getLayerManager().removeLayerListener(((ViewAttributesFrame)this).attributeTab.oneAttributeTableLayerListener);
                }
            });
            Assert.isTrue((!(this instanceof CloneableInternalFrame) ? 1 : 0) != 0, (String)I18N.getInstance().get("ui.plugin.ViewAttributesPlugIn.there-can-be-no-other-views-on-the-InfoModels"));
        }

        public OneLayerAttributeTab getOneLayerAttributeTab() {
            return this.attributeTab;
        }

        @Override
        public LayerViewPanel getLayerViewPanel() {
            return this.getTaskFrame().getLayerViewPanel();
        }

        @Override
        public LayerManager getLayerManager() {
            return this.layerManager;
        }

        private void updateTitle(Layer layer) {
            if (layer.isEditable()) {
                String editView = I18N.getInstance().get("ui.plugin.ViewAttributesPlugIn.edit");
            } else {
                String editView = I18N.getInstance().get("ui.plugin.ViewAttributesPlugIn.view");
            }
            this.setTitle(" " + I18N.getInstance().get("ui.plugin.ViewAttributesPlugIn.attributes") + ": " + this.getTaskFrame().getTask().getName() + ":" + layer.getName());
        }

        @Override
        public TaskFrame getTaskFrame() {
            return this.attributeTab.getTaskFrame();
        }

        @Override
        public SelectionManager getSelectionManager() {
            return this.attributeTab.getPanel().getSelectionManager();
        }

        @Override
        public LayerNamePanel getLayerNamePanel() {
            return this.attributeTab;
        }

        @Override
        public JFrame getFrame() {
            InfoFrame.DetachableInternalFrameWithProxies f = new InfoFrame.DetachableInternalFrameWithProxies(this);
            f.setIconImage(ICON16.getImage());
            return f;
        }
    }
}

