/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin;

import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.InfoFrame;
import com.vividsolutions.jump.workbench.ui.SelectionManager;
import com.vividsolutions.jump.workbench.ui.SelectionManagerProxy;
import com.vividsolutions.jump.workbench.ui.TaskFrame;
import com.vividsolutions.jump.workbench.ui.TaskFrameProxy;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import java.util.Iterator;
import javax.swing.ImageIcon;

public class UniqueFeatureInfoPlugIn
extends AbstractPlugIn {
    private static EnableCheck checker = null;
    public static final ImageIcon ICON = IconLoader.icon("information_16x16.png");

    public UniqueFeatureInfoPlugIn() {
        this.setShortcutKeys(73);
        this.setShortcutModifiers(8);
    }

    public static EnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        if (checker == null) {
            EnableCheckFactory checkFactory = EnableCheckFactory.getInstance(workbenchContext);
            checker = new MultiEnableCheck().add(checkFactory.createWindowWithSelectionManagerMustBeActiveCheck()).add(checkFactory.createWindowWithLayerManagerMustBeActiveCheck()).add(checkFactory.createWindowWithAssociatedTaskFrameMustBeActiveCheck()).add(checkFactory.createAtLeastNItemsMustBeSelectedCheck(1));
        }
        return checker;
    }

    @Override
    public void initialize(PlugInContext context) throws Exception {
        super.initialize(context);
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        this.reportNothingToUndoYet(context);
        TaskFrame taskFrame = ((TaskFrameProxy)((Object)context.getActiveInternalFrame())).getTaskFrame();
        InfoFrame infoFrame = taskFrame.getInfoFrame();
        SelectionManager selectionManager = ((SelectionManagerProxy)((Object)context.getActiveInternalFrame())).getSelectionManager();
        infoFrame.getModel().clear();
        Iterator<Layer> i = context.getLayerManager().iterator(Layer.class);
        while (i.hasNext()) {
            Layer layer = i.next();
            if (selectionManager.getFeaturesWithSelectedItems(layer).isEmpty()) continue;
            infoFrame.getModel().add(layer, selectionManager.getFeaturesWithSelectedItems(layer));
        }
        infoFrame.surface();
        return true;
    }
}

