/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin;

import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.BasicFeature;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.StandardCategoryNames;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.plugin.FeatureInstaller;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.Polygon;

public class FeatureStatisticsPlugIn
extends AbstractPlugIn {
    private static final String nPtsAttr = "nPts";
    private static final String nHolesAttr = "nHoles";
    private static final String nCompsAttr = "nComponents";
    private static final String areaAttr = "area";
    private static final String lengthAttr = "length";
    private static final String typeAttr = "type";

    @Override
    public void initialize(PlugInContext context) throws Exception {
        super.initialize(context);
        FeatureInstaller featureInstaller = context.getFeatureInstaller();
        featureInstaller.addMainMenuPlugin(this, new String[]{MenuNames.TOOLS, MenuNames.STATISTICS}, this.getName() + "...", false, null, FeatureStatisticsPlugIn.createEnableCheck(context.getWorkbenchContext()));
    }

    public static MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithAssociatedTaskFrameMustBeActiveCheck()).add(checkFactory.createAtLeastNLayersMustExistCheck(1));
    }

    private static FeatureSchema getStatisticsSchema() {
        FeatureSchema featureSchema = new FeatureSchema();
        featureSchema.addAttribute("GEOMETRY", AttributeType.GEOMETRY);
        featureSchema.addAttribute(nPtsAttr, AttributeType.INTEGER);
        featureSchema.addAttribute(nHolesAttr, AttributeType.INTEGER);
        featureSchema.addAttribute(nCompsAttr, AttributeType.INTEGER);
        featureSchema.addAttribute(areaAttr, AttributeType.DOUBLE);
        featureSchema.addAttribute(lengthAttr, AttributeType.DOUBLE);
        featureSchema.addAttribute(typeAttr, AttributeType.STRING);
        return featureSchema;
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        Layer[] selectedLayers;
        for (Layer selectedLayer : selectedLayers = context.getSelectedLayers()) {
            this.featureStatistics(selectedLayer, context);
        }
        return true;
    }

    private void featureStatistics(Layer layer, PlugInContext context) {
        FeatureSchema statsSchema = FeatureStatisticsPlugIn.getStatisticsSchema();
        FeatureDataset statsFC = new FeatureDataset(statsSchema);
        for (Feature feature : layer.getFeatureCollectionWrapper().getFeatures()) {
            Geometry g = feature.getGeometry();
            int[] comps_and_holes = new int[]{0, 0};
            comps_and_holes = this.recurse(g, comps_and_holes);
            BasicFeature statsf = new BasicFeature(statsSchema);
            statsf.setAttribute("GEOMETRY", (Object)g);
            statsf.setAttribute(nPtsAttr, (Object)g.getCoordinates().length);
            statsf.setAttribute(nCompsAttr, (Object)comps_and_holes[0]);
            statsf.setAttribute(nHolesAttr, (Object)comps_and_holes[1]);
            statsf.setAttribute(areaAttr, (Object)g.getArea());
            statsf.setAttribute(lengthAttr, (Object)g.getLength());
            statsf.setAttribute(typeAttr, (Object)g.getGeometryType());
            statsFC.add(statsf);
        }
        Layer statsLayer = context.addLayer(StandardCategoryNames.QA, "Statistics-" + layer.getName(), statsFC);
        statsLayer.setStyles(layer.cloneStyles());
    }

    private int[] recurse(Geometry g, int[] comps_holes) {
        if (g instanceof GeometryCollection) {
            for (int i = 0; i < g.getNumGeometries(); ++i) {
                comps_holes = this.recurse(g.getGeometryN(i), comps_holes);
            }
        } else {
            comps_holes[0] = comps_holes[0] + 1;
            if (g instanceof Polygon) {
                comps_holes[1] = comps_holes[1] + ((Polygon)g).getNumInteriorRing();
            }
        }
        return comps_holes;
    }
}

