/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin;

import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.util.StringUtil;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.EditTransaction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import org.locationtech.jts.geom.GeometryCollection;
import org.openjump.core.ui.images.IconLoader;

public class ExplodeSelectedFeaturesPlugIn
extends AbstractPlugIn {
    public static ImageIcon ICON = IconLoader.icon("features_explode.png");

    public ExplodeSelectedFeaturesPlugIn() {
        this.setShortcutKeys(71);
        this.setShortcutModifiers(3);
    }

    @Override
    public void initialize(PlugInContext context) throws Exception {
        super.initialize(context);
    }

    @Override
    public boolean execute(final PlugInContext context) throws Exception {
        final ArrayList<EditTransaction> transactions = new ArrayList<EditTransaction>();
        for (Layer layerWithSelectedItems : context.getLayerViewPanel().getSelectionManager().getLayersWithSelectedItems()) {
            transactions.add(this.createTransaction(layerWithSelectedItems, context));
        }
        return EditTransaction.commit(transactions, new EditTransaction.SuccessAction(){

            @Override
            public void run() {
                for (EditTransaction transaction : transactions) {
                    context.getLayerViewPanel().getSelectionManager().getFeatureSelection().selectItems(transaction.getLayer(), ExplodeSelectedFeaturesPlugIn.this.newFeatures(transaction));
                }
            }
        });
    }

    private Collection newFeatures(EditTransaction transaction) {
        ArrayList<Feature> newFeatures = new ArrayList<Feature>();
        for (Feature f : transaction.getFeatures()) {
            if (transaction.getGeometry(f).isEmpty()) continue;
            newFeatures.add(f);
        }
        return newFeatures;
    }

    private EditTransaction createTransaction(Layer layer, PlugInContext context) {
        Collection<Feature> intactFeatures = context.getLayerViewPanel().getSelectionManager().getFeaturesWithSelectedItems(layer);
        EditTransaction transaction = new EditTransaction(new ArrayList<Feature>(), this.getName(), layer, this.isRollingBackInvalidEdits(context), true, context.getLayerViewPanel());
        for (Feature intactFeature : intactFeatures) {
            transaction.deleteFeature(intactFeature);
        }
        for (Feature explodedFeature : this.explode(intactFeatures)) {
            transaction.createFeature(explodedFeature);
        }
        return transaction;
    }

    private List explode(Collection features) {
        ArrayList<Feature> explodedFeatures = new ArrayList<Feature>();
        for (Feature feature : features) {
            GeometryCollection collection = (GeometryCollection)feature.getGeometry();
            for (int j = 0; j < collection.getNumGeometries(); ++j) {
                Feature explodedFeature = feature.clone(false);
                explodedFeature.setGeometry(collection.getGeometryN(j));
                explodedFeatures.add(explodedFeature);
            }
        }
        return explodedFeatures;
    }

    public MultiEnableCheck createEnableCheck(final WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerViewPanelMustBeActiveCheck()).add(checkFactory.createAtLeastNFeaturesMustHaveSelectedItemsCheck(1)).add(checkFactory.createSelectedItemsLayersMustBeEditableCheck()).add(new EnableCheck(){

            @Override
            public String check(JComponent component) {
                Collection<Feature> featuresWithSelectedItems = workbenchContext.getLayerViewPanel().getSelectionManager().getFeaturesWithSelectedItems();
                for (Feature feature : featuresWithSelectedItems) {
                    if (feature.getGeometry() instanceof GeometryCollection) continue;
                    return "Selected feature" + StringUtil.s(featuresWithSelectedItems.size()) + " must be geometry collection" + StringUtil.s(featuresWithSelectedItems.size());
                }
                return null;
            }
        });
    }

    @Override
    public ImageIcon getIcon() {
        return ICON;
    }
}

