/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.workbench.model.Category;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.model.StandardCategoryNames;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.EditOptionsPanel;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.EditingPlugIn;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import java.util.Collection;
import javax.swing.Icon;

public class AddNewLayerPlugIn
extends AbstractPlugIn {
    public final Icon ICON = IconLoader.icon("famfam/page_white_add.png");

    public AddNewLayerPlugIn() {
        this.setShortcutKeys(76);
        this.setShortcutModifiers(2);
    }

    public static FeatureCollection createBlankFeatureCollection() {
        FeatureSchema featureSchema = new FeatureSchema();
        featureSchema.addAttribute("GEOMETRY", AttributeType.GEOMETRY);
        return new FeatureDataset(featureSchema);
    }

    @Override
    public void initialize(PlugInContext context) throws Exception {
        super.initialize(context);
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        this.reportNothingToUndoYet(context);
        Collection<Category> selectedCategories = context.getLayerNamePanel().getSelectedCategories();
        Layer layer = context.addLayer(selectedCategories.isEmpty() ? StandardCategoryNames.WORKING : ((Object)selectedCategories.iterator().next()).toString(), I18N.getInstance().get("ui.plugin.AddNewLayerPlugIn.new"), AddNewLayerPlugIn.createBlankFeatureCollection());
        layer.setFeatureCollectionModified(false);
        if (PersistentBlackboardPlugIn.get(context.getWorkbenchContext()).get(EditOptionsPanel.SINGLE_EDITABLE_LAYER_KEY, false)) {
            this.setAllLayersToUneditable(context);
        }
        layer.setEditable(true);
        ((EditingPlugIn)context.getWorkbenchContext().getBlackboard().get(EditingPlugIn.KEY)).getToolbox(context.getWorkbenchContext()).setVisible(true);
        return true;
    }

    private void setAllLayersToUneditable(PlugInContext context) {
        for (Layerable object : context.getLayerNamePanel().getLayerManager().getLayerables(Layerable.class)) {
            object.setEditable(false);
        }
    }

    @Override
    public EnableCheck getEnableCheck() {
        return EnableCheckFactory.getInstance(this.getWorkbenchContext()).createWindowWithLayerViewPanelMustBeActiveCheck();
    }
}

