/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import javax.swing.Icon;

public class AddNewCategoryPlugIn
extends AbstractPlugIn {
    private static final String NEW_CATEGORY_NAME = I18N.getInstance().get("ui.plugin.AbstractNewCategoryPlugIn.new-category");

    public AddNewCategoryPlugIn() {
        this.setShortcutKeys(76);
        this.setShortcutModifiers(3);
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        this.reportNothingToUndoYet(context);
        String categoryName = this.findNewCategoryName(context.getLayerManager());
        context.getLayerManager().addCategory(categoryName);
        return true;
    }

    private String findNewCategoryName(LayerManager layerManager) {
        String newName;
        if (layerManager.getCategory(NEW_CATEGORY_NAME) == null) {
            return NEW_CATEGORY_NAME;
        }
        int i = 2;
        do {
            newName = NEW_CATEGORY_NAME + " (" + i + ")";
            ++i;
        } while (layerManager.getCategory(newName) != null);
        return newName;
    }

    public EnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        return EnableCheckFactory.getInstance(workbenchContext).createWindowWithLayerViewPanelMustBeActiveCheck();
    }

    @Override
    public Icon getIcon() {
        return IconLoader.icon("fugue/folder--plus.png");
    }
}

