/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.cursortool;

import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.cursortool.AbstractCursorTool;
import com.vividsolutions.jump.workbench.ui.cursortool.CoordinateListMetrics;
import java.awt.Point;
import java.awt.Shape;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.geom.GeneralPath;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.util.Assert;

public abstract class MultiClickTool
extends AbstractCursorTool {
    private final List<Coordinate> coordinates = new ArrayList<Coordinate>();
    private Coordinate tentativeCoordinate;
    private boolean closeRing = false;
    private CoordinateListMetrics metrics = null;
    protected Point mouseLastLoc;
    private final KeyListener keyListener = new KeyListener(){

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
            if (!AbstractCursorTool.componentWithFocusIsHandledByCursorTools()) {
                return;
            }
            if (e.getKeyCode() == 8) {
                if (MultiClickTool.this.coordinates.size() > 1) {
                    int rem = MultiClickTool.this.coordinates.size() - 1;
                    MultiClickTool.this.coordinates.remove(rem);
                    try {
                        MultiClickTool.this.redrawShape();
                    }
                    catch (Throwable t) {
                        MultiClickTool.this.getPanel().getContext().handleThrowable(t);
                    }
                } else {
                    MultiClickTool.this.cancelGesture();
                }
            } else if (e.getKeyCode() == 27) {
                MultiClickTool.this.cancelGesture();
            } else if (e.getKeyCode() == 10 && MultiClickTool.this.mouseLastLoc != null) {
                MultiClickTool.this.mousePressed(new MouseEvent(MultiClickTool.this.panel, 501, 0L, 16, MultiClickTool.this.mouseLastLoc.x, MultiClickTool.this.mouseLastLoc.y, 1, false));
                MultiClickTool.this.mouseReleased(new MouseEvent(MultiClickTool.this.panel, 502, 0L, 16, MultiClickTool.this.mouseLastLoc.x, MultiClickTool.this.mouseLastLoc.y, 2, false));
            }
        }
    };

    public MultiClickTool(WorkbenchContext context) {
        super(context);
    }

    protected void setMetricsDisplay(CoordinateListMetrics metrics) {
        this.metrics = metrics;
    }

    protected CoordinateListMetrics getMetrics() {
        return this.metrics;
    }

    protected void setCloseRing(boolean closeRing) {
        this.closeRing = closeRing;
    }

    public List<Coordinate> getCoordinates() {
        return Collections.unmodifiableList(this.coordinates);
    }

    @Override
    public void cancelGesture() {
        super.cancelGesture();
        this.coordinates.clear();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        try {
            if (e.getClickCount() == 1) {
                this.tentativeCoordinate = this.snap(e.getPoint());
                this.redrawShape();
            }
            super.mouseReleased(e);
            if (this.isFinishingRelease(e)) {
                this.finishGesture();
            }
        }
        catch (Throwable t) {
            this.getPanel().getContext().handleThrowable(t);
        }
    }

    protected void mouseLocationChanged(MouseEvent e) {
        try {
            if (this.coordinates.isEmpty()) {
                return;
            }
            this.mouseLastLoc = e.getPoint();
            this.tentativeCoordinate = this.snap(e.getPoint());
            this.redrawShape();
            this.displayMetrics(e);
        }
        catch (Throwable t) {
            this.getPanel().getContext().handleThrowable(t);
        }
    }

    private void displayMetrics(MouseEvent e) throws NoninvertibleTransformException {
        if (this.metrics == null) {
            return;
        }
        if (this.isShapeOnScreen()) {
            ArrayList<Coordinate> currentCoordinates = new ArrayList<Coordinate>(this.getCoordinates());
            currentCoordinates.add(this.snap(this.getPanel().getViewport().toModelCoordinate(e.getPoint())));
            this.metrics.displayMetrics(currentCoordinates, this.getPanel());
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.mouseLocationChanged(e);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.mouseLocationChanged(e);
    }

    protected void add(Coordinate c) {
        this.coordinates.add(c);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        try {
            super.mousePressed(e);
            Assert.isTrue((e.getClickCount() > 0 ? 1 : 0) != 0);
            if (e.getClickCount() != 1) {
                return;
            }
            this.add(this.snap(e.getPoint()));
        }
        catch (Throwable t) {
            this.getPanel().getContext().handleThrowable(t);
        }
    }

    @Override
    protected Shape getShape() throws NoninvertibleTransformException {
        GeneralPath path = new GeneralPath();
        if (!this.coordinates.isEmpty()) {
            Point2D firstPoint = this.getPanel().getViewport().toViewPoint(this.coordinates.get(0));
            path.moveTo((float)firstPoint.getX(), (float)firstPoint.getY());
            for (int i = 1; i < this.coordinates.size(); ++i) {
                Coordinate nextCoordinate = this.coordinates.get(i);
                Point2D nextPoint = this.getPanel().getViewport().toViewPoint(nextCoordinate);
                path.lineTo((int)nextPoint.getX(), (int)nextPoint.getY());
            }
            Point2D tentativePoint = this.getPanel().getViewport().toViewPoint(this.tentativeCoordinate);
            path.lineTo((int)tentativePoint.getX(), (int)tentativePoint.getY());
            if (this.closeRing) {
                path.lineTo((int)firstPoint.getX(), (int)firstPoint.getY());
            }
        }
        return path;
    }

    protected boolean isFinishingRelease(MouseEvent e) {
        return e.getClickCount() == 2;
    }

    protected Coordinate[] toArray(List<Coordinate> coordinates) {
        return coordinates.toArray(new Coordinate[0]);
    }

    protected void finishGesture() throws Exception {
        this.clearShape();
        try {
            this.fireGestureFinished();
        }
        finally {
            this.cancelGesture();
        }
    }

    @Override
    public void deactivate() {
        super.deactivate();
        this.getWorkbench().getFrame().removeEasyKeyListener(this.keyListener);
    }

    @Override
    public void activate(LayerViewPanel new_panel) {
        LayerViewPanel panel = this.getPanel();
        if (panel != null && !panel.equals(new_panel)) {
            this.cancelGesture();
        }
        super.activate(new_panel);
        new_panel.getWorkBenchFrame().addEasyKeyListener(this.keyListener);
    }
}

