/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.cursortool;

import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.ui.cursortool.CoordinateListMetrics;
import com.vividsolutions.jump.workbench.ui.cursortool.MultiClickTool;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.Icon;
import org.locationtech.jts.geom.Coordinate;

public class MeasureTool
extends MultiClickTool {
    public MeasureTool(WorkbenchContext context) {
        super(context);
        this.allowSnapping();
        this.setMetricsDisplay(new CoordinateListMetrics());
        this.setCloseRing(true);
    }

    @Override
    public Icon getIcon() {
        return IconLoader.icon("Ruler.gif");
    }

    @Override
    public Cursor getCursor() {
        return MeasureTool.createCursor(IconLoader.icon("RulerCursor.gif").getImage());
    }

    @Override
    public void mouseLocationChanged(MouseEvent e) {
        try {
            if (this.isShapeOnScreen()) {
                ArrayList<Coordinate> currentCoordinates = new ArrayList<Coordinate>(this.getCoordinates());
                currentCoordinates.add(this.getPanel().getViewport().toModelCoordinate(e.getPoint()));
            }
            super.mouseLocationChanged(e);
        }
        catch (Throwable t) {
            this.getPanel().getContext().handleThrowable(t);
        }
    }

    @Override
    protected void gestureFinished() {
        this.reportNothingToUndoYet();
        this.getMetrics().displayMetrics(this.getCoordinates(), this.getPanel());
    }
}

