/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.cursortool;

import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.FenceLayerFinder;
import com.vividsolutions.jump.workbench.ui.cursortool.DrawRectangleFenceTool;
import com.vividsolutions.jump.workbench.ui.cursortool.PolygonTool;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import java.awt.Cursor;
import java.awt.geom.NoninvertibleTransformException;
import javax.swing.Icon;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Polygon;

public class DrawPolygonFenceTool
extends PolygonTool {
    public DrawPolygonFenceTool(WorkbenchContext context) {
        super(context);
        this.setColor(DrawRectangleFenceTool.COLOR);
    }

    @Override
    public Cursor getCursor() {
        return DrawPolygonFenceTool.createCursor(IconLoader.icon("FenceCursor.gif").getImage());
    }

    @Override
    public Icon getIcon() {
        return IconLoader.icon("Box.gif");
    }

    private boolean doubleClicked() {
        return this.getCoordinates().size() == 1;
    }

    @Override
    protected void gestureFinished() throws NoninvertibleTransformException {
        Polygon fence;
        this.reportNothingToUndoYet();
        if (this.doubleClicked()) {
            fence = null;
        } else {
            if (!this.checkPolygon()) {
                return;
            }
            this.getPanel().setViewportInitialized(true);
            fence = this.getPolygon();
        }
        FenceLayerFinder fenceLayerFinder = new FenceLayerFinder(this.getPanel());
        fenceLayerFinder.setFence((Geometry)fence);
        if (!fenceLayerFinder.getLayer().isVisible()) {
            fenceLayerFinder.getLayer().setVisible(true);
        }
    }
}

