/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui;

import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import java.util.Calendar;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.commons.lang3.StringUtils;
import org.openjump.core.CheckOS;

public class SplashPanelV2
extends JPanel {
    JPanel txt_panel;
    static Double javaVersion = 0.0;

    public SplashPanelV2(ImageIcon image, String caption) {
        super(new BorderLayout());
        if (SplashPanelV2.transparentSplash()) {
            this.setBackground(new Color(255, 255, 255, 0));
        }
        JPanel img_panel = new JPanel(new BorderLayout());
        if (SplashPanelV2.itsThatTimeAgain()) {
            image = SplashPanelV2.gimmick(image);
        }
        JLabel img_label = new JLabel(image);
        if (SplashPanelV2.transparentSplash()) {
            img_panel.setBackground(new Color(255, 255, 255, 0));
        }
        img_panel.add(img_label);
        this.txt_panel = new JPanel(new GridBagLayout());
        this.txt_panel.setBackground(Color.white);
        JLabel cap_label = new JLabel(caption);
        cap_label.setFont(cap_label.getFont().deriveFont(1, 20.0f));
        cap_label.setForeground(Color.lightGray);
        if (cap_label.getPreferredSize().width > img_label.getPreferredSize().width) {
            cap_label.setPreferredSize(new Dimension(img_label.getPreferredSize().width - 20, cap_label.getPreferredSize().height));
        }
        JLabel stat_label = new JLabel("some info");
        this.txt_panel.add((Component)cap_label, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 13, 0, new Insets(0, 0, 0, 10), 0, 0));
        this.add((Component)img_panel, "North");
        this.add((Component)this.txt_panel, "South");
        int alpha = SplashPanelV2.transparentSplash() ? 0 : 255;
        this.setBorder(BorderFactory.createBevelBorder(0, new Color(255, 255, 255, alpha), new Color(255, 255, 255, alpha), new Color(103, 101, 98, alpha), new Color(148, 145, 140, alpha)));
    }

    public static boolean itsThatTimeAgain() {
        Calendar now = Calendar.getInstance();
        int day = now.get(5);
        int month = now.get(2);
        return month == 11 && day >= 18 && day <= 31;
    }

    private static ImageIcon gimmick(ImageIcon image) {
        return SplashPanelV2.gimmick(image, IconLoader.icon("hat.png"), 1.0f, 333, 22);
    }

    public static ImageIcon gimmick(ImageIcon orig, ImageIcon ovl, float scale, int placement_x, int placement_y) {
        BufferedImage combined = new BufferedImage(orig.getIconWidth(), orig.getIconHeight(), 2);
        Graphics g = combined.getGraphics();
        g.drawImage(orig.getImage(), 0, 0, null);
        if (scale != 1.0f) {
            int w = Math.round((float)ovl.getIconWidth() * scale);
            int h = Math.round((float)ovl.getIconHeight() * scale);
            ovl = GUIUtil.resize(ovl, w, h);
        }
        g.drawImage(ovl.getImage(), placement_x, placement_y, null);
        return new ImageIcon(combined);
    }

    public void addProgressMonitor(JComponent pm) {
        this.txt_panel.add((Component)pm, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 10, 4, 0), 0, 0));
    }

    public static boolean transparentSplash() {
        return GUIUtil.isPerPixelTranslucencySupported() && !CheckOS.isLinux();
    }

    private static Double getJavaVersion() {
        if (javaVersion > 0.0) {
            return javaVersion;
        }
        String version = System.getProperty("java.version");
        int pos = StringUtils.ordinalIndexOf((CharSequence)version, (CharSequence)".", (int)2);
        javaVersion = Double.parseDouble(version.substring(0, pos));
        return javaVersion;
    }
}

