/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui;

import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.workbench.model.CategoryEvent;
import com.vividsolutions.jump.workbench.model.FeatureEvent;
import com.vividsolutions.jump.workbench.model.FeatureEventType;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerEvent;
import com.vividsolutions.jump.workbench.model.LayerEventType;
import com.vividsolutions.jump.workbench.model.LayerListener;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.model.LayerManagerProxy;
import com.vividsolutions.jump.workbench.ui.AbstractSelection;
import com.vividsolutions.jump.workbench.ui.FeatureSelection;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.LineStringSelection;
import com.vividsolutions.jump.workbench.ui.PartSelection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.locationtech.jts.geom.Geometry;

public class SelectionManager {
    private FeatureSelection featureSelection;
    private PartSelection partSelection;
    private LineStringSelection lineStringSelection;
    private LayerManagerProxy layerManagerProxy;
    private LayerViewPanel panel;
    protected int featuresWithSelectedItemsCount = 0;
    protected int selectedItems = 0;
    private boolean panelUpdatesEnabled = true;
    private LayerListener layerListener = new LayerListener(){

        @Override
        public void featuresChanged(FeatureEvent e) {
            if (e.getType() == FeatureEventType.DELETED) {
                for (Feature feature : e.getFeatures()) {
                    SelectionManager.this.featureSelection.unselectItems(e.getLayer(), feature);
                    SelectionManager.this.partSelection.unselectItems(e.getLayer(), feature);
                    SelectionManager.this.lineStringSelection.unselectItems(e.getLayer(), feature);
                }
                SelectionManager.this.updatePanel();
            }
            if (e.getType() == FeatureEventType.GEOMETRY_MODIFIED) {
                SelectionManager.this.unselectFromFeaturesWithModifiedItemCounts(e.getLayer(), e.getFeatures(), e.getOldFeatureClones());
            }
        }

        @Override
        public void layerChanged(LayerEvent e) {
            if (!(e.getLayerable() instanceof Layer)) {
                return;
            }
            if (e.getType() == LayerEventType.REMOVED || e.getType() == LayerEventType.VISIBILITY_CHANGED) {
                SelectionManager.this.unselectItems((Layer)e.getLayerable());
            }
        }

        @Override
        public void categoryChanged(CategoryEvent e) {
        }
    };
    private List<AbstractSelection> selections;

    public Collection<Feature> createFeaturesFromSelectedItems() {
        ArrayList<Feature> newFeatures = new ArrayList<Feature>();
        for (Layer layer : this.getLayersWithSelectedItems()) {
            newFeatures.addAll(this.createFeaturesFromSelectedItems(layer));
        }
        return newFeatures;
    }

    public Collection<Feature> createFeaturesFromSelectedItems(Layer layer) {
        ArrayList<Feature> newFeatures = new ArrayList<Feature>();
        for (Feature feature : this.getFeaturesWithSelectedItems(layer)) {
            for (Geometry item : this.getSelectedItems(layer, feature)) {
                Feature newFeature = feature.clone(false);
                newFeature.setGeometry(item);
                newFeatures.add(newFeature);
            }
        }
        return newFeatures;
    }

    public SelectionManager(LayerViewPanel panel, LayerManagerProxy layerManagerProxy) {
        this.panel = panel;
        this.layerManagerProxy = layerManagerProxy;
        this.featureSelection = new FeatureSelection(this);
        this.partSelection = new PartSelection(this);
        this.lineStringSelection = new LineStringSelection(this);
        this.featureSelection.setParent(null);
        this.featureSelection.setChild(this.partSelection);
        this.partSelection.setParent(this.featureSelection);
        this.partSelection.setChild(this.lineStringSelection);
        this.lineStringSelection.setParent(this.partSelection);
        this.lineStringSelection.setChild(null);
        this.selections = Collections.unmodifiableList(Arrays.asList(this.featureSelection, this.partSelection, this.lineStringSelection));
        this.addLayerListenerTo(layerManagerProxy.getLayerManager());
    }

    private void addLayerListenerTo(LayerManager layerManager) {
        layerManager.addLayerListener(this.layerListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        boolean originalPanelUpdatesEnabled = this.arePanelUpdatesEnabled();
        this.setPanelUpdatesEnabled(false);
        try {
            for (AbstractSelection selection : this.selections) {
                selection.unselectItems();
            }
            this.updatePanel();
        }
        finally {
            this.setPanelUpdatesEnabled(originalPanelUpdatesEnabled);
        }
    }

    public FeatureSelection getFeatureSelection() {
        return this.featureSelection;
    }

    public LineStringSelection getLineStringSelection() {
        return this.lineStringSelection;
    }

    public Collection<AbstractSelection> getSelections() {
        return this.selections;
    }

    public Collection<Geometry> getSelectedItems() {
        ArrayList<Geometry> selectedItems = new ArrayList<Geometry>();
        for (AbstractSelection selection : this.selections) {
            selectedItems.addAll(selection.getSelectedItems());
        }
        return selectedItems;
    }

    public int getSelectedItemsCount() {
        return this.selectedItems;
    }

    public Collection<Geometry> getSelectedItems(Layer layer) {
        ArrayList<Geometry> selectedItems = new ArrayList<Geometry>();
        for (AbstractSelection selection : this.selections) {
            selectedItems.addAll(selection.getSelectedItems(layer));
        }
        return selectedItems;
    }

    public Collection<Geometry> getSelectedItems(Layer layer, Feature feature) {
        ArrayList<Geometry> selectedItems = new ArrayList<Geometry>();
        for (AbstractSelection selection : this.selections) {
            selectedItems.addAll(selection.getSelectedItems(layer, feature));
        }
        return selectedItems;
    }

    public Collection<Geometry> getSelectedItems(Layer layer, Feature feature, Geometry geometry) {
        ArrayList<Geometry> selectedItems = new ArrayList<Geometry>();
        for (AbstractSelection selection : this.selections) {
            selectedItems.addAll(selection.getSelectedItems(layer, feature, geometry));
        }
        return selectedItems;
    }

    public Collection<Layer> getLayersWithSelectedItems() {
        LinkedHashSet<Layer> layersWithSelectedItems = new LinkedHashSet<Layer>();
        for (AbstractSelection selection : this.selections) {
            layersWithSelectedItems.addAll(selection.getLayersWithSelectedItems());
        }
        return layersWithSelectedItems;
    }

    public PartSelection getPartSelection() {
        return this.partSelection;
    }

    public void updatePanel() {
        if (!this.panelUpdatesEnabled) {
            return;
        }
        this.selectedItems = this.getSelectedItems().size();
        this.featuresWithSelectedItemsCount = this.getFeaturesWithSelectedItems().size();
        this.panel.fireSelectionChanged();
        this.panel.getRenderingManager().render("SELECTION_BACKGROUND");
        for (AbstractSelection selection : this.selections) {
            this.panel.getRenderingManager().render(selection.getRendererContentID());
        }
    }

    public void setPanelUpdatesEnabled(boolean panelUpdatesEnabled) {
        this.panelUpdatesEnabled = panelUpdatesEnabled;
    }

    public Collection<Feature> getFeaturesWithSelectedItems(Layer layer) {
        LinkedHashSet<Feature> featuresWithSelectedItems = new LinkedHashSet<Feature>();
        for (AbstractSelection selection : this.selections) {
            featuresWithSelectedItems.addAll(selection.getFeaturesWithSelectedItems(layer));
        }
        return featuresWithSelectedItems;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unselectItems(Layer layer) {
        boolean originalPanelUpdatesEnabled = this.arePanelUpdatesEnabled();
        this.setPanelUpdatesEnabled(false);
        try {
            for (AbstractSelection selection : this.selections) {
                selection.unselectItems(layer);
            }
        }
        finally {
            this.setPanelUpdatesEnabled(originalPanelUpdatesEnabled);
        }
        this.updatePanel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unselectItems(Layer layer, Collection features) {
        boolean originalPanelUpdatesEnabled = this.arePanelUpdatesEnabled();
        this.setPanelUpdatesEnabled(false);
        try {
            for (AbstractSelection selection : this.selections) {
                selection.unselectItems(layer, features);
            }
        }
        finally {
            this.setPanelUpdatesEnabled(originalPanelUpdatesEnabled);
        }
        this.updatePanel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unselectFromFeaturesWithModifiedItemCounts(Layer layer, Collection<Feature> features, Collection<Feature> oldFeatureClones) {
        boolean originalPanelUpdatesEnabled = this.arePanelUpdatesEnabled();
        this.setPanelUpdatesEnabled(false);
        try {
            for (AbstractSelection selection : this.selections) {
                selection.unselectFromFeaturesWithModifiedItemCounts(layer, features, oldFeatureClones);
            }
        }
        finally {
            this.setPanelUpdatesEnabled(originalPanelUpdatesEnabled);
        }
        this.updatePanel();
    }

    public Collection<Feature> getFeaturesWithSelectedItems() {
        ArrayList<Feature> featuresWithSelectedItems = new ArrayList<Feature>();
        for (Layer layer : this.getLayersWithSelectedItems()) {
            featuresWithSelectedItems.addAll(this.getFeaturesWithSelectedItems(layer));
        }
        return featuresWithSelectedItems;
    }

    public int getFeaturesWithSelectedItemsCount() {
        return this.featuresWithSelectedItemsCount;
    }

    public boolean arePanelUpdatesEnabled() {
        return this.panelUpdatesEnabled;
    }

    public void dispose() {
        this.layerManagerProxy.getLayerManager().removeLayerListener(this.layerListener);
    }
}

